/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.armoreablemobs;

import com.buuz135.armoreablemobs.entity.ArmorEntity;
import com.buuz135.armoreablemobs.handler.ArmorGroup;
import com.buuz135.armoreablemobs.handler.ArmorHandler;
import com.buuz135.armoreablemobs.handler.ArmorSlot;
import com.buuz135.armoreablemobs.util.GameStagesSupport;
import com.buuz135.armoreablemobs.util.PackModeSupport;
import com.buuz135.armoreablemobs.util.ZenWeightedRandom;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="armoreablemobs", name="ArmoreableMobs", version="1.1.2", dependencies="required-after:crafttweaker@[1.12-4.0.9,)", acceptedMinecraftVersions="[1.12.2]")
public class ArmoreableMobs {
    public static final String MOD_ID = "armoreablemobs";
    public static final String MOD_NAME = "ArmoreableMobs";
    public static final String VERSION = "1.1.2";
    public static final String GAMESTAGES = "gamestages";
    public static final String PACKMODE = "packmode";
    public static boolean GAMESTAGES_LOADED = false;
    public static boolean PACKMODE_LOADED = false;
    @Mod.Instance(value="armoreablemobs")
    public static ArmoreableMobs INSTANCE;
    private static List<LivingSpawnEvent.SpecialSpawn> events;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        GAMESTAGES_LOADED = Loader.isModLoaded((String)GAMESTAGES);
        PACKMODE_LOADED = Loader.isModLoaded((String)PACKMODE);
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        events.add(event);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent tickEvent) {
        ArrayList<LivingSpawnEvent.SpecialSpawn> remove = new ArrayList<LivingSpawnEvent.SpecialSpawn>();
        for (LivingSpawnEvent.SpecialSpawn event : events) {
            if (event.isCanceled() || event.getEntity().field_70128_L) {
                remove.add(event);
                continue;
            }
            this.checkForArmor(event.getEntity());
            for (Entity entity : event.getEntity().func_184188_bt()) {
                this.checkForArmor(entity);
            }
            remove.add(event);
        }
        events.removeAll(remove);
    }

    private void checkForArmor(Entity entityCheck) {
        if (entityCheck instanceof EntityLiving) {
            for (ArmorGroup group : ArmorHandler.ARMOR_GROUPS) {
                if (!this.isGroupInPackMode(group) || !this.isSomeoneInStage(entityCheck, group)) continue;
                for (ArmorEntity entity : group.getEntities()) {
                    if (!entity.checkEntity(entityCheck) || entityCheck.field_70170_p.field_73012_v.nextDouble() > group.getChance()) continue;
                    for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                        List<ArmorSlot> armorSlots = this.generateList(slot, group, entityCheck);
                        if (armorSlots.size() <= 0) continue;
                        ArmorSlot winner = ZenWeightedRandom.getRandomItem(entityCheck.field_70170_p.field_73012_v, armorSlots);
                        entityCheck.func_184201_a(slot, winner.getStack() == null ? ItemStack.field_190927_a : ((ItemStack)winner.getStack().getInternal()).func_77946_l());
                        ((EntityLiving)entityCheck).func_184642_a(slot, (float)winner.getChanceToDrop());
                    }
                }
            }
        }
    }

    private List<ArmorSlot> generateList(EntityEquipmentSlot slot, ArmorGroup group, Entity entity) {
        ArrayList<ArmorSlot> slots = new ArrayList<ArmorSlot>();
        for (ArmorSlot groupSlot : group.getSlots()) {
            if (!groupSlot.getSlot().equals(slot.func_188450_d()) || !groupSlot.canReplace() && !((ItemStack)Lists.newArrayList((Iterable)entity.func_184209_aF()).get(slot.func_188452_c())).func_190926_b()) continue;
            slots.add(groupSlot);
        }
        return slots;
    }

    private boolean isSomeoneInStage(Entity entity, ArmorGroup group) {
        return !GAMESTAGES_LOADED || group.getGameStages().size() == 0 || GameStagesSupport.checkForStages(entity, group);
    }

    private boolean isGroupInPackMode(ArmorGroup group) {
        return !PACKMODE_LOADED || group.getPackMode() == null || PackModeSupport.isPackModeEnabled(group.getPackMode());
    }

    static {
        events = new ArrayList<LivingSpawnEvent.SpecialSpawn>();
    }
}

