/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.blocks.plants.wood.CoryphaStalk;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.feature.plants.GenCoryphaWorld;
import nmd.primal.core.common.world.feature.plants.GenGrass;
import nmd.primal.core.common.world.feature.plants.GenHangingPlant;
import nmd.primal.core.common.world.feature.plants.GenPlantNearMaterial;
import nmd.primal.core.common.world.feature.plants.GenTallPlants;

public class NetherPlants
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ModConfig.Worldgen.ENABLE_GENERATION_NETHER && (world.field_73011_w.func_186058_p() == DimensionType.NETHER || ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS && world.field_73011_w.func_177495_o())) {
            int i;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            if (ModConfig.Worldgen.ENABLE_STRANGLE_WEED && PrimalAPI.randomCheck(PrimalCore.RANDOM, 16)) {
                for (i = 0; i < 24; ++i) {
                    new GenHangingPlant(PrimalAPI.Blocks.STRANGLE_WEED, 8, 36, BlockMultiplexer.forBlock(Blocks.field_150424_aL, Blocks.field_150385_bj, ModCompat.NEX_NETHERRACK)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(45, 120)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_NETHER_VINES && PrimalAPI.randomCheck(PrimalCore.RANDOM, 6)) {
                for (i = 0; i < 40; ++i) {
                    new GenHangingPlant(PrimalAPI.Blocks.INFERUM_VINE, 16, 36, BlockMultiplexer.forBlock(Blocks.field_150424_aL, Blocks.field_150385_bj, Blocks.field_150426_aN, ModCompat.NEX_NETHERRACK)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(60, 116)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_NETHER_DEADBUSH && PrimalAPI.randomCheck(PrimalCore.RANDOM, 16)) {
                for (i = 0; i < 24; ++i) {
                    new GenGrass(16, PrimalAPI.Blocks.NETHER_BUSH.func_176223_P(), BlockMultiplexer.forBlock(Blocks.field_150385_bj, Blocks.field_150426_aN, Blocks.field_189877_df)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(32, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_NETHER_PALM && PrimalAPI.randomCheck(PrimalCore.RANDOM, 10)) {
                for (i = 0; i < 32; ++i) {
                    new GenCoryphaWorld((CoryphaStalk)PrimalAPI.Blocks.CORYPHA_STALK, 16).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(32, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_VALUS_OMNIFERUM && PrimalAPI.randomCheck(PrimalCore.RANDOM, 8)) {
                for (i = 0; i < 24; ++i) {
                    new GenTallPlants((AbstractPlantGrowing)PrimalAPI.Blocks.VALUS_OMNIFERUM, PrimalCore.RANDOM.nextInt(8, 24)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(32, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_DAUCUS_MURN && PrimalAPI.randomCheck(PrimalCore.RANDOM, 24)) {
                for (i = 0; i < 32; ++i) {
                    new GenTallPlants((AbstractPlantGrowing)PrimalAPI.Blocks.DAUCUS_MURN, PrimalCore.RANDOM.nextInt(16, 32)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(32, 92)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_DEVILS_TONGUE && PrimalAPI.randomCheck(PrimalCore.RANDOM, 30)) {
                for (i = 0; i < 24; ++i) {
                    new GenTallPlants((AbstractPlantGrowing)PrimalAPI.Blocks.DEVILS_TONGUE, PrimalCore.RANDOM.nextInt(8, 24)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(32, 92)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_SINUOUS_WEED && PrimalAPI.randomCheck(PrimalCore.RANDOM, 24)) {
                for (i = 0; i < 16; ++i) {
                    BlockPos pos = WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(32, 40));
                    new GenPlantNearMaterial((AbstractPlantGrowing)PrimalAPI.Blocks.SINUOUS_WEED, Material.field_151587_i, 3, PrimalCore.RANDOM.nextInt(8, 16)).func_180709_b(world, PrimalCore.RANDOM, pos);
                }
            }
            if (ModConfig.Worldgen.ENABLE_CINERIS_CILIUM) {
                IBlockState CINERIS_CILIUM = PrimalAPI.Blocks.CINERIS_GRASS.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(4));
                IBlockState CINERIS_BLOOM = PrimalAPI.Blocks.CINERIS_BLOOM.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(true));
                int BLOOM_AMOUNT = (int)Math.floor((double)ModConfig.Worldgen.GEN_CINERIS_AMOUNT * ModConfig.Worldgen.GEN_CINERIS_BLOOM_RATIO);
                for (int i2 = 0; i2 < ModConfig.Worldgen.GEN_CINERIS_AMOUNT; ++i2) {
                    BlockPos pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(12, 120), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenGrass(ModConfig.Worldgen.GEN_CINERIS_AMOUNT, CINERIS_CILIUM.func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(PrimalCore.RANDOM.nextBoolean())), BlockMultiplexer.forBlock(CommonUtils.getBlockList(ModConfig.Worldgen.GEN_CINERIS_BLACKLIST))).func_180709_b(world, PrimalCore.RANDOM, pos)) continue;
                    new GenGrass(BLOOM_AMOUNT, CINERIS_BLOOM, BlockMultiplexer.forBlock(CommonUtils.getBlockList(ModConfig.Worldgen.GEN_CINERIS_BLACKLIST))).func_180709_b(world, PrimalCore.RANDOM, pos);
                }
            }
        }
    }
}

