/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.feature.plants;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.plants.crops.SinuousWeed;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;

public class GenNetherEarthWeed
extends WorldGenerator {
    private final Predicate<IBlockState> predicate;
    private final Block block;
    private SinuousWeed plantBlock = (SinuousWeed)PrimalAPI.Blocks.SINUOUS_WEED;
    private final int radius;
    private String dataName;

    public GenNetherEarthWeed(Block block, int radius, Predicate<IBlockState> predicate, String dataName) {
        this.block = block;
        this.radius = radius;
        this.predicate = predicate;
        this.dataName = dataName;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a() != Material.field_151587_i) {
            return false;
        }
        int i = rand.nextInt(this.radius - 2) + 2;
        int j = 2;
        PendingBlocks pendingBlocks = PendingBlocks.getForWorld(world, this.dataName);
        ChunkPos thisChunk = new ChunkPos(pos);
        for (int k = pos.func_177958_n() - i; k <= pos.func_177958_n() + i; ++k) {
            for (int l = pos.func_177952_p() - i; l <= pos.func_177952_p() + i; ++l) {
                int j1;
                int i1 = k - pos.func_177958_n();
                if (i1 * i1 + (j1 = l - pos.func_177952_p()) * j1 > i * i) continue;
                for (int k1 = pos.func_177956_o() - 2; k1 <= pos.func_177956_o() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    if (WorldHelper.isInChunk(thisChunk, blockpos) || world.func_190526_b(i1 >> 4, j1 >> 4)) {
                        IBlockState state = world.func_180495_p(blockpos);
                        if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, blockpos, this.predicate)) continue;
                        world.func_180501_a(blockpos, this.block.func_176223_P(), 18);
                        if (!ModConfig.Worldgen.ENABLE_SINUOUS_WEED || !PrimalAPI.randomCheck(4) || !world.func_175623_d(blockpos.func_177984_a()) || !world.func_175623_d(blockpos.func_177981_b(2)) || !world.func_175623_d(blockpos.func_177981_b(3)) || !world.func_175623_d(blockpos.func_177981_b(4)) || !CommonUtils.hasNearByMaterial((IBlockAccess)world, blockpos.func_177984_a(), 2, -1, Material.field_151587_i)) continue;
                        this.plantBlock.growFullPlant(world, blockpos.func_177984_a(), this.plantBlock.func_176223_P(), 18);
                        continue;
                    }
                    pendingBlocks.storePending(blockpos, this.block.func_176223_P());
                }
            }
        }
        return true;
    }
}

