/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.ticking;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.tile.KilnCrafting;
import nmd.primal.core.common.tiles.TileSlots;

@Deprecated
public class TileKiln
extends TileSlots
implements ITickable {
    private NonNullList<ItemStack> fuelList = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> inputsList = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> secondaryList = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int iterate = 0;
    private int temp;
    private int maxTemp;
    private int[] counter = new int[]{0, 0, 0, 0};
    private double[] normalX = new double[]{0.375, 0.625};
    private double[] normalZ = new double[]{0.375, 0.625};
    private double[] reverseX = new double[]{0.625, 0.375};
    private double[] reverseZ = new double[]{0.625, 0.375};

    public double getNormalX(Integer x) {
        return this.normalX[x];
    }

    public double getNormalZ(Integer z) {
        return this.normalZ[z];
    }

    public double getReverseX(Integer x) {
        return this.reverseX[x];
    }

    public double getReverseZ(Integer z) {
        return this.reverseZ[z];
    }

    public int[] getCounter() {
        return this.counter;
    }

    public void setCounter(int[] counter) {
        this.counter = counter;
    }

    public int getCounterTime(Integer c) {
        return this.counter[c];
    }

    public int getMaxTemp() {
        return this.maxTemp;
    }

    public void setMaxTemp(int maxTemp) {
        this.maxTemp = maxTemp;
    }

    public int getTemp() {
        return this.temp;
    }

    public void setTemp(int temp) {
        this.temp = temp;
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            if (this.counter.length == 0) {
                this.counter = new int[]{0, 0, 0, 0};
            }
            IBlockState state = world.func_180495_p(this.field_174879_c);
            ItemStack fuelStack = this.getFuelStack(0);
            float fuelStackSize = 1.0f + (float)(this.getFuelSize(0) / 64);
            if ((this.iterate == 50 || this.iterate == 100) && !fuelStack.func_190926_b() && ((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
                RecipeHelper.fuelManager(world, this, fuelStack);
                if (PrimalAPI.randomCheck(100)) {
                    FireHelper.makeSmoke(world, this.field_174879_c.func_177981_b(2));
                }
            }
            if (this.iterate == 100) {
                int burnTime;
                if (fuelStack.func_190926_b()) {
                    this.setTemp(this.getTemp() - 50);
                } else if (!fuelStack.func_190926_b() && this.getTemp() < this.getMaxTemp()) {
                    this.setTemp(this.getTemp() + 50);
                }
                if (fuelStack.func_190926_b()) {
                    world.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
                }
                if ((burnTime = RecipeHelper.getBurnTime(fuelStack)) > 0) {
                    this.setMaxTemp(Math.round((float)burnTime * fuelStackSize));
                }
                this.iterate = 0;
            }
            ++this.iterate;
            this.doCooking();
        }
    }

    private void doCooking() {
        for (int i = 0; i < this.inputsList.size(); ++i) {
            if (!this.getInputsStack(i).func_190926_b()) {
                KilnCrafting recipe = KilnCrafting.getRecipe(this.getInputsStack(i));
                if (recipe == null) continue;
                if (this.getTemp() >= recipe.getMinHeat()) {
                    int n = i;
                    this.counter[n] = this.counter[n] + 1;
                }
                if (this.getTemp() > recipe.getMaxHeat() && this.counter[i] >= recipe.getIdealTime()) {
                    this.setInputsSlotStack(i, recipe.getFailedOutput());
                    this.counter[i] = 0;
                }
                if (this.counter[i] < recipe.getIdealTime()) continue;
                this.setInputsSlotStack(i, recipe.getOutputPrimary());
                if (!recipe.getOutputSecondary().func_190926_b()) {
                    this.setSecondarySlotStack(i, recipe.getOutputSecondary());
                }
                this.counter[i] = 0;
                continue;
            }
            this.counter[i] = 0;
        }
    }

    public NonNullList<ItemStack> getFuelList() {
        return this.fuelList;
    }

    public void setFuelList(NonNullList<ItemStack> fuelList) {
        this.fuelList = fuelList;
    }

    public ItemStack getFuelStack(int i) {
        return (ItemStack)this.fuelList.get(i);
    }

    public int getFuelSize(int i) {
        return this.getFuelStack(i).func_190916_E();
    }

    public int getFuelSlotListSize() {
        return this.getFuelList().size();
    }

    public int getFuelSlotLimit() {
        return 64;
    }

    public NonNullList<ItemStack> takeFuelStacks() {
        NonNullList<ItemStack> fuel_stack = this.getFuelList();
        if (!fuel_stack.isEmpty()) {
            this.clearSlot(this.fuelList);
        }
        return fuel_stack;
    }

    public ItemStack takeFuelSlotStack(int i) {
        ItemStack fuel_stack = this.getFuelStack(i);
        if (!fuel_stack.func_190926_b()) {
            this.clearFuelSlot(i);
        }
        return fuel_stack;
    }

    public void setFuelSlotStack(int index, ItemStack stack) {
        this.fuelList.set(index, (Object)stack);
        this.func_70296_d();
        this.updateBlock();
    }

    public void clearFuelSlot(int i) {
        this.fuelList.set(i, (Object)ItemStack.field_190927_a);
    }

    public NonNullList<ItemStack> getInputsList() {
        return this.inputsList;
    }

    public void setInputsList(NonNullList<ItemStack> inputsList) {
        this.inputsList = inputsList;
    }

    public ItemStack getInputsStack(int i) {
        return (ItemStack)this.inputsList.get(i);
    }

    public int getInputsSize(int i) {
        return this.getInputsStack(i).func_190916_E();
    }

    public int getInputsSlotListSize() {
        return this.getInputsList().size();
    }

    public int getInputslSlotLimit() {
        return 1;
    }

    public NonNullList<ItemStack> takeInputsStacks() {
        NonNullList<ItemStack> input_stack = this.getInputsList();
        if (!input_stack.isEmpty()) {
            this.clearSlot(this.inputsList);
        }
        return input_stack;
    }

    public ItemStack takeInputsSlotStack(int i) {
        ItemStack inputs_stack = this.getInputsStack(i);
        if (!inputs_stack.func_190926_b()) {
            this.clearInputsSlot(i);
        }
        return inputs_stack;
    }

    public void setInputsSlotStack(int index, ItemStack stack) {
        this.inputsList.set(index, (Object)stack);
        this.func_70296_d();
        this.updateBlock();
    }

    public void clearInputsSlot(int i) {
        this.inputsList.set(i, (Object)ItemStack.field_190927_a);
    }

    public NonNullList<ItemStack> getSecondaryList() {
        return this.secondaryList;
    }

    public void setSecondaryList(NonNullList<ItemStack> secondaryList) {
        this.secondaryList = secondaryList;
    }

    public ItemStack getSecondaryStack(int i) {
        return (ItemStack)this.secondaryList.get(i);
    }

    public int getSecondarySize(int i) {
        return this.getSecondaryStack(i).func_190916_E();
    }

    public int getSecondarySlotListSize() {
        return this.getSecondaryList().size();
    }

    public int getSecondarySlotLimit() {
        return 1;
    }

    public NonNullList<ItemStack> takeSecondaryStacks() {
        NonNullList<ItemStack> secondary_stack = this.getSecondaryList();
        if (!secondary_stack.isEmpty()) {
            this.clearSlot(this.secondaryList);
        }
        return secondary_stack;
    }

    public ItemStack takeSecondarySlotStack(int i) {
        ItemStack secondary_stack = this.getSecondaryStack(i);
        if (!secondary_stack.func_190926_b()) {
            this.clearSecondarySlot(i);
        }
        return secondary_stack;
    }

    public void setSecondarySlotStack(int index, ItemStack stack) {
        this.secondaryList.set(index, (Object)stack);
        this.func_70296_d();
        this.updateBlock();
    }

    public void clearSecondarySlot(int i) {
        this.secondaryList.set(i, (Object)ItemStack.field_190927_a);
    }

    public void clearSlot(NonNullList<ItemStack> list) {
        list.clear();
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        this.fuelList = NonNullList.func_191197_a((int)this.fuelList.size(), (Object)ItemStack.field_190927_a);
        this.inputsList = NonNullList.func_191197_a((int)this.inputsList.size(), (Object)ItemStack.field_190927_a);
        this.secondaryList = NonNullList.func_191197_a((int)this.secondaryList.size(), (Object)ItemStack.field_190927_a);
        this.counter = nbt.func_74759_k("counter");
        this.temp = nbt.func_74762_e("temp");
        NBTHelper.readNBTItems(nbt, this.fuelList, "Fuel");
        NBTHelper.readNBTItems(nbt, this.inputsList, "Input");
        NBTHelper.readNBTItems(nbt, this.secondaryList, "Secondary");
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        NBTHelper.saveNBTItems(nbt, this.fuelList, "Fuel");
        NBTHelper.saveNBTItems(nbt, this.inputsList, "Input");
        NBTHelper.saveNBTItems(nbt, this.secondaryList, "Secondary");
        nbt.func_74783_a("counter", this.counter);
        nbt.func_74768_a("temp", this.temp);
        return nbt;
    }
}

