/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.storage.IItemStorage;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.tiles.AbstractTileType;

public class TileShelf
extends AbstractTileType
implements IItemStorage {
    private ItemStackHandler storageHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileShelf.this.updateBlock();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };

    @Override
    public ItemStackHandler getStorageHandler() {
        return this.storageHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.getStorageHandler() != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.getStorageHandler() != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getStorageHandler() != null) {
            return (T)this.getStorageHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("storage", 10)) {
            this.getStorageHandler().deserializeNBT(nbt.func_74775_l("storage"));
        } else {
            this.storageHandler = new ItemStackHandler(this.getStorageHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getStorageHandler(), "storage");
        }
        this.setPhase(nbt.func_74767_n("phase"));
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeStorageHandler(nbt, this.getStorageHandler(), "storage");
        nbt.func_74757_a("phase", this.isPhased());
        return nbt;
    }
}

