/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.storage.IItemFuel;
import nmd.primal.core.api.interfaces.storage.IItemStorage;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.AbstractTileType;

public class TileFishTrap
extends AbstractTileType
implements IItemStorage,
IItemFuel {
    private final int TRAP_SIZE = 6;
    private ItemStackHandler trapHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileFishTrap.this.func_145831_w().func_180495_p(TileFishTrap.this.field_174879_c);
            TileFishTrap.this.func_70296_d();
            TileFishTrap.this.func_145831_w().func_184138_a(TileFishTrap.this.field_174879_c, state, state, 3);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private ItemStackHandler baitHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileFishTrap.this.func_145831_w().func_180495_p(TileFishTrap.this.field_174879_c);
            TileFishTrap.this.func_70296_d();
            TileFishTrap.this.func_145831_w().func_184138_a(TileFishTrap.this.field_174879_c, state, state, 3);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };

    @Override
    public ItemStackHandler getStorageHandler() {
        return this.trapHandler;
    }

    @Override
    public ItemStackHandler getFuelHandler() {
        return this.baitHandler;
    }

    @Override
    public boolean isValidFuel(ItemStack stack) {
        return RecipeHelper.isOreName(stack, "foodBait", "foodFat");
    }

    public int getBaitAmount() {
        return this.getFuelHandler().getStackInSlot(0).func_190916_E();
    }

    public boolean canBait() {
        PrimalAPI.logger(20, "fish trap", "can bait: " + this.getBaitAmount() + ":" + this.getFuelHandler().getSlotLimit(0));
        return this.getBaitAmount() < this.getFuelHandler().getSlotLimit(0);
    }

    public boolean hasBait() {
        return !this.getFuelHandler().getStackInSlot(0).func_190926_b();
    }

    public void consumeBait(int amount) {
        if (this.hasBait()) {
            this.getFuelHandler().getStackInSlot(0).func_190918_g(amount);
        }
    }

    public boolean isFull() {
        for (int i = 0; i < this.getStorageHandler().getSlots(); ++i) {
            if (!this.getStorageHandler().getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean hasFish() {
        for (int i = 0; i < this.getStorageHandler().getSlots(); ++i) {
            if (!(this.getStorageHandler().getStackInSlot(i).func_77973_b() instanceof ItemFood)) continue;
            return true;
        }
        return false;
    }

    public void clearBait() {
        this.clearSlots(this.getFuelHandler());
        this.updateBlock();
    }

    public void clearTrap() {
        this.clearSlots(this.getStorageHandler());
        this.updateBlock();
    }

    public void resetTrap() {
        this.clearSlots(this.getFuelHandler());
        this.clearSlots(this.getStorageHandler());
        this.updateBlock();
    }

    public int getFirstAvailableSlot(ItemStackHandler stackHandler) {
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            if (!this.getStorageHandler().getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int getAvailableSlots(ItemStackHandler stackHandler) {
        int slots = 0;
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            if (!this.getStorageHandler().getStackInSlot(i).func_190926_b()) continue;
            ++slots;
        }
        return slots;
    }

    public void fillSlotFromLootTable(ResourceLocation table, Random random) {
        ItemStackHandler handler = this.getStorageHandler();
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
        List loot = this.field_145850_b.func_184146_ak().func_186521_a(table).func_186462_a(random, lootcontext$builder.func_186471_a());
        if (loot.size() > 0) {
            ItemStack loot_stack = ((ItemStack)loot.get(random.nextInt(loot.size()))).func_77946_l();
            ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)loot_stack, (boolean)false);
        }
    }

    public boolean baitTrap(World world, BlockPos pos, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (!this.checkFrontWaterAccess(world, pos, this.getFrontFace(), 2)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + I18n.func_74838_a((String)"chat.message.primal.fish_trap_needs_water"), new Object[0]));
            return false;
        }
        if (this.canBait() && this.isValidFuel(stack)) {
            ItemStackHandler handler = this.getFuelHandler();
            ItemStack bait = stack.func_77946_l();
            int amount = player.func_70093_af() ? stack.func_190916_E() : 1;
            bait.func_190920_e(amount);
            stack.func_190918_g(amount);
            ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)bait, (boolean)false);
            this.updateBlock();
            PrimalAPI.logger(20, "schedule", "@" + pos + ", TileFishTrap#baitTrap");
            PrimalAPI.scheduleBlock(world, pos, state);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7oTrap has " + this.getBaitAmount() + " bait", new Object[0]));
            return true;
        }
        if (!this.hasStorageItems()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7o" + (this.hasBait() ? "Trap has " + this.getBaitAmount() + " bait" : "Trap needs to be baited"), new Object[0]));
        }
        return false;
    }

    public boolean goFish(World world, BlockPos pos) {
        ResourceLocation TABLE_TREASURE;
        ResourceLocation TABLE_JUNK;
        ResourceLocation TABLE_FISH;
        if (!this.hasBait()) {
            return false;
        }
        PrimalAPI.logger(20, "fish trap", "go fish: " + ModConfig.Machines.FISH_TRAP_BASE_CATCH);
        float CHANCE_FISH = world.func_72935_r() ? (float)ModConfig.Machines.FISH_TRAP_BASE_CATCH : (float)(ModConfig.Machines.FISH_TRAP_BASE_CATCH + 0.1);
        float CHANCE_JUNK = (float)ModConfig.Machines.FISH_TRAP_BASE_JUNK;
        float CHANCE_TREASURE = (float)ModConfig.Machines.FISH_TRAP_BASE_TREASURE;
        Material material = this.field_145850_b.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151586_h) {
            Biome biome = world.func_180494_b(pos);
            TABLE_FISH = LootTableList.field_186390_ao;
            TABLE_JUNK = ModLoot.FISH_TRAP_WATER_JUNK;
            TABLE_TREASURE = WorldHelper.biomeHasType(biome, BiomeDictionary.Type.OCEAN) ? ModLoot.FISH_TRAP_WATER_TREASURE_OCEAN : (WorldHelper.biomeHasType(biome, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.JUNGLE) ? ModLoot.FISH_TRAP_WATER_TREASURE_RIVER : (WorldHelper.biomeHasType(biome, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SPOOKY) ? ModLoot.FISH_TRAP_WATER_TREASURE_SWAMP : ModLoot.FISH_TRAP_WATER_TREASURE));
        } else if (material == Material.field_151587_i) {
            TABLE_FISH = ModLoot.GAMEPLAY_FISH_TRAP_LAVA_FISH;
            TABLE_JUNK = ModLoot.GAMEPLAY_FISH_TRAP_LAVA_JUNK;
            TABLE_TREASURE = ModLoot.GAMEPLAY_FISH_TRAP_LAVA_TREASURE;
        } else {
            return false;
        }
        if (PrimalAPI.randomCheck(CHANCE_JUNK)) {
            PrimalAPI.logger(20, "fish trap", "catching junk");
            this.fillSlotFromLootTable(TABLE_JUNK, this.RANDOM);
        }
        if (PrimalAPI.randomCheck(CHANCE_TREASURE)) {
            PrimalAPI.logger(20, "fish trap", "catching treasure");
            this.fillSlotFromLootTable(TABLE_TREASURE, this.RANDOM);
        }
        if (PrimalAPI.randomCheck(CHANCE_FISH)) {
            ItemStackHandler handler = this.getStorageHandler();
            for (int i = 0; i < this.RANDOM.nextInt(1, 3); ++i) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
                List fish = world.func_184146_ak().func_186521_a(TABLE_FISH).func_186462_a((Random)this.RANDOM, lootcontext$builder.func_186471_a());
                if (fish.size() <= 0) continue;
                ItemStack stack = ((ItemStack)fish.get(this.RANDOM.nextInt(fish.size()))).func_77946_l();
                ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                this.consumeBait(1);
                return true;
            }
        }
        return false;
    }

    public boolean checkFrontWaterAccess(World world, BlockPos pos, EnumFacing face, int range) {
        for (int i = 0; i <= range; ++i) {
            if (world.func_180495_p(pos.func_177967_a(face, i)).func_185904_a() == world.func_180495_p(pos).func_185904_a()) continue;
            return false;
        }
        return true;
    }

    public boolean checkFrontWaterAccess(World world, BlockPos pos) {
        return this.checkFrontWaterAccess(world, pos, this.getFrontFace(), 2);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null && facing == EnumFacing.UP) {
                return (T)this.baitHandler;
            }
            return (T)this.trapHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("trap", 10)) {
            this.getStorageHandler().deserializeNBT(nbt.func_74775_l("trap"));
        } else {
            this.trapHandler = new ItemStackHandler(this.getStorageHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getStorageHandler(), "trap");
        }
        if (nbt.func_150297_b("bait", 10)) {
            this.getFuelHandler().deserializeNBT(nbt.func_74775_l("bait"));
        } else {
            this.baitHandler = new ItemStackHandler(this.getFuelHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getFuelHandler(), "bait");
        }
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeStorageHandler(nbt, this.getStorageHandler(), "trap");
        nbt = this.writeStorageHandler(nbt, this.getFuelHandler(), "bait");
        return nbt;
    }
}

