/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.CauldronIngredientEvent;
import nmd.primal.core.api.events.CauldronRecipeEvent;
import nmd.primal.core.api.interfaces.crafting.ICacheRecipe;
import nmd.primal.core.api.interfaces.crafting.ITileRecipe;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.StackHelper;
import nmd.primal.core.common.helper.checks.FluidMultiplexer;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.tiles.AbstractTileTank;

public class TileCauldron
extends AbstractTileTank
implements ITileRecipe<CauldronRecipe>,
ICacheRecipe<CauldronRecipe> {
    private static final String FLUID_KEY = "cauldron_tank";
    private static final Integer CAPACITY = 4000;
    private float heat;
    private int counter;
    private FluidTank tank = new FluidTank(CAPACITY){

        protected void onContentsChanged() {
            TileCauldron.this.updateBlock();
        }

        public int fill(FluidStack resource, boolean doFill) {
            int amount = super.fill(resource, doFill);
            if (amount > 0) {
                TileCauldron.this.reduceHeat(0.1f);
            }
            return amount;
        }
    };
    private ItemStackHandler inputHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_190926_b()) {
                MinecraftForge.EVENT_BUS.post((Event)new CauldronIngredientEvent.Post(TileCauldron.this, stack, slot));
            }
            TileCauldron.this.updateBlock();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            CauldronIngredientEvent.Pre event = new CauldronIngredientEvent.Pre(TileCauldron.this, stack, slot);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            CauldronIngredientEvent.Pre event;
            if (!simulate && MinecraftForge.EVENT_BUS.post((Event)(event = new CauldronIngredientEvent.Pre(TileCauldron.this, stack, slot)))) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private ItemStackHandler outputHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            TileCauldron.this.updateBlock();
        }
    };
    private List<CauldronRecipe> recipe_cache = new ArrayList<CauldronRecipe>();

    public TileCauldron() {
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public static Integer getCapacity() {
        return CAPACITY;
    }

    @Override
    public String getFluidKey() {
        return FLUID_KEY;
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Override
    public List<CauldronRecipe> getRecipeCache() {
        return this.recipe_cache;
    }

    @Override
    public CauldronRecipe matchRecipe() {
        for (CauldronRecipe recipe : this.getRecipeCache()) {
            if (!recipe.matches(this, true)) continue;
            PrimalAPI.logger(23, "cauldron", "recipe match found from cache: " + recipe.getRegistryName());
            return recipe;
        }
        for (CauldronRecipe recipe : CauldronRecipe.RECIPES) {
            if (!recipe.matches(this, true)) continue;
            PrimalAPI.logger(23, "cauldron", "recipe match found from registry: " + recipe.getRegistryName());
            this.addRecipeCache(recipe);
            return recipe;
        }
        return null;
    }

    @Override
    public void onTakeOutput() {
        this.playSoundSplash();
    }

    @Override
    public void onAddInput() {
        this.playSoundAdd();
        this.spawnParticles();
    }

    @Override
    public boolean finishRecipe(CauldronRecipe recipe) {
        FluidStack cauldron_fluid = this.tank.getFluid();
        List<List<ItemStack>> inputs = recipe.getInput();
        List<ItemStack> outputs = recipe.getOutput();
        CauldronRecipeEvent.Pre pre = new CauldronRecipeEvent.Pre(this, recipe, outputs);
        if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
            return false;
        }
        if (recipe.hasFluidOutput()) {
            PrimalAPI.logger(23, "cauldron", "crafting fluid");
            FluidStack output_fluid = recipe.getFluidOutput().copy();
            int recipe_amount = recipe.getFluidOutput().amount;
            if (recipe.hasFluidInput()) {
                PrimalAPI.logger(23, "cauldron", "converting fluid");
                output_fluid.amount = cauldron_fluid != null ? recipe_amount * (cauldron_fluid.amount / recipe_amount) : recipe_amount;
                this.tank.setFluid(output_fluid);
            } else {
                PrimalAPI.logger(23, "cauldron", "creating fluid");
                this.tank.fill(recipe.getFluidOutput(), true);
            }
        } else {
            PrimalAPI.logger(23, "cauldron", "consuming fluid");
            this.tank.drain(recipe.getFluidInput(), true);
        }
        if (recipe.hasItemInput()) {
            ItemStackHandler input = this.getInputHandler();
            ItemStackHandler output = this.getOutputHandler();
            block0: for (List<ItemStack> recipe_list : inputs) {
                for (ItemStack recipe_stack : recipe_list) {
                    for (int slot = 0; slot < input.getSlots(); ++slot) {
                        int adjusted_amount;
                        ItemStack tile_stack;
                        if (input.getStackInSlot(slot).func_190926_b() || !StackHelper.containsStack(tile_stack = input.getStackInSlot(slot).func_77946_l(), recipe_stack)) continue;
                        int recipe_item_amount = recipe_stack.func_190916_E();
                        int n = adjusted_amount = recipe.hasFluidOutput() && recipe.hasFluidInput() && cauldron_fluid != null ? recipe_item_amount * (cauldron_fluid.amount / recipe.getFluidInput().amount) : recipe_item_amount;
                        if (adjusted_amount <= 0) continue;
                        if (recipe.matchCatalyst(tile_stack)) {
                            input.getStackInSlot(slot).func_96631_a(1, (Random)this.RANDOM, null);
                            continue block0;
                        }
                        if (this.consumeItem(input, slot, adjusted_amount)) continue block0;
                    }
                }
            }
            for (ItemStack output_item : recipe.getOutput()) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)output_item.func_77946_l(), (boolean)false);
            }
        }
        this.recipePostProduction();
        this.resetCount();
        this.updateBlock();
        MinecraftForge.EVENT_BUS.post((Event)new CauldronRecipeEvent.Post(this, recipe));
        return true;
    }

    public void addSlag() {
        ItemStackHandler handler = this.getInputHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!PrimalAPI.randomCheck(ModConfig.Machines.CAULDRON_SLAG_CHANCE) || !handler.getStackInSlot(i).func_190926_b()) continue;
            int amount = this.RANDOM.nextInt(1, 6);
            ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)new ItemStack(this.getSlag(), amount), (boolean)false);
            PrimalAPI.logger(23, "cauldron", "adding slag: " + amount);
        }
    }

    public Item getSlag() {
        return FluidMultiplexer.forItem(PrimalAPI.Fluids.BITUMEN, PrimalAPI.Fluids.BITUMEN_BOILING).apply(this.getContainedFluid()) ? PrimalAPI.Items.BITUMIN_CLUMP : PrimalAPI.Items.SLAG;
    }

    public void recipePostProduction() {
        this.playSoundCraft();
        this.spawnParticles();
        this.addSlag();
        if (!this.isCovered()) {
            FireHelper.makeSmoke(this.field_145850_b, this.field_174879_c, ModConfig.Machines.CAULDRON_SMOKE_CHANCE);
        }
    }

    public int getCounter() {
        return Math.max(0, this.counter);
    }

    public void resetCount() {
        this.setCounter(0);
    }

    public void setCounter(int count) {
        this.counter = Math.max(0, count);
    }

    public void reduceCounter() {
        int amount = this.RANDOM.nextInt(3);
        for (int i = 0; i <= amount; ++i) {
            if (this.counter <= 1) continue;
            --this.counter;
        }
    }

    public void setRecipeTime(CauldronRecipe recipe) {
        int recipe_time = recipe.getCookTime();
        int modified_time = Math.max(0, (int)Math.floor((double)recipe_time * ModConfig.Machines.CAULDRON_TIME_MODIFIER));
        int entropy = modified_time > 3 ? this.RANDOM.nextInt((int)Math.floor((float)modified_time * 0.35f)) : 0;
        this.setCounter((modified_time > 0 ? modified_time : recipe_time) + entropy);
    }

    public float getHeat() {
        return Math.max(0.0f, Math.min(this.heat, 1.0f));
    }

    public void setHeat(float value) {
        this.heat = Math.max(0.0f, Math.min(value, 1.0f));
    }

    public boolean isHot() {
        return this.heat > 0.85f;
    }

    public boolean isCold() {
        return this.heat < 0.1f;
    }

    public float adjustHeat() {
        FluidStack fluid = this.getContainedFluid();
        if (fluid != null && fluid.amount > 0 && fluid.getFluid().getTemperature() > 600) {
            if (!this.isHot()) {
                this.setHeat(1.0f);
                this.updateBlock();
            }
        } else if (FireHelper.hasDirectHeat(this.field_145850_b, this.field_174879_c, EnumFacing.DOWN)) {
            this.increaseHeat((float)ModConfig.Machines.CAULDRON_HEAT_UP);
        } else {
            this.reduceHeat((float)ModConfig.Machines.CAULDRON_COOL_DOWN);
        }
        return this.getHeat();
    }

    public void reduceHeat(float value) {
        if (!this.isCold()) {
            this.setHeat(Math.max(0.0f, this.getHeat() - value));
            this.updateBlock();
        }
    }

    public void increaseHeat(float value) {
        if (!this.isHot()) {
            this.setHeat(Math.min(1.0f, this.getHeat() + value));
            this.updateBlock();
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null && facing == EnumFacing.UP) {
                return (T)this.inputHandler;
            }
            return (T)this.outputHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("crafting", 10)) {
            this.getInputHandler().deserializeNBT(nbt.func_74775_l("crafting"));
        } else {
            this.inputHandler = new ItemStackHandler(this.getInputHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getInputHandler(), "crafting");
        }
        if (nbt.func_150297_b("output_items", 10)) {
            this.getOutputHandler().deserializeNBT(nbt.func_74775_l("output_items"));
        } else {
            this.outputHandler = new ItemStackHandler(this.getOutputHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getOutputHandler(), "output_items");
        }
        this.setCounter(nbt.func_74762_e("counter"));
        this.setHeat(nbt.func_74760_g("heat"));
        return super.readNBT(nbt);
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeRecipeItemHandler(nbt, this.getInputHandler(), "crafting");
        nbt = this.writeRecipeItemHandler(nbt, this.getOutputHandler(), "output_items");
        nbt.func_74768_a("counter", this.getCounter());
        nbt.func_74776_a("heat", this.getHeat());
        return super.writeNBT(nbt);
    }

    public void playSoundAdd() {
        if (this.hasFluid()) {
            float volume = this.isHot() ? 0.15f : 0.35f;
            SoundEvent sound = this.isHot() ? PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_ADD : PrimalAPI.Sounds.SOUND_FLUID_SPLASH;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, volume, this.RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void playSoundCraft() {
        FluidStack fluidStack = this.getContainedFluid();
        if (fluidStack == null || this.getContainedFluid().getFluid() == FluidRegistry.LAVA) {
            FXHelper.soundFireExtinguish(this.field_145850_b, this.field_174879_c, 1.0f);
        } else {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_FINISH, SoundCategory.BLOCKS, 0.5f, this.RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void playSoundSplash() {
        if (this.hasFluid()) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, PrimalAPI.Sounds.SOUND_FLUID_SWISH, SoundCategory.BLOCKS, 0.5f, this.RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void spawnParticles() {
        if (this.isHot()) {
            for (int i = 0; i <= this.RANDOM.nextInt(6, 10); ++i) {
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + this.RANDOM.nextDouble(0.2, 0.6), (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + this.RANDOM.nextDouble(0.2, 0.6), 1, 0.0, 0.0, 0.0, 0.0, new int[]{0});
            }
        }
    }
}

