/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.irecipe;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.irecipe.EmptyRecipe;

public class RecipeHandler {
    public static void addRecipe(IRecipe recipe) {
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapedOreRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = RecipeHandler.getNameForRecipe(output);
        ShapedOreRecipe recipe = new ShapedOreRecipe(location, output, params);
        recipe.setRegistryName(location);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapedRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = RecipeHandler.getNameForRecipe(output);
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
        recipe.setRegistryName(location);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessOreRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHandler.getNameForRecipe(output);
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(location, output, input);
        recipe.setRegistryName(location);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHandler.getNameForRecipe(output);
        ShapelessRecipes recipe = new ShapelessRecipes(location.func_110624_b(), output, RecipeHelper.buildList(input));
        recipe.setRegistryName(location);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ModContainer activeContainer = Loader.instance().activeModContainer();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(activeContainer.getModId(), output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(activeContainer.getModId(), baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public static void addSmelting(Block input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(Item input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output) {
        RecipeHandler.addSmelting(input, output, 1.0f);
    }

    public static void addSmelting(Item input, ItemStack output) {
        RecipeHandler.addSmelting(input, output, 1.0f);
    }

    public static void addSmelting(Block input, ItemStack output) {
        RecipeHandler.addSmelting(input, output, 1.0f);
    }

    public static void removeRecipe(ResourceLocation name) {
        IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)name);
        if (recipe != null) {
            PrimalAPI.logger(7, "Removing RecipeAnnotation", name.toString());
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new EmptyRecipe(recipe));
        }
    }
}

