/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.crafting.custom;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.CauldronIngredientEvent;
import nmd.primal.core.api.interfaces.types.ITypePlanks;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModFluids;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.tiles.machines.TileCauldron;

@GameRegistry.ObjectHolder(value="primal")
@Mod.EventBusSubscriber
public final class RecipesCauldron {
    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<CauldronRecipe> event) {
        PrimalAPI.logger(7, "Registering Recipes: cauldron");
        IForgeRegistry recipes = event.getRegistry();
        PrimalAPI.Fluids.RAIN_WATER = ModConfig.Compatibility.TAN_PURIFIED_WATER && FluidRegistry.isFluidRegistered((String)"purified_water") ? FluidRegistry.getFluid((String)"purified_water") : FluidRegistry.WATER;
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(8, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 2000), new FluidStack((Fluid)PrimalAPI.Fluids.PARAFFIN, 1500), new ItemStack(PrimalAPI.Items.PARAFFIN_CLUMP, 16), new ItemStack(PrimalAPI.Items.SALT_DUST_FIRE, 8), ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.WAX_RESIDUE, 2), ItemStack.field_190927_a).setBottle(new ItemStack(PrimalAPI.Items.BOTTLE_PARAFFIN)).setBucket(ItemStack.field_190927_a).setRecipeName("paraffin")).setRequiresLid(true));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, new FluidStack((Fluid)PrimalAPI.Fluids.BITUMEN, 250), new FluidStack((Fluid)PrimalAPI.Fluids.BITUMEN_BOILING, 250), RecipeHelper.getOreStack("saltSpecial", 4, new ItemStack[0]), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("boiling_bitumen"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(8, new FluidStack(FluidRegistry.WATER, 250), new FluidStack(PrimalAPI.Fluids.TANNIN, 250), RecipeHelper.getOreStack("dustTannin", 1, new ItemStack[0]), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("tannin"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(8, new FluidStack(FluidRegistry.WATER, 250), new FluidStack(PrimalAPI.Fluids.URUSHI, 250), RecipeHelper.getOreStack("dustUrushi", 1, new ItemStack[0]), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("urushi"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, new FluidStack(FluidRegistry.WATER, 250), new FluidStack(PrimalAPI.Fluids.BRINE, 250), RecipeHelper.getOreStack("dustSalt", 4, new ItemStack[0]), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("brine_dust_salt"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(8, new FluidStack(PrimalAPI.Fluids.BRINE, 250), new FluidStack((Fluid)PrimalAPI.Fluids.BITUMEN, 250), RecipeHelper.getOreStack("clumpBitumin", 1, new ItemStack[0]), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("bitumen_clumps"));
        recipes.register(((CauldronRecipe)new CauldronRecipe(8, new FluidStack(PrimalAPI.Fluids.BRINE, 1000), new FluidStack((Fluid)PrimalAPI.Fluids.BITUMEN, 1000), new ItemStack(Items.field_151044_h, 4, 0), new ItemStack(PrimalAPI.Items.ASH_BONE, 4), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("bitumen_coal")).setHidden(true));
        recipes.register(((CauldronRecipe)new CauldronRecipe(8, new FluidStack(FluidRegistry.LAVA, 1000), new FluidStack(PrimalAPI.Fluids.MAGMA, 1000), new ItemStack(PrimalAPI.Items.SALT_DUST_FIRE, 4), new ItemStack(PrimalAPI.Items.MUCK_MOLTEN, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("magma")).setHidden(true));
        recipes.register(((CauldronRecipe)new CauldronRecipe(6, new FluidStack(FluidRegistry.WATER, 1000), new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 1000), RecipeHelper.getOreStack("dustSaltFire", 2, new ItemStack[0]), RecipeHelper.getOreStack("dustRedstone", 2, new ItemStack[0]), RecipeHelper.getOreStack("foodCheese", 1, new ItemStack[0]), ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("ovis_milk")).setHidden(true));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, new FluidStack(FluidRegistry.WATER, 1000), new FluidStack(PrimalAPI.Fluids.WASTE, 1000), new ItemStack(PrimalAPI.Items.SLAG, 4), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("waste"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, new FluidStack((Fluid)PrimalAPI.Fluids.BITUMEN_BOILING, 250), null, RecipeHelper.getOreStack("gemQuartz", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustSaltNetjry", 4, new ItemStack[0]), RecipeHelper.getOreStack("clayCinis", 4, new ItemStack[0]), RecipeHelper.getOreStack("resinSinuous", 4, new ItemStack[0]), new ItemStack(PrimalAPI.Items.QUARTZ_VITRIFIED), ItemStack.field_190927_a).setRecipeName("quartz_vitrified"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, new FluidStack(PrimalAPI.Fluids.BRINE, 250), null, new ItemStack(Items.field_151116_aA, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.LEATHER_BOILED, 1), ItemStack.field_190927_a).setRecipeName("boiled_leather"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.TANNIN, 250), null, new ItemStack(PrimalAPI.Items.HIDE_DRIED, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.HIDE_TANNED, 1), ItemStack.field_190927_a).setRecipeName("hide_tanned_dried"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.TANNIN, 250), null, new ItemStack(PrimalAPI.Items.PIGMAN_HIDE_DRIED, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.PIGMAN_HIDE_TANNED, 1), ItemStack.field_190927_a).setRecipeName("hide_tanned_pigman"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.WATER, 25), null, new ItemStack(PrimalAPI.Items.MUCK), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151123_aH), new ItemStack(PrimalAPI.Items.MUD_CLUMP, 2)).setRecipeName("slime_muck"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.LAVA, 25), null, new ItemStack(PrimalAPI.Items.MUCK_MOLTEN), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151064_bs), new ItemStack(PrimalAPI.Items.CINIS_CLUMP, 1)).setRecipeName("magmacream_molten"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(Items.field_151064_bs), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151065_br)).setRecipeName("slime_magmacream"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.LAVA, 25), null, new ItemStack(Items.field_151064_bs), new ItemStack(PrimalAPI.Items.CINIS_CLUMP), new ItemStack(PrimalAPI.Items.SALT_DUST_FIRE), ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.MUCK_MOLTEN), ItemStack.field_190927_a).setRecipeName("muck_molten"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.WATER, 25), null, new ItemStack(Items.field_151123_aH), new ItemStack(PrimalAPI.Items.MUD_CLUMP, 2), ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.MUCK), ItemStack.field_190927_a).setRecipeName("muck"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.WATER, 125), null, new ItemStack(Blocks.field_150346_d), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.MUD_CLUMP, 8), ItemStack.field_190927_a).setRecipeName("mud_dirt"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.WATER, 125), null, new ItemStack(PrimalAPI.Blocks.NETHER_EARTH), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.MUD_CLUMP, 8), new ItemStack(PrimalAPI.Items.SOUL_RESIDUE, 1)).setRecipeName("mud_nether_earth"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Items.TERRA_CLUMP), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151119_aD), new ItemStack(PrimalAPI.Items.MUD_CLUMP)).setRecipeName("terra_clump_conversion"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Items.CINIS_CLUMP), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151119_aD), new ItemStack(PrimalAPI.Blocks.ASH_COMMON)).setRecipeName("cinis_clump_conversion"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 100), null, new ItemStack(PrimalAPI.Blocks.CINIS_BLOCK), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Blocks.field_150435_aG), new ItemStack(PrimalAPI.Blocks.ASH_COMMON, 4)).setRecipeName("cinis_block_conversion"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(Blocks.field_150425_aM), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack((Block)Blocks.field_150354_m), new ItemStack(PrimalAPI.Items.SOUL_RESIDUE, 4)).setRecipeName("soulsand_conversion"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, RecipeHelper.getOreStack("sand", 1, new ItemStack[0]), RecipeHelper.getOreStack("soulresidue", 4, new ItemStack[0]), null, null, new ItemStack(Blocks.field_150425_aM), ItemStack.field_190927_a).setRecipeName("sand_conversion"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Blocks.NETHER_EARTH, 1, 0), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Blocks.field_150346_d), new ItemStack(PrimalAPI.Items.SOUL_RESIDUE, 4)).setRecipeName("nether_earth_conversion"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, RecipeHelper.getOreStack("dirt", 1, new ItemStack[0]), RecipeHelper.getOreStack("soulresidue", 4, new ItemStack[0]), null, null, new ItemStack(PrimalAPI.Blocks.NETHER_EARTH, 1, 0), ItemStack.field_190927_a).setRecipeName("dirt_conversion"));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(4, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 1000), new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Items.field_151156_bN), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("ovis_milk_conversion")).setCatalyst(new ItemStack(Items.field_151156_bN)));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Items.LACQUER_STICK, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151055_y, 1), ItemStack.field_190927_a).setRecipeName("stick_from_lacquer"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Items.CORYPHA_STICK, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151055_y, 1), ItemStack.field_190927_a).setRecipeName("stick_from_corypha"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Blocks.PLANKS, 1, ITypePlanks.EnumType.CORYPHA.getMetadata()), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.DARK_OAK.func_176839_a()), ItemStack.field_190927_a).setRecipeName("plank_from_corypha"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Blocks.PLANKS, 1, ITypePlanks.EnumType.LACQUER.getMetadata()), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()), ItemStack.field_190927_a).setRecipeName("plank_from_lacquer"));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.BRINE, 25), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)), RecipeHelper.getOreStack(2, "fatAnimal"), null, null, new ItemStack(PrimalAPI.Items.TALLOW, 1), ItemStack.field_190927_a).setRecipeName("tallow")).setCatalyst(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.NETHER_CLOTH)), RecipeHelper.getOreStack(2, "fatAnimal"), null, null, new ItemStack(PrimalAPI.Items.TALLOW, 1), ItemStack.field_190927_a).setRecipeName("tallow_nether")).setCatalyst(new ItemStack(PrimalAPI.Items.NETHER_CLOTH)));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(5, new FluidStack(PrimalAPI.Fluids.BRINE, 25), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)), RecipeHelper.buildList(new ItemStack(Items.field_151078_bh)), null, null, new ItemStack(PrimalAPI.Items.TALLOW, 1), ItemStack.field_190927_a).setRecipeName("tallow_rotten_flesh")).setCatalyst(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(5, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.NETHER_CLOTH)), RecipeHelper.buildList(new ItemStack(Items.field_151078_bh)), null, null, new ItemStack(PrimalAPI.Items.TALLOW, 1), ItemStack.field_190927_a).setRecipeName("tallow_rotten_flesh_nether")).setCatalyst(new ItemStack(PrimalAPI.Items.NETHER_CLOTH)));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 10), null, new ItemStack(PrimalAPI.Items.DAUCUS_MURN_ROOT, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.DAUCUS_MURN_ROOT_COOKED, 1), ItemStack.field_190927_a).setRecipeName("daucus_murn"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 10), null, RecipeHelper.getOreStack("mushroom", 1, new ItemStack[0]), null, null, null, new ItemStack(PrimalAPI.Items.MUSHROOM_COOKED, 1), ItemStack.field_190927_a).setRecipeName("cooked_mushroom_ovis"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, new FluidStack(PrimalAPI.Fluids.BRINE, 10), null, RecipeHelper.getOreStack("mushroom", 1, new ItemStack[0]), null, null, null, new ItemStack(PrimalAPI.Items.MUSHROOM_COOKED, 1), ItemStack.field_190927_a).setRecipeName("cooked_mushroom_brine"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(FluidRegistry.WATER, 10), null, RecipeHelper.getOreStack("mushroom", 1, new ItemStack[0]), null, null, null, new ItemStack(PrimalAPI.Items.MUSHROOM_COOKED, 1), ItemStack.field_190927_a).setRecipeName("cooked_mushroom"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 10), null, new ItemStack(Items.field_151075_bm, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.NETHER_WART_COOKED, 1), ItemStack.field_190927_a).setRecipeName("cooked_netherwart"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.BRINE, 10), null, RecipeHelper.getOreStack("egg", 1, new ItemStack[0]), null, null, null, new ItemStack(PrimalAPI.Items.EGG_BOILED, 1), ItemStack.field_190927_a).setRecipeName("boiled_egg_brine"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, new FluidStack(FluidRegistry.WATER, 10), null, RecipeHelper.getOreStack("egg", 1, new ItemStack[0]), null, null, null, new ItemStack(PrimalAPI.Items.EGG_BOILED, 1), ItemStack.field_190927_a).setRecipeName("boiled_egg"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.BRINE, 10), null, new ItemStack(Items.field_151174_bG, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.POTATO_BOILED, 1), ItemStack.field_190927_a).setRecipeName("boiled_potato_brine"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, new FluidStack(FluidRegistry.WATER, 10), null, new ItemStack(Items.field_151174_bG, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.POTATO_BOILED, 1), ItemStack.field_190927_a).setRecipeName("boiled_potato"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, new FluidStack(PrimalAPI.Fluids.MAGMA, 25), null, new ItemStack(Blocks.field_150425_aM, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Blocks.SOUL_GLASS, 1), ItemStack.field_190927_a).setRecipeName("soul_glass_magma"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, new FluidStack(PrimalAPI.Fluids.URUSHI, 20), null, RecipeHelper.getOreStack("plankWood", 1, new ItemStack(PrimalAPI.Blocks.PLANKS, 1, ITypePlanks.EnumType.LACQUER.getMetadata())), null, null, null, new ItemStack(PrimalAPI.Blocks.PLANKS, 1, ITypePlanks.EnumType.LACQUER.getMetadata()), ItemStack.field_190927_a).setRecipeName("lacquer_planks"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, new FluidStack(PrimalAPI.Fluids.URUSHI, 5), null, RecipeHelper.getOreStack("stickWood", 1, new ItemStack[0]), null, null, null, new ItemStack(PrimalAPI.Items.LACQUER_STICK), ItemStack.field_190927_a).setRecipeName("lacquer_stick_wood"));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.BRINE, 250), null, RecipeHelper.buildList(new ItemStack(Items.field_151117_aB)), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)), new ItemStack(PrimalAPI.Items.CHEESE_WHITE, 2), new ItemStack(Items.field_151133_ar, 1)).setRecipeName("cow_cheese")).setCatalyst(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)));
        recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 250), null, new ItemStack(PrimalAPI.Items.NETHER_CLOTH), new ItemStack(PrimalAPI.Items.SALT_DUST_FIRE, 2), ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.CHEESE_RED, 2), ItemStack.field_190927_a).setRecipeName("ovis_atre_cheese")).setCatalyst(new ItemStack(PrimalAPI.Items.NETHER_CLOTH)));
        if (ModConfig.Fluids.BUCKETS_CLAY_ENABLED) {
            recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.BRINE, 250), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.BUCKET_CLAY_MILK)), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)), new ItemStack(PrimalAPI.Items.CHEESE_WHITE, 2), new ItemStack((Item)PrimalAPI.Items.BUCKET_CLAY)).setRecipeName("cow_cheese_clay")).setCatalyst(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)));
        }
        if (ModConfig.Fluids.BUCKETS_TERRA_ENABLED) {
            recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.BRINE, 250), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.BUCKET_TERRA_MILK)), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)), new ItemStack(PrimalAPI.Items.CHEESE_WHITE, 2), new ItemStack((Item)PrimalAPI.Items.BUCKET_TERRA)).setRecipeName("cow_cheese_terra")).setCatalyst(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)));
        }
        if (ModConfig.Fluids.BUCKETS_CINIS_ENABLED) {
            recipes.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(3, new FluidStack(PrimalAPI.Fluids.BRINE, 250), null, RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.BUCKET_CINIS_MILK)), RecipeHelper.buildList(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)), new ItemStack(PrimalAPI.Items.CHEESE_WHITE, 2), new ItemStack((Item)PrimalAPI.Items.BUCKET_CINIS)).setRecipeName("cow_cheese_cinis")).setCatalyst(new ItemStack(PrimalAPI.Items.PLANT_CLOTH)));
        }
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, null, new FluidStack(FluidRegistry.WATER, 1000), RecipeHelper.getOreStack("blockIce", 1, new ItemStack[0]), null, null, null, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("ice_to_water"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, null, new FluidStack(FluidRegistry.WATER, 2000), RecipeHelper.getOreStack("iceAncient", 1, new ItemStack[0]), null, null, null, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("ancient_ice_to_water"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, null, new FluidStack(FluidRegistry.WATER, 500), RecipeHelper.getOreStack("iceAncientChunk", 1, new ItemStack[0]), null, null, null, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("ancient_ice_chunk_to_water"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(2, null, new FluidStack(FluidRegistry.WATER, 500), new ItemStack(Blocks.field_150433_aE), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("snow_to_water"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, null, new FluidStack(FluidRegistry.WATER, 125), new ItemStack(Items.field_151126_ay), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("snow_ball_to_water"));
        recipes.register((IForgeRegistryEntry)new CauldronRecipe(6, null, new FluidStack(PrimalAPI.Fluids.MAGMA, 1000), new ItemStack(Blocks.field_189877_df), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("magma_to_fluid"));
        if (ModConfig.Machines.CAULDRON_RECIPE_STONE_TO_LAVA > 0) {
            recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, null, new FluidStack(FluidRegistry.LAVA, 1000), RecipeHelper.getOreStack("stone", ModConfig.Machines.CAULDRON_RECIPE_STONE_TO_LAVA, new ItemStack[0]), null, null, null, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("stone_to_lava"));
            recipes.register((IForgeRegistryEntry)new CauldronRecipe(4, null, new FluidStack(FluidRegistry.LAVA, 1000), RecipeHelper.getOreStack("cobblestone", ModConfig.Machines.CAULDRON_RECIPE_STONE_TO_LAVA, new ItemStack[0]), null, null, null, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("cobble_to_lava"));
            recipes.register((IForgeRegistryEntry)new CauldronRecipe(3, null, new FluidStack(FluidRegistry.LAVA, 1000), new ItemStack(PrimalAPI.Items.ROCK_STONE, ModConfig.Machines.CAULDRON_RECIPE_STONE_TO_LAVA * 4), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("rocks_to_lava"));
        }
        recipes.register(((CauldronRecipe)new CauldronRecipe(6, new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, 25), null, new ItemStack(PrimalAPI.Items.DIRT_STICK), new ItemStack(Items.field_151156_bN), ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(PrimalAPI.Items.GLASS_STICK), new ItemStack(Items.field_151156_bN)).setRecipeName("dirt_stick_conversion")).setHidden(true));
        if (ModConfig.Fluids.JEI_SHOW_DYNAMIC_BUCKET_RECIPES) {
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                if (!(item instanceof UniversalBucket)) continue;
                ItemStack bucket_water = ModFluids.getFilledBucket((UniversalBucket)item, ModFluids.VANILLA_BUCKET_WATER);
                ItemStack bucket_lava = ModFluids.getFilledBucket((UniversalBucket)item, ModFluids.VANILLA_BUCKET_LAVA);
                if (!bucket_water.func_190926_b()) {
                    recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, new FluidStack(FluidRegistry.LAVA, 1000), null, RecipeHelper.buildList(bucket_water), new ItemStack(Blocks.field_150343_Z, 1), item.getContainerItem(bucket_water)).setRecipeName(RegistryHelper.formatRecipeName(item.func_77658_a()) + "_obsidian_lava"));
                }
                if (bucket_lava.func_190926_b()) continue;
                recipes.register((IForgeRegistryEntry)new CauldronRecipe(1, new FluidStack(FluidRegistry.WATER, 1000), null, RecipeHelper.buildList(bucket_lava), new ItemStack(Blocks.field_150343_Z, 1), item.getContainerItem(bucket_lava)).setRecipeName(RegistryHelper.formatRecipeName(item.func_77658_a()) + "_obsidian_water"));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onCauldronAdd(CauldronIngredientEvent.Post event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            TileCauldron tile = event.getTile();
            FluidTank tank = event.getTank();
            FluidStack fluid = tank.getFluid();
            ItemStack stack = event.getIngredient();
            Item item = stack.func_77973_b();
            boolean is_vanilla = ModFluids.VANILLA_BUCKETS.apply((Object)stack);
            if (fluid != null && fluid.amount >= 1000 && (is_vanilla || item instanceof UniversalBucket)) {
                FluidStack bucket_stack = is_vanilla ? ModFluids.getVanillaBucketStack(item) : ((UniversalBucket)item).getFluid(stack);
                ItemStack bucket_empty = is_vanilla ? ModFluids.getVanillaEmpty() : ((UniversalBucket)item).getContainerItem(stack);
                ItemStack output_stack = new ItemStack(Blocks.field_150343_Z, 1);
                if (bucket_stack != null && tile.canStoreOutput(RecipeHelper.buildList(bucket_empty, output_stack))) {
                    ItemStackHandler handler = tile.getOutputHandler();
                    Fluid bucket_fluid = bucket_stack.getFluid();
                    Fluid cauldron_fluid = fluid.getFluid();
                    if (cauldron_fluid == FluidRegistry.WATER && bucket_fluid == FluidRegistry.LAVA || cauldron_fluid == FluidRegistry.LAVA && bucket_fluid == FluidRegistry.WATER) {
                        FXHelper.soundSteamHiss(world, event.getPos(), 1.0f);
                        tank.drain(1000, true);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)bucket_empty, (boolean)false);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)output_stack, (boolean)false);
                        tile.removeInput(stack);
                        tile.setHeat(1.0f);
                        tile.recipePostProduction();
                    }
                }
            }
        }
    }
}

