/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import nmd.primal.core.client.ClientSettings;
import nmd.primal.core.common.network.ModNetwork;

public class MessageClientSettings
implements IMessage {
    private boolean hide_player_names;
    private boolean ambient_light_global;
    private float ambient_light_level;
    private byte[] ambient_light_dimensions;

    public MessageClientSettings() {
    }

    public MessageClientSettings(boolean hide_player_names, boolean ambient_light_global, float ambient_light_level, byte[] ambient_light_dimensions) {
        this.hide_player_names = hide_player_names;
        this.ambient_light_global = ambient_light_global;
        this.ambient_light_level = ambient_light_level;
        this.ambient_light_dimensions = ambient_light_dimensions;
    }

    public void fromBytes(ByteBuf buf) {
        this.hide_player_names = buf.readBoolean();
        this.ambient_light_global = buf.readBoolean();
        this.ambient_light_level = buf.readFloat();
        this.ambient_light_dimensions = ModNetwork.readByteBufferArray(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.hide_player_names);
        buf.writeBoolean(this.ambient_light_global);
        buf.writeFloat(this.ambient_light_level);
        buf.writeBytes(this.ambient_light_dimensions);
    }

    public static class Handler
    implements IMessageHandler<MessageClientSettings, IMessage> {
        public IMessage onMessage(MessageClientSettings message, MessageContext context) {
            ClientSettings.HIDE_PLAYER_NAMES = message.hide_player_names;
            ClientSettings.AMBIENT_LIGHT_GLOBAL = message.ambient_light_global;
            ClientSettings.AMBIENT_LIGHT_LEVEL = message.ambient_light_level;
            ClientSettings.AMBIENT_LIGHT_DIMENSIONS = new ArrayList<Integer>();
            for (byte id : message.ambient_light_dimensions) {
                ClientSettings.AMBIENT_LIGHT_DIMENSIONS.add(Integer.valueOf(id));
            }
            return null;
        }
    }
}

