/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.common.entities.EntityFireProofItems;
import nmd.primal.core.common.recipes.misc.RepairRecipe;

public class PrimalPickAxe
extends ItemPickaxe
implements IFireProof<ItemTool> {
    private boolean is_fire_proof;
    private boolean is_immortal;

    public PrimalPickAxe(Item.ToolMaterial material) {
        super(material);
    }

    public boolean func_82789_a(ItemStack item, ItemStack repair) {
        return RepairRecipe.isRepairItem(repair, item, this.field_77862_b);
    }

    public ItemTool setNoDespawn(boolean is_immortal) {
        this.is_immortal = is_immortal;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    @Override
    public ItemTool setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        EntityFireProofItems entity = this.getEntity(world, location, stack);
        if (this.is_immortal) {
            entity.func_174873_u();
        }
        return entity;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnumEnchantmentType type = enchantment.field_77351_y;
        if (type != null) {
            switch (enchantment.field_77351_y) {
                case DIGGER: 
                case WEAPON: 
                case BREAKABLE: {
                    return true;
                }
            }
        }
        return false;
    }
}

