/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import nmd.primal.core.api.interfaces.crafting.IToolHandler;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.items.tools.PrimalTool;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;

public class Gallagher
extends PrimalTool
implements IToolHandler {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150440_ba, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150434_aF, Blocks.field_150343_Z, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U});
    private ToolCraftingRecipe.EnumToolType toolType;

    public Gallagher(Item.ToolMaterial material, ToolCraftingRecipe.EnumToolType tool_type) {
        super(material, 6.0f + material.func_78000_c(), -3.4f, EFFECTIVE_ON, "pickaxe");
        this.setHarvestLevel("gallagher", material.func_77996_d());
        this.func_77656_e(material.func_77997_a() * 2);
        this.field_77864_a = material.func_77998_b();
        this.toolType = tool_type;
    }

    @Override
    public ToolCraftingRecipe.EnumToolType getToolType() {
        return this.toolType;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_grid_crafting_tool"));
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_world_crafting_tool"));
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() < this.getMaxDamage(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        container.func_96631_a(1, (Random)PrimalCore.RANDOM, null);
        return container;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(1, entity);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState state) {
        if (BlockMultiplexer.forBlock(Blocks.field_150343_Z).apply(state)) {
            return this.material.func_77996_d() >= 2;
        }
        if (BlockMultiplexer.forBlock(Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150475_bE, Blocks.field_150412_bA, Blocks.field_150352_o, Blocks.field_150340_R, Blocks.field_150450_ax, Blocks.field_150439_ay).apply(state)) {
            return this.material.func_77996_d() >= 2;
        }
        if (BlockMultiplexer.forBlock(Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150365_q, Blocks.field_150402_ci).apply(state)) {
            return this.material.func_77996_d() >= 1;
        }
        return state.func_185904_a() == Material.field_151576_e;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (MaterialMultiplexer.forMaterial(Material.field_151572_C, Material.field_151568_F, Material.field_151570_A, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x, Material.field_151596_z, Material.field_151566_D).apply(state)) {
            return 30.0f;
        }
        if (BlockMultiplexer.forBlock(Blocks.field_150343_Z).apply(state)) {
            return this.field_77864_a + 1.0f;
        }
        if (MaterialMultiplexer.forMaterial(Material.field_151576_e).apply(state)) {
            return this.field_77864_a + 2.0f;
        }
        return 0.1f;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnumEnchantmentType type = enchantment.field_77351_y;
        if (type != null) {
            switch (enchantment.field_77351_y) {
                case DIGGER: 
                case WEAPON: 
                case BREAKABLE: {
                    return true;
                }
            }
        }
        return false;
    }
}

