/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.projectiles;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.entities.projectiles.TypeArrow;
import nmd.primal.core.common.helper.RegistryHelper;

public class Arrow
extends ItemArrow
implements IDictionaryName<ItemArrow>,
IFireProof<ItemArrow> {
    private Type type;
    private boolean is_fire_proof;
    private String[] dictionary_names;

    public Arrow(Type type) {
        this.type = type;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow);
        return enchant > 0 && this.type.isInfinite();
    }

    @Override
    public ItemArrow setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this), name);
        }
    }

    @Override
    public ItemArrow setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }

    public EntityArrow func_185052_a(World world, ItemStack stack, EntityLivingBase shooter) {
        TypeArrow arrow = new TypeArrow(world, shooter);
        arrow.setType(this.type.func_176610_l());
        return arrow;
    }

    public static enum Type implements IStringSerializable
    {
        QUARTZ("quartz", 3.0f, true),
        IRONWOOD("ironwood", 2.5f, false),
        TORCH_WOOD("torch_wood", 1.5f, false),
        TORCH_NETHER("torch_nether", 1.5f, false),
        TORCH_REDSTONE("torch_redstone", 1.5f, false),
        WATER("water", 2.0f, false),
        PARAFFIN("paraffin", 3.0f, false),
        BITUMEN("bitumen", 3.0f, false);

        private final String name;
        private final float damage;
        private final boolean infinite;

        private Type(String name, float damage, boolean infinite) {
            this.name = name;
            this.damage = damage;
            this.infinite = infinite;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public float getDamage() {
            return this.damage;
        }

        public boolean isInfinite() {
            return this.infinite;
        }

        public static Type byName(String name) {
            for (Type blocks$enumtype : Type.values()) {
                if (!blocks$enumtype.func_176610_l().equals(name)) continue;
                return blocks$enumtype;
            }
            return QUARTZ;
        }
    }
}

