/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.foods;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.foods.RottenFood;
import nmd.primal.core.common.items.foods.SaltedFood;

public class Foodstuff
extends ItemFood
implements IDictionaryName<ItemFood>,
IFireProof<ItemFood> {
    private String description;
    private boolean is_fire_proof;
    private boolean safeToOverEat;
    private int hunger;
    private float saturation;
    private String[] dictionary_names;

    public Foodstuff(int hunger, float saturation, boolean wolf, String description) {
        super(hunger, saturation, wolf);
        this.description = description;
        this.hunger = hunger;
        this.saturation = saturation;
        if (ModConfig.Foods.FOOD_PLAYER_CAN_OVER_EAT) {
            this.func_77848_i();
        }
    }

    public Foodstuff(int foodAmount, float saturation, boolean wolf) {
        this(foodAmount, saturation, wolf, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.description != null) {
            tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)this.description));
        }
        if (stack.func_77973_b() instanceof SaltedFood) {
            tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.food_is_salted"));
        }
        if (stack.func_77973_b() instanceof RottenFood) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.food_is_rotten"));
        }
    }

    @Override
    public ItemFood setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this), name);
        }
    }

    @Override
    public ItemFood setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }

    public ItemFood safeToOverEat() {
        this.safeToOverEat = true;
        return this;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        EntityPlayer player;
        if (!world.field_72995_K && ModConfig.Foods.FOOD_PLAYER_CAN_OVER_EAT && !this.safeToOverEat && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_71024_bL().func_75121_c()) {
            PrimalAPI.logger(2, "eating", "player is full: " + this.func_150906_h(stack));
        }
        return super.func_77654_b(stack, world, entity);
    }
}

