/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.foods;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.foods.Foodstuff;
import nmd.primal.core.common.recipes.inworld.BottleRecipe;
import toughasnails.api.TANPotions;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.thirst.IDrink;
import toughasnails.api.thirst.ThirstHelper;

@Optional.Interface(iface="toughasnails.api.thirst.IDrink", modid="toughasnails", striprefs=true)
public class BottleDrink
extends Foodstuff
implements IDrink {
    private int thirst;
    private float hydration;
    private float poison;

    public BottleDrink(int thirst, float hydration, float thirst_side_effect, int hunger, float saturation) {
        super(hunger, saturation, false);
        this.func_77625_d(ModConfig.Features.BOTTLE_STACKSIZE);
        this.thirst = thirst;
        this.hydration = hydration;
        this.poison = thirst_side_effect;
    }

    public BottleDrink(int thirst, float hydration, float thirst_side_effect) {
        this(thirst, hydration, thirst_side_effect, 0, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="toughasnails")
    public int getThirst() {
        return this.thirst;
    }

    @Optional.Method(modid="toughasnails")
    public float getHydration() {
        return this.hydration;
    }

    @Optional.Method(modid="toughasnails")
    public float getPoisonChance() {
        return this.poison;
    }

    private boolean drink(World world, EntityLivingBase entity) {
        if (Loader.isModLoaded((String)"toughasnails") && !world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            IThirst thirst = ThirstHelper.getThirstData((EntityPlayer)player);
            thirst.addStats(this.getThirst(), this.getHydration());
            if (PrimalAPI.randomCheck(this.getPoisonChance())) {
                player.func_70690_d(new PotionEffect(TANPotions.thirst, 600));
            }
            return true;
        }
        return false;
    }

    public void secondaryEffects(World world, EntityLivingBase entity) {
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack(Items.field_151069_bo);
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
        }
        this.drink(world, entity);
        this.secondaryEffects(world, entity);
        if (player != null) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            if (stack.func_190926_b()) {
                return new ItemStack(Items.field_151069_bo);
            }
            if (player != null) {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        BottleRecipe recipe = BottleRecipe.getRecipe(container);
        if (recipe != null) {
            return new FluidStack(recipe.getInput(), 250);
        }
        return null;
    }

    public static enum BottleType {
        TANNIN("BasicFluidBlock", 3, 0.1f, 0.8f),
        URUSHI("Urushi", 5, 0.25f, 0.4f),
        PARAFFIN("Paraffin", 2, 0.5f, 1.0f),
        ATRE_MILK("Ovis Atre Milk", 7, 0.5f, 0.0f);

        private String description;
        private int thirst;
        private float hydration;
        private float poisonChance;

        private BottleType(String description, int thirst, float hydration, float poisonChance) {
            this.description = description;
            this.thirst = thirst;
            this.hydration = hydration;
            this.poisonChance = poisonChance;
        }

        public String getDescription() {
            return this.description;
        }

        public int getThirst() {
            return this.thirst;
        }

        public float getHydration() {
            return this.hydration;
        }

        public float getPoisonChance() {
            return this.poisonChance;
        }
    }
}

