/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.debug;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.common.blocks.machines.Barrel;
import nmd.primal.core.common.blocks.machines.Cauldron;
import nmd.primal.core.common.blocks.machines.DryingRack;
import nmd.primal.core.common.blocks.plants.AbstractPlant;
import nmd.primal.core.common.items.PrimalItem;
import nmd.primal.core.common.recipes.inworld.BottleRecipe;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import nmd.primal.core.common.tiles.AbstractTileTank;
import nmd.primal.core.common.tiles.machines.TileBarrel;
import nmd.primal.core.common.tiles.machines.TileCauldron;

public class GoldenStick
extends PrimalItem {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.debug_item"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K) {
            AbstractTileTank tile;
            if (block instanceof DryingRack) {
                for (DryingRecipe dryingRecipe : DryingRecipe.RECIPES) {
                    PrimalAPI.logger(200, "drying rack", "recipe: " + dryingRecipe.getOutputSuccess());
                }
            }
            if (block instanceof Cauldron) {
                for (BottleRecipe bottleRecipe : BottleRecipe.RECIPES) {
                    PrimalAPI.logger(200, "bottle recipe", "recipe: " + bottleRecipe.getInput() + ":" + bottleRecipe.getOutput());
                }
                for (CauldronRecipe cauldronRecipe : CauldronRecipe.RECIPES) {
                    PrimalAPI.logger(200, "cauldron recipe", "recipe: " + cauldronRecipe.getFluidOutput() + ":" + cauldronRecipe.getOutput());
                }
                tile = (TileCauldron)world.func_175625_s(pos);
                if (tile != null) {
                    if (tile.hasOutput()) {
                        ItemStackHandler itemStackHandler = ((TileCauldron)tile).getInputHandler();
                        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                            PrimalAPI.logger(23, "cauldron", "item: " + itemStackHandler.getStackInSlot(i) + ":" + i);
                        }
                    }
                    if (tile.getContainedFluid() != null) {
                        PrimalAPI.logger(23, "cauldron", "fluid: " + tile.getContainedFluid().getUnlocalizedName() + ":" + tile.getContainedFluid().amount);
                    }
                }
            }
            if (block instanceof Barrel && (tile = (TileBarrel)world.func_175625_s(pos)) != null && tile.getContainedFluid() != null) {
                PrimalAPI.logger(25, "barrel", "fluid: " + tile.getContainedFluid().getUnlocalizedName() + ":" + tile.getContainedFluid().amount);
            }
            if (block instanceof ISchedule) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7o scheduled: " + world.func_184145_b(pos, block) + ", should schedule: " + ((ISchedule)block).shouldSchedule(world, pos, state), new Object[0]));
            }
            if (block instanceof AbstractPlant) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7o age: " + ((AbstractPlant)block).getAge(state) + ", bloom: " + ((AbstractPlant)block).isBlooming(state), new Object[0]));
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

