/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.armor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.enums.EnumArmorSet;
import nmd.primal.core.api.interfaces.IArmorSet;
import nmd.primal.core.api.interfaces.IFireProof;

public abstract class AbstractPrimalArmor
extends ItemArmor
implements ISpecialArmor,
IArmorSet,
IFireProof<ItemArmor> {
    private EntityEquipmentSlot armor_slot;
    public EnumArmorSet armor_type;
    private ItemStack repair_item;
    private boolean is_fire_proof;
    SoundEvent[] step_sounds = new SoundEvent[]{SoundEvents.field_187695_h, SoundEvents.field_187554_ai, SoundEvents.field_187569_bQ, SoundEvents.field_187579_bV, SoundEvents.field_187668_ca, SoundEvents.field_187778_dq, SoundEvents.field_187755_eF, SoundEvents.field_187902_gb, SoundEvents.field_187897_gY, SoundEvents.field_187902_gb};

    public AbstractPrimalArmor(EnumArmorSet armor_type, ItemArmor.ArmorMaterial material, EntityEquipmentSlot armor_slot, int render_index) {
        super(material, render_index, armor_slot);
        this.func_77645_m();
        this.func_77656_e(material.func_78046_a(armor_slot));
        this.armor_slot = armor_slot;
        this.armor_type = armor_type;
    }

    public AbstractPrimalArmor(EnumArmorSet armor_type, ItemArmor.ArmorMaterial material, EntityEquipmentSlot armor_slot) {
        this(armor_type, material, armor_slot, 0);
    }

    public EntityEquipmentSlot getSlot() {
        return this.armor_slot;
    }

    @Override
    public ItemArmor setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return !this.repair_item.func_190926_b() && ItemStack.func_179545_c((ItemStack)repair, (ItemStack)this.getRepairItem());
    }

    public ItemStack getRepairItem() {
        return this.repair_item;
    }

    public Item setRepairItem(ItemStack stack) {
        this.repair_item = stack;
        return this;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.updateArmor(world, player, stack);
    }

    public void updateArmor(World world, EntityPlayer player, ItemStack itemStack) {
    }

    @Override
    public EnumArmorSet getArmorType() {
        return this.armor_type;
    }

    @Override
    public boolean checkFullArmor(EntityLivingBase entity, Class armorClass) {
        ItemStack[] armor;
        for (ItemStack part : armor = new ItemStack[]{entity.func_184582_a(EntityEquipmentSlot.HEAD), entity.func_184582_a(EntityEquipmentSlot.CHEST), entity.func_184582_a(EntityEquipmentSlot.LEGS), entity.func_184582_a(EntityEquipmentSlot.FEET)}) {
            if (!part.func_190926_b() && part.func_77973_b().getClass() == armorClass) continue;
            return false;
        }
        return true;
    }

    public boolean shouldUpdatePassive(EntityLivingBase entity) {
        return false;
    }

    public boolean shouldUpdateActive(EntityLivingBase entity) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        int reductionAmount = this.getDamageReductionAmount(this.armor_slot);
        int maxDamage = armor.func_77958_k() + 1 - armor.func_77952_i();
        return new ISpecialArmor.ArmorProperties(0, (double)reductionAmount / 25.0, maxDamage);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.func_82812_d().func_78044_b(this.func_185083_B_());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
    }

    public int getDamageReductionAmount(EntityEquipmentSlot slot) {
        return this.func_82812_d().func_78044_b(slot);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "primal:textures/entity/armor/dark_goggles.png";
    }
}

