/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RegistryHelper;

public class PrimalItem
extends Item
implements IFireProof<Item>,
IDictionaryName<Item> {
    protected static ThreadLocalRandom RANDOM = PrimalCore.RANDOM;
    private String description;
    private boolean is_fire_proof;
    private String[] dictionary_names;

    public PrimalItem(String description) {
        this.description = description;
    }

    public PrimalItem() {
        this("");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.description != null && !this.description.isEmpty()) {
            tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)this.description));
        }
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    @Override
    public Item setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this), name);
        }
    }

    @Override
    public PrimalItem setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }

    public String getName() {
        return this.getRegistryName().toString();
    }

    public static boolean isHidden() {
        return false;
    }
}

