/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.events.WorldEvents;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.ProviderHell;
import nmd.primal.core.common.world.ProviderSurface;
import nmd.primal.core.common.world.generators.EndGeneral;
import nmd.primal.core.common.world.generators.EndPlants;
import nmd.primal.core.common.world.generators.NetherGeneral;
import nmd.primal.core.common.world.generators.NetherPlants;
import nmd.primal.core.common.world.generators.OverWorldFluids;
import nmd.primal.core.common.world.generators.OverWorldMud;
import nmd.primal.core.common.world.generators.OverWorldOres;
import nmd.primal.core.common.world.generators.OverWorldPlants;
import nmd.primal.core.common.world.generators.OverWorldSalt;
import nmd.primal.core.common.world.generators.OverWorldStone;

public final class ModWorld {
    public static void init() {
        MinecraftForge.ORE_GEN_BUS.register((Object)new WorldEvents());
        ModWorld.registerWorldGenerators();
        ModWorld.registerDimensionProviders();
    }

    private static void registerWorldGenerators() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverWorldFluids(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverWorldStone(), (int)2);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverWorldOres(), (int)3);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverWorldSalt(), (int)4);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverWorldMud(), (int)6);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverWorldPlants(), (int)8);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherGeneral(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherPlants(), (int)8);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EndGeneral(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EndPlants(), (int)8);
    }

    private static void registerDimensionProviders() {
        if (ModConfig.Worldgen.SURFACE_PROVIDER_OVERRIDE) {
            PrimalCore.LOGGER.info("Overriding Surface Provider");
            PrimalCore.LOGGER.info("Overworld Day Length: " + ModConfig.Worldgen.SURFACE_DAY_LENGTH);
            DimensionManager.unregisterDimension((int)0);
            DimensionType primal_surface = DimensionType.register((String)"Overworld", (String)"", (int)0, ProviderSurface.class, (boolean)true);
            DimensionManager.registerDimension((int)0, (DimensionType)primal_surface);
        }
        if (ModConfig.Worldgen.NETHER_PROVIDER_OVERRIDE) {
            PrimalCore.LOGGER.info("Overriding Nether Provider");
            PrimalCore.LOGGER.info("Nether Spawn: " + ModConfig.Worldgen.NETHER_ALLOW_RESPAWN);
            PrimalCore.LOGGER.info("Nether Fog Disabled: " + ModConfig.Worldgen.NETHER_FOG_DISABLE);
            PrimalCore.LOGGER.info("Nether Fog Color: " + ModConfig.Worldgen.NETHER_FOG_COLOR[0] + ":" + ModConfig.Worldgen.NETHER_FOG_COLOR[1] + ":" + ModConfig.Worldgen.NETHER_FOG_COLOR[2]);
            DimensionManager.unregisterDimension((int)-1);
            DimensionType primal_nether = DimensionType.register((String)"Nether", (String)"_nether", (int)-1, ProviderHell.class, (boolean)false);
            DimensionManager.registerDimension((int)-1, (DimensionType)primal_nether);
        }
    }
}

