/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.entities.EntityBoatNether;
import nmd.primal.core.common.entities.EntityBoatWood;
import nmd.primal.core.common.entities.EntityFireProofItems;
import nmd.primal.core.common.entities.living.EntityBlackBear;
import nmd.primal.core.common.entities.living.EntityBrownBear;
import nmd.primal.core.common.entities.living.EntityCanisCampestris;
import nmd.primal.core.common.entities.living.EntityGator;
import nmd.primal.core.common.entities.living.EntityHammerHead;
import nmd.primal.core.common.entities.living.EntityNetherCreeper;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.entities.projectiles.EntityNetherHook;
import nmd.primal.core.common.entities.projectiles.TypeArrow;
import nmd.primal.core.common.entities.projectiles.TypeBottle;
import nmd.primal.core.common.entities.projectiles.TypeMud;
import nmd.primal.core.common.entities.projectiles.TypeRock;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;

@GameRegistry.ObjectHolder(value="primal")
public final class ModEntities {
    private static int ENTITY_ID = 0;
    private static ArrayList<String> FAKE_PLAYER_INTERACTION = new ArrayList();
    private static ArrayList<String> FAKE_PLAYER_SEED_NETHER = new ArrayList();
    private static ArrayList<String> FAKE_PLAYER_SEED_THEEND = new ArrayList();

    public static void preInit() {
        ModEntities.fakePlayerFactory();
    }

    public static void init() {
    }

    public static void postInit() {
        ModEntities.addEntitySpawns();
    }

    public static void addEntitySpawns() {
        PrimalAPI.logger(1, "Register Entity Spawning");
        EnumCreatureType shark_type = EnumCreatureType.WATER_CREATURE;
        EnumCreatureType canis_type = EnumCreatureType.CREATURE;
        EnumCreatureType bear_type = EnumCreatureType.CREATURE;
        EnumCreatureType gator_type = EnumCreatureType.CREATURE;
        EnumCreatureType ovis_type = EnumCreatureType.CREATURE;
        EnumCreatureType creeper_type = EnumCreatureType.MONSTER;
        HashSet nether = new HashSet();
        nether.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        HashSet ocean = new HashSet();
        ocean.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        HashSet forest = new HashSet();
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS));
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DEAD));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        HashSet mountain = new HashSet();
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DEAD));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        forest.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        HashSet wet = new HashSet();
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        forest.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WET));
        for (Biome biome : nether) {
            PrimalAPI.logger(60, "spawn biomes", "NETHER: " + biome);
        }
        if (ModConfig.Monsters.STEPPE_WOLF_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityCanisCampestris.class, (int)ModConfig.Monsters.STEPPE_WOLF_SPAWN_WEIGHT, (int)1, (int)3, (EnumCreatureType)canis_type, (Biome[])forest.toArray(new Biome[forest.size()]));
        }
        if (ModConfig.Monsters.BEAR_BROWN_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityBrownBear.class, (int)ModConfig.Monsters.BEAR_BROWN_SPAWN_WEIGHT, (int)1, (int)1, (EnumCreatureType)bear_type, (Biome[])mountain.toArray(new Biome[mountain.size()]));
        }
        if (ModConfig.Monsters.BEAR_BLACK_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityBlackBear.class, (int)ModConfig.Monsters.BEAR_BLACK_SPAWN_WEIGHT, (int)0, (int)2, (EnumCreatureType)bear_type, (Biome[])forest.toArray(new Biome[forest.size()]));
        }
        if (ModConfig.Monsters.ALLIGATOR_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityGator.class, (int)ModConfig.Monsters.ALLIGATOR_SPAWN_WEIGHT, (int)1, (int)3, (EnumCreatureType)gator_type, (Biome[])wet.toArray(new Biome[wet.size()]));
        }
        if (ModConfig.Monsters.SHARKS_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityHammerHead.class, (int)ModConfig.Monsters.SHARKS_SPAWN_WEIGHT, (int)0, (int)1, (EnumCreatureType)shark_type, (Biome[])ocean.toArray(new Biome[ocean.size()]));
        }
        if (ModConfig.Monsters.OVIS_ATRE_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityOvisAtre.class, (int)ModConfig.Monsters.OVIS_ATRE_SPAWN_WEIGHT, (int)1, (int)6, (EnumCreatureType)ovis_type, (Biome[])nether.toArray(new Biome[nether.size()]));
        }
        if (ModConfig.Monsters.NETHER_CREEPER_SPAWN_WEIGHT > 0) {
            EntityRegistry.addSpawn(EntityNetherCreeper.class, (int)ModConfig.Monsters.NETHER_CREEPER_SPAWN_WEIGHT, (int)0, (int)1, (EnumCreatureType)creeper_type, (Biome[])nether.toArray(new Biome[nether.size()]));
        }
    }

    public static ArrayList<String> getFakePlayers() {
        return FAKE_PLAYER_INTERACTION;
    }

    public static ArrayList<String> getNetherSeed() {
        return FAKE_PLAYER_SEED_NETHER;
    }

    public static ArrayList<String> getTheEndSeed() {
        return FAKE_PLAYER_SEED_THEEND;
    }

    public static void fakePlayerFactory() {
        for (JsonElement element : CommonUtils.getJSONArray("/seeds.json", "ehquah")) {
            FAKE_PLAYER_INTERACTION.add(CommonUtils.stringFromBase64(element.getAsJsonObject().get("seed").getAsString()));
        }
        for (JsonElement element : CommonUtils.getJSONArray("/seeds.json", "soghai")) {
            FAKE_PLAYER_SEED_NETHER.add(CommonUtils.stringFromBase64(element.getAsJsonObject().get("seed").getAsString()));
        }
        for (JsonElement element : CommonUtils.getJSONArray("/seeds.json", "zeigah")) {
            FAKE_PLAYER_SEED_THEEND.add(CommonUtils.stringFromBase64(element.getAsJsonObject().get("seed").getAsString()));
        }
    }

    private static <E extends Entity> EntityEntryBuilder<E> createEntity(String name) {
        return RegistryHelper.createEntity(name, "primal");
    }

    @Mod.EventBusSubscriber(modid="primal")
    public static class RegistrationHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            PrimalAPI.logger(1, "Registering Entities");
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("ovis_atre").entity(EntityOvisAtre.class).egg(0x333234, 14881378).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("canis_campestris").entity(EntityCanisCampestris.class).egg(0x787878, 0x383434).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("bear_brown").entity(EntityBrownBear.class).egg(7356437, 12880664).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("bear_black").entity(EntityBlackBear.class).egg(7356437, 0x242424).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("creeper_nether").entity(EntityNetherCreeper.class).egg(13709360, 8879473).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("gator").entity(EntityGator.class).egg(5550943, 7440244).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("shark_hammerhead").entity(EntityHammerHead.class).egg(14401857, 4297179).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("hook").entity(EntityNetherHook.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("rock").entity(TypeRock.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("mud").entity(TypeMud.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("arrow").entity(TypeArrow.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("bottle").entity(TypeBottle.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("boat_corypha").entity(EntityBoatNether.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("boat_wood").entity(EntityBoatWood.class).build());
            registry.register((IForgeRegistryEntry)ModEntities.createEntity("fire_proof").entity(EntityFireProofItems.class).build());
            EntitySpawnPlacementRegistry.setPlacementType(EntityHammerHead.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
            EntitySpawnPlacementRegistry.setPlacementType(EntityGator.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        }
    }
}

