/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.recipes.irecipe.RecipeHandler;

public class RecipeHelper {
    public static List<ItemStack> getIIngredientStacks(IIngredient ingredient) {
        if (ingredient != null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            int amount = ingredient.getAmount();
            for (IItemStack ct : ingredient.getItems()) {
                Object stack = ct.getInternal();
                if (!(stack instanceof ItemStack)) continue;
                ((ItemStack)stack).func_190920_e(amount);
                stacks.add((ItemStack)stack);
            }
            if (stacks.isEmpty()) {
                throw new IllegalArgumentException("ingredients entry does not match any valid items");
            }
            return stacks;
        }
        return null;
    }

    public static ItemStack getStackFromCT(IItemStack stack) {
        return stack != null && stack.getInternal() instanceof ItemStack ? (ItemStack)stack.getInternal() : ItemStack.field_190927_a;
    }

    public static FluidStack getStackFromCT(ILiquidStack stack) {
        return stack != null && stack.getInternal() instanceof FluidStack ? (FluidStack)stack.getInternal() : null;
    }

    public static ItemStack getFirstDictionaryMatch(String name, int amount) {
        NonNullList list = OreDictionary.getOres((String)name);
        if (!list.isEmpty()) {
            ItemStack stack = ((ItemStack)list.get(0)).func_77946_l();
            stack.func_190920_e(amount);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getOreStack(String name, int amount, ItemStack ... excluded) {
        NonNullList haystack = OreDictionary.getOres((String)name);
        ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
        block0: for (ItemStack stack : haystack) {
            for (ItemStack exclude : excluded) {
                if (stack.func_185136_b(exclude)) break block0;
            }
            ItemStack match = stack.func_77946_l();
            match.func_190920_e(amount);
            matches.add(match);
        }
        return matches;
    }

    public static List<ItemStack> getOreStack(int amount, String ... names) {
        ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
        for (String name : names) {
            NonNullList haystack = OreDictionary.getOres((String)name);
            for (ItemStack stack : haystack) {
                ItemStack match = stack.func_77946_l();
                match.func_190920_e(amount);
                matches.add(match);
            }
        }
        return matches;
    }

    public static boolean isBlock(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock;
    }

    public static boolean isBlock(Item item) {
        return item instanceof ItemBlock;
    }

    public static boolean validateStackObject(Object i) {
        if (i instanceof ItemStack) {
            return !((ItemStack)i).func_190926_b();
        }
        return i != null;
    }

    public static boolean validateRecipeObject(Object i) {
        if (i instanceof ItemStack) {
            return true;
        }
        if (i instanceof String) {
            return true;
        }
        if (i instanceof Block) {
            return true;
        }
        return i instanceof Item;
    }

    @SafeVarargs
    public static void addToList(List<List<ItemStack>> list, List<ItemStack> ... inputs) {
        for (List<ItemStack> input : inputs) {
            if (input == null || input.isEmpty()) continue;
            list.add(input);
        }
    }

    public static void addToList(List<ItemStack> list, ItemStack ... inputs) {
        for (ItemStack input : inputs) {
            if (input.func_190926_b()) continue;
            list.add(input);
        }
    }

    public static void dropSlotItems(World world, BlockPos pos, float offset, ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            double offsetX = (double)(PrimalCore.RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
            double offsetY = (double)(PrimalCore.RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
            double offsetZ = (double)(PrimalCore.RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack);
            item.func_174869_p();
            world.func_72838_d((Entity)item);
        }
    }

    public static boolean isToolEffective(ItemStack stack, IBlockState state) {
        if (!stack.func_190926_b()) {
            float speed = stack.func_77973_b().func_150893_a(stack, state);
            return speed > 1.0f;
        }
        return false;
    }

    public static boolean isPick(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return RecipeHelper.isToolEffective(stack, Blocks.field_150348_b.func_176223_P()) || stack.func_77973_b() instanceof ItemPickaxe;
        }
        return false;
    }

    public static boolean isAxe(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return RecipeHelper.isToolEffective(stack, Blocks.field_150344_f.func_176223_P()) || stack.func_77973_b() instanceof ItemAxe;
        }
        return false;
    }

    public static boolean isShovel(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return RecipeHelper.isToolEffective(stack, Blocks.field_150346_d.func_176223_P()) || stack.func_77973_b() instanceof ItemSpade;
        }
        return false;
    }

    public static boolean isHoe(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemHoe;
    }

    public static boolean isShears(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            return item instanceof ItemShears;
        }
        return false;
    }

    @Deprecated
    public static boolean isCraftingItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            return item.hasContainerItem(stack) && item.getItemStackLimit(stack) == 1 && item.func_77645_m();
        }
        return false;
    }

    public static List<ItemStack> getSlotList(List<List<ItemStack>> list, int index) {
        return list.size() > index ? list.get(index) : null;
    }

    public static List<ItemStack> getListFromObject(Object object) {
        if (object != null) {
            if (object instanceof ItemStack) {
                return new ArrayList<ItemStack>(Collections.singletonList((ItemStack)object));
            }
            if (object instanceof String) {
                return RecipeHelper.buildList(new OreIngredient((String)object).func_193365_a());
            }
            throw new IllegalArgumentException("Object is not of a valid type: ItemStack or String");
        }
        return null;
    }

    @Deprecated
    public static NonNullList<Ingredient> buildList(Object[] input) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            Ingredient ingredient = CraftingHelper.getIngredient((Object)obj);
            if (ingredient == null) {
                ingredient = Ingredient.field_193370_a;
            }
            list.add((Object)ingredient);
        }
        return list;
    }

    public static List<ItemStack> buildList(ItemStack ... inputs) {
        if (inputs != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack stack : inputs) {
                if (stack.func_190926_b()) continue;
                list.add(stack);
            }
            return list;
        }
        return null;
    }

    public static List<ItemStack> buildList(ItemStackHandler hand) {
        if (hand != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < hand.getSlots(); ++i) {
                ItemStack stack = hand.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                list.add(stack);
            }
            return list;
        }
        return null;
    }

    @SafeVarargs
    public static List<ItemStack> buildCombinedList(List<ItemStack> ... inputs) {
        if (inputs != null) {
            ArrayList<ItemStack> combined_list = new ArrayList<ItemStack>();
            for (List<ItemStack> list : inputs) {
                if (list == null || list.isEmpty()) continue;
                for (ItemStack stack : list) {
                    if (stack == null || stack.func_190926_b()) continue;
                    combined_list.add(stack);
                }
            }
            return combined_list;
        }
        return null;
    }

    public static void addCrossCrafting(String first, String second, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "FS", "SF", Character.valueOf('F'), first, Character.valueOf('S'), second);
        RecipeHandler.addShapedOreRecipe(out, "SF", "FS", Character.valueOf('F'), first, Character.valueOf('S'), second);
    }

    public static void addCrossCrafting(ItemStack first, ItemStack second, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "FS", "SF", Character.valueOf('F'), first, Character.valueOf('S'), second);
        RecipeHandler.addShapedOreRecipe(out, "SF", "FS", Character.valueOf('F'), first, Character.valueOf('S'), second);
    }

    public static void add2x2Crafting(String in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SS", "SS", Character.valueOf('S'), in);
    }

    public static void add2x2Crafting(ItemStack in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SS", "SS", Character.valueOf('S'), in);
    }

    public static void add3x3Crafting(String in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SSS", "SSS", "SSS", Character.valueOf('S'), in);
    }

    public static void add3x3Crafting(ItemStack in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SSS", "SSS", "SSS", Character.valueOf('S'), in);
    }

    public static void addBoxCrafting(String in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SSS", "S S", "SSS", Character.valueOf('S'), in);
    }

    public static void addBoxCrafting(ItemStack in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SSS", "S S", "SSS", Character.valueOf('S'), in);
    }

    public static void addBasicToolRecipe(Item item, String in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "C", "S", Character.valueOf('S'), in, Character.valueOf('C'), new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static void addBasicToolRecipe(Item item, ItemStack in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "C", "S", Character.valueOf('S'), in, Character.valueOf('C'), new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static void addLargeToolRecipe(Item item, String in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SSS", "SCS", "SSS", Character.valueOf('S'), in, Character.valueOf('C'), new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static void addLargeToolRecipe(Item item, ItemStack in, ItemStack out) {
        RecipeHandler.addShapedOreRecipe(out, "SSS", "SCS", "SSS", Character.valueOf('S'), in, Character.valueOf('C'), new ItemStack(item, 1, Short.MAX_VALUE));
    }

    @Deprecated
    public static boolean isOreName(IBlockState state, String ... names) {
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(block, 1, block.func_176201_c(state));
        for (String name : names) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOreName(ItemStack stack, List<String> names) {
        if (!stack.func_190926_b()) {
            for (String name : names) {
                for (ItemStack ore : OreDictionary.getOres((String)name)) {
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isOreName(ItemStack stack, String ... names) {
        if (!stack.func_190926_b()) {
            for (String name : names) {
                for (ItemStack ore : OreDictionary.getOres((String)name)) {
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isOreName(Item item, String ... names) {
        for (String name : names) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                if (ore.func_77973_b() != item) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOreName(Block block, String ... names) {
        for (String name : names) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                if (ore.func_77973_b() != Item.func_150898_a((Block)block)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOreName(Block block, List<String> names) {
        for (String name : names) {
            for (ItemStack ore : OreDictionary.getOres((String)name)) {
                if (ore.func_77973_b() != Item.func_150898_a((Block)block)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        if (item == Items.field_151065_br) {
            return 800;
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack);
    }

    public static void fuelManager(World world, TileEntity tile, ItemStack stackFuel) {
        if (!stackFuel.func_190926_b()) {
            Integer decrInt = (int)Math.floor(RecipeHelper.getBurnTime(stackFuel) / 150);
            if (decrInt == 0) {
                decrInt = 1;
            }
            Integer size = stackFuel.func_190916_E();
            Integer burnModifier = 0;
            if (size / 16 <= 1) {
                burnModifier = 0;
            }
            if (size / 16 > 1 && size / 16 <= 2) {
                burnModifier = 1;
            }
            if (size / 16 > 2 && size / 16 <= 3) {
                burnModifier = 2;
            }
            if (size / 16 > 3 && size / 16 <= 4) {
                burnModifier = 3;
            }
            if (PrimalAPI.randomCheck(decrInt) && PrimalAPI.randomCheck(burnModifier)) {
                stackFuel.func_190918_g(1);
                tile.func_70296_d();
            }
            if (size == 1) {
                stackFuel.func_190918_g(1);
                tile.func_70296_d();
            }
        }
    }

    public static boolean changeBlock(World world, BlockPos pos, IBlockState output_state, int smoke_chance) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_180501_a(pos, output_state, 2)) {
            if (!FireHelper.makeSmoke(world, pos, smoke_chance)) {
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.8f);
                for (int i = 0; i < 8; ++i) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean craftBlock(World world, BlockPos pos, EntityPlayer player, ItemStack tool_stack, IBlockState output_state, ItemStack output_stack) {
        if (world.field_72995_K) {
            return true;
        }
        IBlockState state_existing = world.func_180495_p(pos);
        Block block_existing = state_existing.func_177230_c();
        boolean success = output_state == null || output_state.func_185904_a() == Material.field_151579_a ? block_existing.removedByPlayer(state_existing, world, pos, player, false) : world.func_180501_a(pos, output_state, 2);
        if (success) {
            world.func_175685_c(pos, block_existing, false);
            tool_stack.func_77972_a(1, (EntityLivingBase)player);
            PlayerHelper.applyBlockStat(player, block_existing, 0.003f);
            PlayerHelper.spawnItemOnGround(world, pos, output_stack);
        }
        return success;
    }

    public static EnumActionResult craftBlockAction(World world, BlockPos pos, EntityPlayer player, ItemStack tool_stack, IBlockState output_state, ItemStack output_stack) {
        return RecipeHelper.craftBlock(world, pos, player, tool_stack, output_state, output_stack) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public static enum EnumOrientation implements IStringSerializable
    {
        NORMAL("normal"),
        FACING("facing"),
        LOG("log");

        private final String name;

        private EnumOrientation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

