/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumArmorSet;
import nmd.primal.core.api.interfaces.IArmorSet;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.entities.living.EntityNetherCreeper;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModEntities;

public class PlayerHelper {
    public static EntityEquipmentSlot[] full_suit = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public static EntityEquipmentSlot[] body_slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public static void applyBlockStat(EntityPlayer player, Block block, float exhaustion) {
        StatBase stat = StatList.func_188055_a((Block)block);
        if (stat != null) {
            player.func_71029_a(stat);
        }
        if (exhaustion > 0.0f) {
            player.func_71020_j(exhaustion);
        }
    }

    public static boolean setBedLocation(EntityPlayer player, @Nullable BlockPos pos, boolean forced) {
        BlockPos sleep_pos;
        BlockPos blockPos = sleep_pos = pos != null ? pos : player.func_180425_c();
        if (!ModConfig.Survival.DISABLE_PLAYER_SPAWN) {
            if (player.func_180470_cg() == null || !player.func_180470_cg().equals((Object)sleep_pos)) {
                player.setSpawnChunk(sleep_pos, forced, player.func_130014_f_().field_73011_w.getDimension());
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + I18n.func_74838_a((String)"chat.message.primal.set_spawn"), new Object[0]));
                return true;
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_74838_a((String)"chat.message.primal.cannot_set_spawn"), new Object[0]));
        }
        return false;
    }

    public static BlockPos getCorrectedPos(EntityLivingBase entity) {
        return new BlockPos(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
    }

    public static boolean isInMaterial(EntityLivingBase entity, Material material, double y_offset) {
        return entity.func_130014_f_().func_72875_a(entity.func_174813_aQ().func_72321_a((double)-0.1f, y_offset, (double)-0.1f), material);
    }

    public static boolean isInMaterial(EntityLivingBase entity, Material material) {
        return PlayerHelper.isInMaterial(entity, material, -0.4f);
    }

    public static boolean isSubmergedInMaterial(EntityLivingBase entity, Material material) {
        return PlayerHelper.isInMaterial(entity, material, entity.func_70047_e());
    }

    public static boolean isInSolidMaterial(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        AxisAlignedBB bb = entity.func_174813_aQ().func_72321_a((double)-0.1f, (double)entity.func_70047_e(), (double)-0.1f);
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (!world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2)).func_185914_p()) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public static boolean isSlotArmor(EntityEquipmentSlot ... slots) {
        for (EntityEquipmentSlot slot : slots) {
            for (EntityEquipmentSlot part : full_suit) {
                if (!slot.equals((Object)part)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArmorType(EntityLivingBase entity, EnumArmorSet type, EntityEquipmentSlot ... slots) {
        for (EntityEquipmentSlot slot : slots) {
            ItemStack stack = entity.func_184582_a(slot);
            if (stack.func_190926_b()) {
                return false;
            }
            Item item = stack.func_77973_b();
            if (!(item instanceof IArmorSet)) {
                return false;
            }
            if (((IArmorSet)item).getArmorType() == type) continue;
            return false;
        }
        return true;
    }

    public static boolean isArmorSlot(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack ... armorTypes) {
        ItemStack stack = entity.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack type : armorTypes) {
            if (!stack.func_185136_b(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmorSlot(EntityLivingBase entity, EntityEquipmentSlot slot, Item ... armorTypes) {
        ItemStack stack = entity.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        for (Item type : armorTypes) {
            if (stack.func_77973_b() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmorSlot(EntityLivingBase entity, EntityEquipmentSlot slot, EnumArmorSet ... armorTypes) {
        ItemStack stack = entity.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        for (EnumArmorSet type : armorTypes) {
            if (!(item instanceof IArmorSet) || ((IArmorSet)item).getArmorType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isFullArmor(EntityLivingBase entity, EnumArmorSet ... armorTypes) {
        for (EnumArmorSet type : armorTypes) {
            if (!PlayerHelper.isArmorType(entity, type, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFullArmor(EntityLivingBase entity, Item head, Item body, Item legs, Item feet) {
        Item[] armor = new Item[]{feet, legs, body, head};
        int i = 0;
        for (ItemStack slot : entity.func_184193_aE()) {
            if (slot.func_77973_b() != armor[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBodyArmor(EntityLivingBase entity, EnumArmorSet ... armorTypes) {
        for (EnumArmorSet type : armorTypes) {
            if (!PlayerHelper.isArmorType(entity, type, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLowerArmor(EntityLivingBase entity, EnumArmorSet ... armorTypes) {
        for (EnumArmorSet type : armorTypes) {
            if (!PlayerHelper.isArmorType(entity, type, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRidingBoat(EntityLivingBase entity) {
        if (entity.func_184218_aH()) {
            Entity boat = entity.func_184187_bx();
            return boat != null && boat.func_70026_G() && boat instanceof EntityBoat;
        }
        return false;
    }

    public static EnumFacing getPlacementFacing(EntityLivingBase placer, boolean has_facing) {
        return has_facing ? placer.func_174811_aO() : EnumFacing.SOUTH;
    }

    public static EnumFacing getPlacementFacing(EntityLivingBase placer) {
        return PlayerHelper.getPlacementFacing(placer, true);
    }

    public static void faceEntity(EntityLivingBase entity, Entity target, float maxYawIncrease, float maxPitchIncrease) {
        double d1;
        double d0 = target.field_70165_t - entity.field_70165_t;
        double d2 = target.field_70161_v - entity.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (entity.field_70163_u + (double)entity.func_70047_e());
        } else {
            d1 = (target.func_174813_aQ().field_72338_b + target.func_174813_aQ().field_72337_e) / 2.0 - (entity.field_70163_u + (double)entity.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        entity.field_70125_A = PlayerHelper.updateRotation(entity.field_70125_A, f1, maxPitchIncrease);
        entity.field_70177_z = PlayerHelper.updateRotation(entity.field_70177_z, f, maxYawIncrease);
    }

    private static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public static RayTraceResult rayTraceOffset(EntityLivingBase entity, double length, float offset) {
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)offset, entity.field_70161_v);
        Vec3d endPos = startPos.func_178787_e(new Vec3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        return entity.func_130014_f_().func_72933_a(startPos, endPos);
    }

    public static void giveItem(EntityPlayer player, ItemStack stack) {
        World world = player.func_130014_f_();
        BlockPos pos = player.func_180425_c();
        if (!player.field_71071_by.func_70441_a(stack)) {
            PrimalAPI.logger(2, "drop item");
            player.func_71019_a(stack, false);
        } else {
            world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public static void useStack(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
        }
    }

    public static void useStackTakeItem(EntityPlayer player, EnumHand hand, ItemStack stack) {
        ItemStack use = player.func_184586_b(hand);
        ItemStack take = stack.func_77946_l();
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)use.func_77973_b()));
            use.func_190918_g(1);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take);
        }
    }

    @Deprecated
    public static boolean playerTakeItem(World world, BlockPos pos, EnumFacing face, EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!world.field_72995_K && !stack.func_190926_b()) {
            IBlockState state = world.func_180495_p(pos);
            if (!player.func_191521_c(stack) && !player.field_71075_bZ.field_75098_d) {
                PlayerHelper.spawnItemOnGround(world, pos.func_177972_a(face), stack);
                world.func_184138_a(pos, state, state, 3);
            } else {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
            }
            return true;
        }
        return false;
    }

    public static void spawnItemOnPlayer(World world, EntityPlayer player, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            world.func_72838_d((Entity)entityitem);
            if (player instanceof FakePlayer) continue;
            entityitem.func_70100_b_(player);
        }
    }

    public static void spawnItemOnPlayer(World world, EntityPlayer player, ItemStack ... stacks) {
        PlayerHelper.spawnItemOnPlayer(world, player, new ArrayList<ItemStack>(Arrays.asList(stacks)));
    }

    public static void spawnItemOnGround(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + PrimalCore.RANDOM.nextDouble(0.2, 0.8), (double)pos.func_177956_o() + PrimalCore.RANDOM.nextDouble(0.1, 0.3), (double)pos.func_177952_p() + PrimalCore.RANDOM.nextDouble(0.2, 0.8), stack);
            entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
            world.func_72838_d((Entity)entity);
        }
    }

    public static void spawnItemOnGround(World world, BlockPos pos, ItemStack ... stacks) {
        PlayerHelper.spawnItemOnGround(world, pos, new ArrayList<ItemStack>(Arrays.asList(stacks)));
    }

    public static void spawnItemInAir(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            double d0 = (double)(PrimalCore.RANDOM.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(PrimalCore.RANDOM.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(PrimalCore.RANDOM.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnItemInAir(World world, BlockPos pos, ItemStack ... stacks) {
        PlayerHelper.spawnItemInAir(world, pos, new ArrayList<ItemStack>(Arrays.asList(stacks)));
    }

    public static ItemStack findItem(EntityPlayer player, String ... names) {
        for (String item : names) {
            if (RecipeHelper.isOreName(player.func_184586_b(EnumHand.OFF_HAND), item)) {
                return player.func_184586_b(EnumHand.OFF_HAND);
            }
            if (RecipeHelper.isOreName(player.func_184586_b(EnumHand.MAIN_HAND), item)) {
                return player.func_184586_b(EnumHand.MAIN_HAND);
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (!RecipeHelper.isOreName(itemstack, item)) continue;
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findItem(EntityPlayer player, ItemStack ... stacks) {
        for (ItemStack item : stacks) {
            if (player.func_184586_b(EnumHand.OFF_HAND).func_185136_b(item)) {
                return player.func_184586_b(EnumHand.OFF_HAND);
            }
            if (player.func_184586_b(EnumHand.MAIN_HAND).func_185136_b(item)) {
                return player.func_184586_b(EnumHand.MAIN_HAND);
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (!itemstack.func_185136_b(item)) continue;
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasItem(EntityPlayer player, String ... names) {
        return !PlayerHelper.findItem(player, names).func_190926_b();
    }

    public static boolean hasItem(EntityPlayer player, ItemStack ... stacks) {
        return !PlayerHelper.findItem(player, stacks).func_190926_b();
    }

    public static List<ItemStack> getHotBar(EntityPlayer player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            int j = (player.field_71071_by.field_70461_c + i) % 9;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(j);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        if (!player.func_184592_cb().func_190926_b()) {
            stacks.add(player.func_184592_cb());
        }
        return stacks;
    }

    public static List<ItemStack> getFullInventory(EntityPlayer player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 36; ++i) {
            int j = (player.field_71071_by.field_70461_c + i) % 36;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(j);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        if (!player.func_184592_cb().func_190926_b()) {
            stacks.add(player.func_184592_cb());
        }
        return stacks;
    }

    public static boolean isNetherEntity(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return PlayerHelper.isNetherCapable((EntityLivingBase)entity) || entity instanceof EntityOvisAtre || entity instanceof EntityNetherCreeper || entity instanceof EntityPigZombie || entity instanceof EntityGhast || entity instanceof EntityMagmaCube;
        }
        return false;
    }

    public static boolean isNetherCapable(EntityLivingBase entity) {
        return entity instanceof EntityPlayer && PlayerHelper.isPlayer((EntityPlayer)entity);
    }

    public static boolean isVoidCapable(EntityLivingBase entity) {
        if (ModConfig.Development.ENABLE_PLAYER_TESTING && entity instanceof EntityPlayer) {
            for (String check : ModEntities.getTheEndSeed()) {
                if (!PlayerHelper.getPlayerUUID((EntityPlayer)entity).equals(UUID.fromString(check))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPerturbed(EntityLivingBase entity) {
        return PlayerHelper.isMoving(entity) || entity.func_70026_G() || entity.func_180799_ab() || entity.func_184218_aH() || entity.field_70737_aN > 0 || entity.field_70733_aJ > 0.0f || entity.func_85035_bI() > 0;
    }

    public static boolean isMoving(EntityLivingBase entity) {
        return entity.field_70159_w != 0.0 && entity.field_70179_y != 0.0;
    }

    public static boolean isMoving(EntityLivingBase entity, float tolerance) {
        PrimalAPI.logger(2, "moving: " + entity.field_70159_w + ":" + entity.field_70181_x);
        return entity.field_70159_w > (double)tolerance || entity.field_70159_w < (double)(-tolerance) || entity.field_70179_y > (double)tolerance || entity.field_70179_y < (double)(-tolerance);
    }

    public static EntityLivingBase getLivingEntityByUUID(World world, UUID uuid) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityLivingBase) || !uuid.equals(entity.func_110124_au())) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    public static UUID getPlayerUUID(EntityPlayer player) {
        return player.func_110124_au();
    }

    private Optional<EntityPlayer> getPlayerFromBed(World world, BlockPos bed, boolean inBed) {
        return world.field_73010_i.stream().filter(player -> inBed ? player.func_70608_bn() && player.field_71081_bT.equals((Object)bed) : player.func_180470_cg().equals((Object)bed)).findAny();
    }

    public static boolean isPlayerConnected(World world, UUID ... uuids) {
        for (UUID uuid : uuids) {
            for (EntityPlayer player : world.field_73010_i) {
                if (player.func_110124_au() != uuid) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerConnected(World world, String ... strings) {
        for (String name : strings) {
            for (EntityPlayer player : world.field_73010_i) {
                if (!player.func_110124_au().toString().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerConnected(World world, ArrayList<String> strings) {
        for (String name : strings) {
            for (EntityPlayer player : world.field_73010_i) {
                if (!player.func_110124_au().toString().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerListed(World world, EntityPlayer player, ArrayList<String> strings) {
        for (String name : strings) {
            if (!player.func_110124_au().toString().equals(name) || player.func_70608_bn()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerActive(World world, ArrayList<String> strings) {
        for (String name : strings) {
            for (EntityPlayer player : world.field_73010_i) {
                if (!player.func_110124_au().toString().equals(name) || player.func_70608_bn() || PlayerHelper.isPlayerProtected(player)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerProtected(EntityPlayer player) {
        return PlayerHelper.isArmorSlot((EntityLivingBase)player, EntityEquipmentSlot.HEAD, PrimalAPI.Items.GOGGLES_DARK_LENS);
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player != null && player instanceof FakePlayer;
    }

    public static boolean isFakePlayer(EntityPlayer player, EnumHand hand) {
        return PlayerHelper.isFakePlayer(player) && player.func_184586_b(hand).func_190926_b();
    }

    public static boolean isPlayer(EntityPlayer player) {
        return PlayerHelper.getPlayerUUID(player).equals(UUID.fromString(ModEntities.getFakePlayers().get(1)));
    }

    public static boolean isActual(EntityPlayer player) {
        return PlayerHelper.getPlayerUUID(player).equals(UUID.fromString(ModEntities.getFakePlayers().get(0)));
    }
}

