/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class NBTHelper {
    private static NBTTagCompound setNBT(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static boolean hasNBT(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasTag(ItemStack stack, String key) {
        return NBTHelper.hasNBT(stack) && NBTHelper.getTag(stack).func_74764_b(key);
    }

    public static boolean removeCompound(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77982_d(null);
        }
        return NBTHelper.getTag(stack).func_82582_d();
    }

    public static void removeTags(ItemStack stack, String ... keys) {
        for (String key : keys) {
            if (!NBTHelper.hasTag(stack, key)) continue;
            NBTHelper.getTag(stack).func_82580_o(key);
        }
        if (NBTHelper.getTag(stack).func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    public static void setByte(ItemStack stack, String key, byte value) {
        NBTHelper.setNBT(stack).func_74774_a(key, value);
    }

    public static void setInteger(ItemStack stack, String key, int value) {
        NBTHelper.setNBT(stack).func_74768_a(key, value);
    }

    public static void setFloat(ItemStack stack, String key, float value) {
        NBTHelper.setNBT(stack).func_74776_a(key, value);
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NBTHelper.setNBT(stack).func_74757_a(key, value);
    }

    public static void setString(ItemStack stack, String key, String value) {
        NBTHelper.setNBT(stack).func_74778_a(key, value);
    }

    public static void setUniqueID(ItemStack stack, String key, UUID value) {
        NBTHelper.setNBT(stack).func_186854_a(key, value);
    }

    public static ItemStack setStackNBT(ItemStack stack, String key, Object value) {
        if (value instanceof String) {
            NBTHelper.setString(stack, key, (String)value);
        } else if (value instanceof Byte) {
            NBTHelper.setByte(stack, key, (Byte)value);
        } else if (value instanceof Integer) {
            NBTHelper.setInteger(stack, key, (Integer)value);
        } else if (value instanceof Float) {
            NBTHelper.setFloat(stack, key, ((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            NBTHelper.setBoolean(stack, key, (Boolean)value);
        } else {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack copyStackNBT(ItemStack input, ItemStack output) {
        if (input.func_77942_o()) {
            output.func_77982_d(input.func_77978_p());
        }
        return output;
    }

    public static void removeTag(ItemStack stack, String key) {
        NBTHelper.setNBT(stack).func_82580_o(key);
    }

    public static byte getByte(ItemStack stack, String key) {
        return NBTHelper.setNBT(stack).func_74771_c(key);
    }

    public static int getInteger(ItemStack stack, String key) {
        return NBTHelper.setNBT(stack).func_74762_e(key);
    }

    public static float getFloat(ItemStack stack, String key) {
        return NBTHelper.setNBT(stack).func_74760_g(key);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return NBTHelper.setNBT(stack).func_74767_n(key);
    }

    public static String getString(ItemStack stack, String key) {
        return NBTHelper.setNBT(stack).func_74779_i(key);
    }

    public static UUID getUniqueID(ItemStack stack, String key) {
        return NBTHelper.setNBT(stack).func_186857_a(key);
    }

    public static ItemStack getStackBlockNBT(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        NBTTagCompound nbt;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !(nbt = tile.func_189515_b(new NBTTagCompound())).func_82582_d()) {
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbt);
        }
        return stack;
    }

    public static BlockPos getPosFromTag(NBTTagCompound nbt) {
        if (nbt.func_74764_b("X") && nbt.func_74764_b("Y") && nbt.func_74764_b("Z")) {
            return NBTUtil.func_186861_c((NBTTagCompound)nbt);
        }
        return null;
    }

    public static void readNBTItems(NBTTagCompound tag, NonNullList<ItemStack> list, String name) {
        NBTTagList nbttaglist = tag.func_150295_c(name, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= list.size()) continue;
            list.set(j, (Object)new ItemStack(nbttagcompound));
        }
    }

    public static void readNBTItems(NBTTagCompound tag, ItemStackHandler stackHandler, String name) {
        NBTTagList nbttaglist = tag.func_150295_c(name, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= stackHandler.getSlots()) continue;
            stackHandler.setStackInSlot(j, new ItemStack(nbttagcompound));
        }
    }

    public static NBTTagCompound saveNBTItems(NBTTagCompound tag, NonNullList<ItemStack> list, String name) {
        return NBTHelper.saveNBTItems(tag, list, name, true);
    }

    public static NBTTagCompound saveNBTItems(NBTTagCompound tag, NonNullList<ItemStack> list, String name, boolean p_191281_2_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = (ItemStack)list.get(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d() || p_191281_2_) {
            tag.func_74782_a(name, (NBTBase)nbttaglist);
        }
        return tag;
    }

    public static NBTTagCompound saveNBTItems(NBTTagCompound tag, ItemStackHandler stackHandler, String name, boolean p_191281_2_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack itemstack = stackHandler.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d() || p_191281_2_) {
            tag.func_74782_a(name, (NBTBase)nbttaglist);
        }
        return tag;
    }

    public static NBTTagCompound getTag(NBTTagCompound tag, String key) {
        if (tag == null || !tag.func_74764_b(key)) {
            return new NBTTagCompound();
        }
        return tag.func_74775_l(key);
    }
}

