/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.PrimalBucket;
import nmd.primal.core.common.items.foods.BottleDrink;

public class FluidHelper {
    public static final int BOTTLE_VOLUME = 250;

    public static SoundEvent getSoundEmpty(ItemStack stack) {
        return stack.func_77973_b() instanceof BottleDrink ? SoundEvents.field_191241_J : SoundEvents.field_187624_K;
    }

    public static SoundEvent getSoundFill(ItemStack stack) {
        return stack.func_77969_a(new ItemStack(Items.field_151069_bo)) ? SoundEvents.field_187615_H : SoundEvents.field_187630_M;
    }

    public static ItemStack getFilledBucket(@Nonnull FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.getBucketFluids().contains(fluid)) {
            PrimalBucket bucket = PrimalAPI.Items.BUCKET_CINIS;
            ItemStack filledBucket = new ItemStack((Item)bucket);
            FluidStack fluidContents = new FluidStack(fluidStack, bucket.getCapacity());
            NBTTagCompound tag = new NBTTagCompound();
            fluidContents.writeToNBT(tag);
            filledBucket.func_77982_d(tag);
            return filledBucket;
        }
        return ItemStack.field_190927_a;
    }
}

