/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractTank;
import nmd.primal.core.common.blocks.misc.AshLayer;
import nmd.primal.core.common.blocks.parts.Drain;
import nmd.primal.core.common.blocks.parts.Slats;
import nmd.primal.core.common.blocks.parts.SmokeGrate;
import nmd.primal.core.common.blocks.working.DustBin;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.AbstractTileTank;

public class FireHelper {
    public static List<Block> FIRE_SOURCE_BLOCKS = Lists.newArrayList();
    public static List<Block> HEAT_SOURCE_BLOCKS = Lists.newArrayList();
    public static final Predicate<EntityLivingBase> WATER_SENSITIVE = new Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return FireHelper.isWaterSensitiveEntity(entity);
        }
    };

    public static boolean canCatchFire(World world, BlockPos pos, EnumFacing face) {
        return world.func_82736_K().func_82766_b("doFireTick") && world.func_180495_p(pos).func_177230_c().isFlammable((IBlockAccess)world, pos, face) && !world.func_175727_C(pos);
    }

    public static void setFire(World world, BlockPos pos) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doFireTick") && world.func_175697_a(pos, 10)) {
            if (world.func_180495_p(pos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(world, pos)) {
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos1 = pos.func_177982_a(PrimalCore.RANDOM.nextInt(3) - 1, PrimalCore.RANDOM.nextInt(3) - 1, PrimalCore.RANDOM.nextInt(3) - 1);
                if (world.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(world, blockpos1)) continue;
                world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public static void doLavaDamage(Entity entity, float damage) {
        if (!entity.func_70045_F()) {
            entity.func_70015_d(15);
            entity.func_70097_a(DamageSource.field_76371_c, damage);
        }
    }

    public static void doFireDamage(Entity entity, int time, float damage) {
        if (!entity.func_70045_F()) {
            entity.func_70015_d(time);
            entity.func_70097_a(DamageSource.field_76370_b, damage);
        }
    }

    public static boolean getCanBlockBurn(World world, BlockPos pos) {
        return (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || world.func_175667_e(pos)) && world.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    public static boolean isSurroundingBlockFlammable(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!FireHelper.getCanBlockBurn(world, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    public static boolean canBurn(World world) {
        return world.func_82736_K().func_82766_b("doFireTick");
    }

    private boolean canNeighborCatchFire(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!FireHelper.canCatchFire(world, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    public static boolean isFireSource(IBlockAccess world, BlockPos pos, IBlockState state) {
        return FireHelper.isFireSource(world, pos, state, FIRE_SOURCE_BLOCKS);
    }

    public static boolean isFireSource(IBlockAccess world, BlockPos pos, IBlockState state, List<Block> blocks) {
        Block block;
        FluidStack fluidStack;
        AbstractTileTank tile;
        if (state.func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151581_o) {
            return true;
        }
        for (Block block2 : blocks) {
            if (block2 != state.func_177230_c()) continue;
            return true;
        }
        if (state.func_177230_c() instanceof AbstractTank && (tile = (AbstractTileTank)world.func_175625_s(pos)) != null && !tile.func_145837_r() && !tile.isCovered() && (fluidStack = tile.getContainedFluid()) != null && fluidStack.amount >= 250 && (block = fluidStack.getFluid().getBlock()) != null) {
            return block.func_176223_P().func_185904_a() == Material.field_151587_i;
        }
        return false;
    }

    public static boolean hasNearByFire(World world, BlockPos pos, int horizontal, int vertical) {
        if (CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, horizontal, vertical, Material.field_151581_o, Material.field_151587_i)) {
            return true;
        }
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-horizontal, -vertical, -horizontal), (BlockPos)pos.func_177982_a(horizontal, vertical, horizontal))) {
            IBlockState state = world.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!FireHelper.isFireSource((IBlockAccess)world, pos, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNearByHeat(World world, BlockPos pos, int horizontal, int vertical, boolean include_fire_sources) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-horizontal, -vertical, -horizontal), (BlockPos)pos.func_177982_a(horizontal, vertical, horizontal))) {
            IBlockState check_state = world.func_180495_p((BlockPos)blockpos$mutableblockpos);
            Block check_block = check_state.func_177230_c();
            if (PrimalAPI.Predicates.FIRE_HEAT_SOURCE.apply((Object)check_state)) {
                return true;
            }
            for (Block block : HEAT_SOURCE_BLOCKS) {
                if (check_block != block) continue;
                if (check_block instanceof ILit) {
                    return ((ILit)check_block).isLit((IBlockAccess)world, (BlockPos)blockpos$mutableblockpos, check_state);
                }
                return true;
            }
            if (!include_fire_sources || !FireHelper.isFireSource((IBlockAccess)world, (BlockPos)blockpos$mutableblockpos, check_state)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDirectHeat(World world, BlockPos pos, EnumFacing facing) {
        BlockPos check_pos = pos.func_177972_a(facing);
        if (facing == EnumFacing.DOWN && FireHelper.canPassHeat(world, check_pos)) {
            check_pos = pos.func_177979_c(2);
        }
        IBlockState check_state = world.func_180495_p(check_pos);
        Block check_block = check_state.func_177230_c();
        PrimalAPI.logger(19, "hasDirectHeat: " + facing + ":" + check_block);
        if (PrimalAPI.Predicates.FIRE_HEAT_SOURCE.apply((Object)check_state)) {
            return true;
        }
        for (Block block : HEAT_SOURCE_BLOCKS) {
            if (check_block != block) continue;
            if (check_block instanceof ILit) {
                return ((ILit)check_block).isLit((IBlockAccess)world, check_pos, check_state);
            }
            return true;
        }
        return false;
    }

    public static boolean canPassHeat(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        if (MaterialMultiplexer.forMaterial(Material.field_151573_f, Material.field_151592_s).apply(state)) {
            return true;
        }
        if (block instanceof Slats) {
            return true;
        }
        if (block instanceof SmokeGrate) {
            return true;
        }
        if (block instanceof Drain && ((Boolean)state.func_177229_b((IProperty)PrimalAPI.States.OPEN)).booleanValue()) {
            return true;
        }
        if (block instanceof BlockTrapDoor && ((Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue()) {
            return true;
        }
        return block instanceof BlockHopper;
    }

    public static boolean explode(World world, BlockPos pos, int radius, float factor, boolean fire) {
        return FireHelper.explode(world, pos, null, radius, factor, fire, false);
    }

    public static boolean explode(World world, BlockPos pos, @Nullable Entity entity, int radius, float factor, boolean fire, boolean dead) {
        if (!world.field_72995_K) {
            PrimalAPI.logger(66, "explode", "radius: " + radius + ", factor: " + factor + ", fire: " + fire);
            world.func_72885_a(entity, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)radius * factor, fire, world.func_82736_K().func_82766_b("mobGriefing"));
            if (entity != null) {
                FireHelper.spawnLingeringCloud(world, pos, entity);
                if (dead) {
                    entity.func_70106_y();
                }
            }
            return true;
        }
        return false;
    }

    public static void spawnLingeringCloud(World world, BlockPos pos, @Nullable Entity entity) {
        Collection collection;
        if (entity != null && entity instanceof EntityLiving && !(collection = ((EntityLiving)entity).func_70651_bq()).isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            entityareaeffectcloud.func_184483_a(2.5f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            for (PotionEffect potioneffect : collection) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            world.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public static boolean isFluidHot(FluidStack fluid) {
        return fluid != null && fluid.getFluid().getTemperature(fluid) >= FluidRegistry.LAVA.getTemperature();
    }

    public static boolean isFluidVolatile(FluidStack fluid) {
        return fluid != null && (FireHelper.isFluidHot(fluid) || fluid.getFluid() == FluidRegistry.getFluid((String)"paraffin"));
    }

    public static boolean makeSmoke(World world, BlockPos pos, double chance) {
        return PrimalAPI.randomCheck(chance) && FireHelper.makeSmoke(world, pos);
    }

    public static boolean makeSmoke(World world, BlockPos pos, float chance) {
        return PrimalAPI.randomCheck(chance) && FireHelper.makeSmoke(world, pos);
    }

    public static boolean makeSmoke(World world, BlockPos pos, int chance) {
        return PrimalAPI.randomCheck(chance) && FireHelper.makeSmoke(world, pos);
    }

    public static boolean makeSmoke(World world, BlockPos pos) {
        if (ModConfig.Features.ENABLE_SMOKE && !world.field_72995_K) {
            if (FireHelper.makeSmokeAt(world, pos.func_177984_a())) {
                return true;
            }
            ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.field_176754_o));
            Collections.shuffle(faces);
            for (EnumFacing face : faces) {
                if (face == null || !FireHelper.makeSmokeAt(world, pos.func_177972_a(face))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean makeSmokeAt(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
            world.func_180501_a(pos, PrimalAPI.Fluids.SMOKE.getBlock().func_176223_P(), 2);
            return true;
        }
        return false;
    }

    public static boolean makeAsh(World world, BlockPos pos, int range, int amount) {
        return FireHelper.makeAsh(world, pos, range, amount, PrimalAPI.Blocks.ASH_COMMON);
    }

    public static boolean makeAsh(World world, BlockPos pos, int range, int amount, Block block) {
        boolean result = false;
        if (FireHelper.fillFoundAshBin(world, pos, 6)) {
            return true;
        }
        for (int a = 0; a < amount * 8; ++a) {
            int check_z;
            int check_y;
            int check_x = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)range));
            BlockPos pos_check = new BlockPos(check_x, check_y = MathHelper.func_76128_c((double)((double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * 4.0)), check_z = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)range)));
            IBlockState state_check = world.func_180495_p(pos_check);
            Block block_check = state_check.func_177230_c();
            if (block_check == block) {
                int layer_value = (Integer)state_check.func_177229_b((IProperty)PrimalAPI.States.LAYERS);
                if (layer_value <= 7) {
                    IBlockState state_update = state_check.func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(layer_value + 1));
                    world.func_180501_a(pos_check, state_update, 10);
                    SoundType soundtype = block.func_185467_w();
                    world.func_184133_a((EntityPlayer)null, pos_check, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    result = true;
                }
                pos_check = pos_check.func_177984_a();
            }
            if (!block.func_176196_c(world, pos_check) || !AshLayer.canReplaceBlock(world, pos_check)) continue;
            world.func_180501_a(pos_check, block.func_176223_P(), 2);
            result = true;
        }
        return result;
    }

    public static BlockPos findAshBin(World world, BlockPos pos, int range) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, 0, -range), (BlockPos)pos.func_177982_a(range, 1, range))) {
            IBlockState state = world.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!(state.func_177230_c() instanceof DustBin) || !DustBin.canFill(state)) continue;
            return blockpos$mutableblockpos;
        }
        return null;
    }

    public static boolean fillFoundAshBin(World world, BlockPos pos, int range) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, 0, -range), (BlockPos)pos.func_177982_a(range, 1, range))) {
            IBlockState state = world.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!(state.func_177230_c() instanceof DustBin) || !DustBin.increaseFillValue(world, (BlockPos)blockpos$mutableblockpos, state)) continue;
            PrimalAPI.logger(2, "ash_bin bin", "filling found bin");
            return true;
        }
        return false;
    }

    public static boolean isWaterSensitiveEntity(EntityLivingBase entity) {
        return entity instanceof EntityEnderman || entity instanceof EntityBlaze || PlayerHelper.isNetherCapable(entity) || PlayerHelper.isVoidCapable(entity);
    }

    public static void applyWater(Entity entity) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = entity.field_70170_p.func_175647_a(EntityLivingBase.class, axisalignedbb, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double d0 = entity.func_70068_e((Entity)entitylivingbase);
                if (!(d0 < 16.0) || !FireHelper.isWaterSensitiveEntity(entitylivingbase)) continue;
                entitylivingbase.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }
}

