/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumArmorSet;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.PlayerHelper;

public class DamageHelper {
    public static final DamageSourceWater WATER = new DamageSourceWater();
    public static final DamageSourceSun SUN = new DamageSourceSun();
    public static final DamageSourceWater HEALING = new DamageSourceWater();
    public static final DamageSourceLifeDrain DRAIN = new DamageSourceLifeDrain();
    public static final DamageSourceIronwood IRONWOOD = new DamageSourceIronwood();
    public static final DamageSourceBlock BLOCK = new DamageSourceBlock();
    public static final DamageSourcePitfall PITFALL = new DamageSourcePitfall();
    public static final DamageSourceMagma MAGMA = new DamageSourceMagma();
    public static final DamageSourceBitumen BITUMEN = new DamageSourceBitumen();
    public static final DamageSourceParaffin PARAFFIN = new DamageSourceParaffin();
    public static final DamageSourceAconite ACONITE = new DamageSourceAconite();
    public static final DamageSourceAconite YEW = new DamageSourceAconite();
    public static final DamageSourceDaucus DAUCUS = new DamageSourceDaucus();

    public static DamageSource causeEntityPitfallDamage(String type, Entity entity) {
        return new EntityDamageSourcePitfall(type, entity);
    }

    public static DamageSource causeEntityWaterDamage(String type, Entity entity) {
        return new EntityDamageSourceWater(type, entity);
    }

    public static DamageSource causeEntityHealingDamage(String type, Entity entity) {
        return new EntityDamageSourceHealing(type, entity);
    }

    public static DamageSource causeEntityLifeDrain(String type, Entity entity) {
        return new EntityDamageSourceLifeDrain(type, entity);
    }

    public static DamageSource causeEntityParaffinDamage(String type, Entity entity) {
        return new EntityDamageSourceParaffin(type, entity);
    }

    public static DamageSource causeIronwoodArrowDamage(EntityArrow arrow, @Nullable Entity indirectEntityIn) {
        return new EntityDamageSourceIndirect("arrow_ironwood", (Entity)arrow, indirectEntityIn).func_76349_b();
    }

    public static void killEntity(EntityLivingBase entity, DamageSource source) {
        if (!entity.field_70128_L) {
            entity.func_70097_a(source, Float.MAX_VALUE);
        }
    }

    public static void healNoEvent(EntityLivingBase entity, float amount) {
        float f = entity.func_110143_aJ();
        if (f > 0.0f) {
            entity.func_70606_j(f + amount);
        }
    }

    public static void damageNoEvent(EntityLivingBase entity, DamageSource source, float damageAmount) {
        if (!entity.func_180431_b(source)) {
            damageAmount = DamageHelper.applyArmorCalculations(entity, source, damageAmount);
            float f = damageAmount = DamageHelper.applyPotionDamageCalculations(entity, source, damageAmount);
            damageAmount = Math.max(damageAmount - entity.func_110139_bj(), 0.0f);
            entity.func_110149_m(entity.func_110139_bj() - (f - damageAmount));
            if (damageAmount != 0.0f) {
                float health = entity.func_110143_aJ();
                entity.func_110142_aN().func_94547_a(source, health, damageAmount);
                entity.func_70606_j(health - damageAmount);
                entity.func_110149_m(entity.func_110139_bj() - damageAmount);
            }
        }
    }

    private static float applyArmorCalculations(EntityLivingBase entity, DamageSource source, float damage) {
        if (!source.func_76363_c()) {
            damage = CombatRules.func_189427_a((float)damage, (float)entity.func_70658_aO(), (float)((float)entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        }
        return damage;
    }

    private static float applyPotionDamageCalculations(EntityLivingBase entity, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (entity.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (entity.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)entity.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    public static boolean applyWaterDamage(EntityLivingBase entity, int amplifier, boolean no_water_check) {
        if (entity.func_70026_G() || no_water_check) {
            float appliedDamage;
            PrimalAPI.logger(31, "water damage", "amplifier: " + amplifier);
            if (CompatHelper.isFullQuantum(entity)) {
                return false;
            }
            float f = appliedDamage = PlayerHelper.isFullArmor(entity, EnumArmorSet.MUMMIFIED, EnumArmorSet.VITRIFIED, EnumArmorSet.SINUOUS) ? 0.0f : 0.5f;
            if (entity.func_70090_H()) {
                appliedDamage += 1.5f;
            }
            if (appliedDamage > 0.0f) {
                FXHelper.fxEnvironmentDamage(entity);
                return entity.func_70097_a((DamageSource)WATER, appliedDamage);
            }
        }
        return false;
    }

    public static boolean applySunDamage(EntityLivingBase entity, int amplifier) {
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        if (world.field_73011_w.func_191066_m() && world.func_72935_r() && world.func_175678_i(pos) && !PlayerHelper.isSubmergedInMaterial(entity, Material.field_151586_h)) {
            if (CompatHelper.isFullQuantum(entity)) {
                return false;
            }
            float appliedDamage = 0.5f * (float)(amplifier + 1);
            if (amplifier > 2) {
                entity.func_70015_d(8);
            }
            PrimalAPI.logger(31, "sun damage", "amplifier: " + amplifier);
            PrimalAPI.logger(31, "sun damage", "damage: " + appliedDamage);
            PrimalAPI.logger(31, "sun damage", "sky light: " + world.func_175657_ab() + ":" + world.func_72826_c(1.0f));
            return entity.func_70097_a((DamageSource)SUN, appliedDamage);
        }
        return false;
    }

    public static class EntityDamageSourceDaucus
    extends EntityDamageSource {
        public EntityDamageSourceDaucus(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
        }
    }

    public static class EntityDamageSourceYew
    extends EntityDamageSource {
        public EntityDamageSourceYew(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
        }
    }

    public static class EntityDamageSourceAconite
    extends EntityDamageSource {
        public EntityDamageSourceAconite(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
        }
    }

    public static class EntityDamageSourceWood
    extends EntityDamageSource {
        public EntityDamageSourceWood(String type, Entity entity) {
            super(type, entity);
        }
    }

    public static class EntityDamageSourceIronwood
    extends EntityDamageSource {
        public EntityDamageSourceIronwood(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
            this.func_82726_p();
        }
    }

    public static class EntityDamageSourceParaffin
    extends EntityDamageSource {
        public EntityDamageSourceParaffin(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
        }
    }

    public static class EntityDamageSourceLifeDrain
    extends EntityDamageSource {
        public EntityDamageSourceLifeDrain(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
            this.func_82726_p();
        }
    }

    public static class EntityDamageSourceHealing
    extends EntityDamageSource {
        public EntityDamageSourceHealing(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
            this.func_82726_p();
        }
    }

    public static class EntityDamageSourceWater
    extends EntityDamageSource {
        public EntityDamageSourceWater(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
        }
    }

    public static class EntityDamageSourcePitfall
    extends EntityDamageSource {
        public EntityDamageSourcePitfall(String type, Entity entity) {
            super(type, entity);
            this.func_76348_h();
        }
    }

    public static class DamageSourceDaucus
    extends DamageSource {
        protected DamageSourceDaucus() {
            super("primal.daucus");
            this.func_76348_h();
        }
    }

    public static class DamageSourceYew
    extends DamageSource {
        protected DamageSourceYew() {
            super("primal.yew");
            this.func_76348_h();
        }
    }

    public static class DamageSourceAconite
    extends DamageSource {
        protected DamageSourceAconite() {
            super("primal.aconite");
            this.func_76348_h();
        }
    }

    public static class DamageSourceParaffin
    extends DamageSource {
        protected DamageSourceParaffin() {
            super("primal.paraffin");
            this.func_76348_h();
            this.func_94540_d();
        }
    }

    public static class DamageSourceBitumen
    extends DamageSource {
        protected DamageSourceBitumen() {
            super("primal.bitumen");
            this.func_76348_h();
            this.func_76361_j();
        }
    }

    public static class DamageSourceMagma
    extends DamageSource {
        protected DamageSourceMagma() {
            super("primal.magma");
            this.func_76348_h();
            this.func_76361_j();
        }
    }

    public static class DamageSourceBlock
    extends DamageSource {
        protected DamageSourceBlock() {
            super("primal.block");
            this.func_76348_h();
        }
    }

    public static class DamageSourceIronwood
    extends DamageSource {
        protected DamageSourceIronwood() {
            super("primal.ironwood");
        }
    }

    public static class DamageSourceLifeDrain
    extends DamageSource {
        protected DamageSourceLifeDrain() {
            super("primal.drain");
            this.func_76348_h();
            this.func_82725_o();
        }
    }

    public static class DamageSourceHealing
    extends DamageSource {
        protected DamageSourceHealing() {
            super("primal.healing");
            this.func_76348_h();
            this.func_82725_o();
        }
    }

    public static class DamageSourceSun
    extends DamageSource {
        protected DamageSourceSun() {
            super("primal.sun");
            this.func_76348_h();
            this.func_82725_o();
        }
    }

    public static class DamageSourceWater
    extends DamageSource {
        protected DamageSourceWater() {
            super("primal.water");
            this.func_76348_h();
        }
    }

    public static class DamageSourcePitfall
    extends DamageSource {
        protected DamageSourcePitfall() {
            super("primal.pitfall");
            this.func_76348_h();
        }
    }
}

