/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import flaxbeard.cyberware.api.CyberwareAPI;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModCompat;

public class CompatHelper {
    public static boolean isModAvailable(String mod_id) {
        return Loader.isModLoaded((String)mod_id);
    }

    public static boolean isBlockMatch(String mod_id, Block mod_block, Block match_block) {
        return Loader.isModLoaded((String)mod_id) && mod_block != null && mod_block == match_block;
    }

    public static boolean isFullQuantum(EntityLivingBase entity) {
        return Loader.isModLoaded((String)"ic2") && PlayerHelper.isFullArmor(entity, ModCompat.IC2_QUANTUM_HELMET, ModCompat.IC2_QUANTUM_CHESTPLATE, ModCompat.IC2_QUANTUM_LEGGINGS, ModCompat.IC2_QUANTUM_BOOTS);
    }

    public static boolean isSlotQuantum(EntityLivingBase entity, EntityEquipmentSlot slot, Item armor) {
        return Loader.isModLoaded((String)"ic2") && PlayerHelper.isArmorSlot(entity, slot, armor);
    }

    public static boolean isCyberwareInstalled(EntityLivingBase entity, Item item) {
        return Loader.isModLoaded((String)"cyberware") && CyberwareAPI.isCyberwareInstalled((Entity)entity, (ItemStack)new ItemStack(item));
    }

    public static boolean isModEntityValid(String mod_id, EntityEntry entityEntry) {
        return Loader.isModLoaded((String)mod_id) && ForgeRegistries.ENTITIES.containsValue((IForgeRegistryEntry)entityEntry);
    }

    public static boolean isModEntityMatch(Class target, String mod_id, EntityEntry entityEntry) {
        return CompatHelper.isModEntityValid(mod_id, entityEntry) && entityEntry.getEntityClass() == target;
    }

    public static boolean isModEntityMatch(Entity target, String mod_id, EntityEntry entityEntry) {
        return CompatHelper.isModEntityMatch(target.getClass(), mod_id, entityEntry);
    }

    public static boolean isModEntityMatch(Class target, String mod_id, EntityEntry ... entityEntries) {
        if (Loader.isModLoaded((String)mod_id)) {
            for (EntityEntry entityEntry : entityEntries) {
                if (!ForgeRegistries.ENTITIES.containsValue((IForgeRegistryEntry)entityEntry) || entityEntry.getEntityClass() != target) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMonk(EntityLivingBase entity) {
        return Loader.isModLoaded((String)"monk") && entity.func_184614_ca().func_190926_b();
    }
}

