/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids.gas;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.gas.AbstractGas;
import nmd.primal.core.common.helper.FireHelper;

public class Smoke
extends AbstractGas {
    private int decayRate = 60;

    public Smoke(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 2));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        for (int i = 0; i < 6; ++i) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + (double)random.nextFloat(), (double)pos.func_177956_o() + (double)(random.nextFloat() * 0.2f), (double)pos.func_177952_p() + (double)random.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + (double)random.nextFloat(), (double)pos.func_177956_o() + (double)(random.nextFloat() * 0.2f), (double)pos.func_177952_p() + (double)random.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && PrimalAPI.randomCheck(16) && FireHelper.makeAsh(world, pos, 6, 1)) {
            world.func_175698_g(pos);
            return;
        }
        world.func_180497_b(pos, (Block)this, this.decayRate, 1);
        super.func_180650_b(world, pos, state, rand);
    }

    @Override
    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof BlockTorch || super.displaceIfPossible(world, pos);
    }
}

