/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.init.ModConfig;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.thirst.IDrink;
import toughasnails.api.thirst.ThirstHelper;

@Optional.Interface(iface="toughasnails.api.thirst.IDrink", modid="toughasnails", striprefs=true)
public class PrimalBucketMilk
extends ItemBucketMilk
implements IFireProof<Item>,
IDictionaryName<Item>,
IDrink {
    private boolean is_fire_proof;
    private int thirst;
    private float hydration;
    private float poison;
    private String[] dictionary_names;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        } else if (ModConfig.Fluids.BUCKETS_PICKUP_HOT_FLUIDS) {
            tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_unsafe"));
        }
        this.thirst = 6;
        this.hydration = 0.7f;
        this.poison = 0.0f;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        return this.hasContainerItem(stack) ? this.getEmptyBucket().func_77946_l() : super.getContainerItem(stack);
    }

    @Optional.Method(modid="toughasnails")
    public int getThirst() {
        return this.thirst;
    }

    @Optional.Method(modid="toughasnails")
    public float getHydration() {
        return this.hydration;
    }

    @Optional.Method(modid="toughasnails")
    public float getPoisonChance() {
        return this.poison;
    }

    @Override
    public Item setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Item)this), name);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entity) {
        if (!worldIn.field_72995_K) {
            entity.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            CriteriaTriggers.field_193138_y.func_193148_a(entityplayermp, stack);
            entityplayermp.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (Loader.isModLoaded((String)"toughasnails") && entity instanceof EntityPlayer) {
            IThirst thirst = ThirstHelper.getThirstData((EntityPlayer)((EntityPlayer)entity));
            thirst.addStats(this.getThirst(), this.getHydration());
        }
        return stack.func_190926_b() ? this.getEmptyBucket() : stack;
    }

    public ItemStack getEmptyBucket() {
        if (this == PrimalAPI.Items.BUCKET_CLAY_MILK) {
            return new ItemStack((Item)PrimalAPI.Items.BUCKET_CLAY);
        }
        if (this == PrimalAPI.Items.BUCKET_TERRA_MILK) {
            return new ItemStack((Item)PrimalAPI.Items.BUCKET_TERRA);
        }
        if (this == PrimalAPI.Items.BUCKET_CINIS_MILK) {
            return new ItemStack((Item)PrimalAPI.Items.BUCKET_CINIS);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public PrimalBucketMilk setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }
}

