/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.AbstractFluidBlock;
import nmd.primal.core.common.fluids.custom.ParaffinFluid;
import nmd.primal.core.common.helper.BlockHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModFluids;

public class Paraffin
extends AbstractFluidBlock {
    public static final int PARAFFIN_STABILITY_MODIFIER = 40;
    public static final int PARAFFIN_VOLATILITY = 60;

    public Paraffin(Fluid fluid) {
        super(fluid, Material.field_151586_h);
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DANGER_OTHER;
    }

    public static <T extends Block> ParaffinFluid createFluid(String name, int color, Consumer<ParaffinFluid> fluidPropertyApplier, Function<ParaffinFluid, T> blockFactory) {
        ParaffinFluid fluid = new ParaffinFluid(name, "primal", color);
        if (FluidRegistry.registerFluid((Fluid)fluid)) {
            fluidPropertyApplier.accept(fluid);
            ModFluids.FLUID_BLOCKS.add((IFluidBlock)blockFactory.apply(fluid));
        }
        return fluid;
    }

    public boolean tryToExplode(World world, BlockPos pos, IBlockState state, int chance, boolean condition) {
        Block block = state.func_177230_c();
        if (block instanceof AbstractFluidBlock) {
            if (!BlockHelper.hasStabilizingBlock((IBlockAccess)world, pos, EnumFacing.values())) {
                if (PrimalAPI.randomCheck(chance) && (condition || FireHelper.hasNearByFire(world, pos, 4, 3))) {
                    return FireHelper.explode(world, pos, null, RANDOM.nextInt(4, 8), (float)ModConfig.Fluids.PARAFFIN_FLUID_EXPLOSION_MODIFIER, true, false);
                }
                if (PrimalAPI.randomCheck(chance * 2) && !((AbstractFluidBlock)block).isSourceBlock((IBlockAccess)world, pos)) {
                    return FireHelper.explode(world, pos, null, RANDOM.nextInt(2, 5), (float)ModConfig.Fluids.PARAFFIN_FLUID_EXPLOSION_MODIFIER, true, false);
                }
            }
            if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                FXHelper.makeParticles(world, pos, EnumParticleTypes.EXPLOSION_NORMAL, 2, 2, 0.9f, 0.0);
            }
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        this.tryToExplode(world, pos, state, 360, entity instanceof EntityLivingBase || entity instanceof EntityItem || entity instanceof EntityThrowable);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        super.func_189540_a(state, world, pos, block, neighborPos);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.EXPLOSION_NORMAL, 2, 0, 0.9f, 0.0);
        }
        this.tryToExplode(world, pos, state, 60, false);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.tryToExplode(world, pos, state, 60, false)) {
            super.func_180650_b(world, pos, state, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (!this.isSourceBlock((IBlockAccess)world, pos) && PrimalAPI.randomCheck(16)) {
            world.func_175688_a(EnumParticleTypes.CLOUD, (double)((float)pos.func_177958_n() + RANDOM.nextFloat()), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + RANDOM.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public boolean doFluidMixing(World world, BlockPos pos, IBlockState state) {
        for (EnumFacing facing : EnumFacing.values()) {
            IBlockState facing_state = world.func_180495_p(pos.func_177972_a(facing));
            Block facing_block = facing_state.func_177230_c();
            this.tryToExplode(world, pos, state, 60, facing_block != PrimalAPI.Fluids.PARAFFIN.getBlock() && (PrimalAPI.Predicates.FIRE_HEAT_SOURCE.apply((Object)facing_state) || MaterialMultiplexer.forMaterial(Material.field_151581_o, Material.field_151587_i, Material.field_151586_h, Material.field_151567_E).apply(facing_state)));
        }
        return false;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

