/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.AbstractFluidBlock;
import nmd.primal.core.common.fluids.custom.BitumenFluid;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.init.ModFluids;

public class Bitumen
extends AbstractFluidBlock {
    private boolean boiling;

    public Bitumen(Fluid fluid) {
        super(fluid, Material.field_151586_h);
    }

    public static <T extends Block> BitumenFluid createFluid(String name, int color, Consumer<BitumenFluid> fluidPropertyApplier, Function<BitumenFluid, T> blockFactory) {
        BitumenFluid fluid = new BitumenFluid(name, "primal", color);
        if (FluidRegistry.registerFluid((Fluid)fluid)) {
            fluidPropertyApplier.accept(fluid);
            ModFluids.FLUID_BLOCKS.add((IFluidBlock)blockFactory.apply(fluid));
        }
        return fluid;
    }

    public boolean isBoiling() {
        return this.boiling;
    }

    public Bitumen setBoiling(boolean boil) {
        this.boiling = boil;
        return this;
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_OTHER;
    }

    @Override
    public boolean isSolidTexture() {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        entity.func_70110_aj();
        if (this.boiling && PrimalAPI.randomCheck(6)) {
            entity.func_70097_a((DamageSource)DamageHelper.BITUMEN, 2.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (this.isBoiling() && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p() && !world.func_175727_C(pos.func_177984_a())) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.EXPLOSION_NORMAL, 2, 16, 0.9f, 0.0);
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if ((this.isBoiling() || world.field_73011_w.func_177495_o()) && !this.isSourceBlock((IBlockAccess)world, pos) && !this.isFlowingVertically((IBlockAccess)world, pos)) {
            world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
        }
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isBoiling() ? 260 : 160;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isBoiling() ? 15 : 5;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP;
    }
}

