/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IInflictedDamage;
import nmd.primal.core.api.interfaces.ISoundSuppression;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.plants.AbstractPlantInvasive;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.TeleportHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModCapabilities;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModEntities;
import nmd.primal.core.common.network.MessageClientSettings;
import nmd.primal.core.common.potions.ModPotions;

@Mod.EventBusSubscriber
public final class PlayerEvents {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.func_130014_f_().field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            PrimalCore.NETWORK.sendTo((IMessage)new MessageClientSettings(ModConfig.Survival.HIDE_PLAYER_NAMES, ModConfig.Lighting.AMBIENT_LIGHT_GLOBAL, (float)ModConfig.Lighting.AMBIENT_LIGHT_LEVEL, ModConfig.Lighting.AMBIENT_LIGHT_DIMENSIONS), playerMP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        int from = event.fromDim;
        int to = event.toDim;
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.Survival.PORTAL_SPREAD) {
            if (from == 0 && to == -1) {
                switch (PrimalCore.RANDOM.nextInt(16)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ((IInvasive)PrimalAPI.Blocks.DRY_GRASS).spreadPlant(world, player.func_180425_c(), PrimalAPI.Blocks.DRY_GRASS.func_176223_P(), (AbstractPlantInvasive)PrimalAPI.Blocks.DRY_GRASS, 0.0f, 16, 6);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        CommonUtils.spreadBlock(world, player.func_180425_c(), PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), BlockMultiplexer.forBlock(Blocks.field_150424_aL), 0, 16, 4);
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        CommonUtils.spreadBlock(world, player.func_180425_c(), Blocks.field_150349_c.func_176223_P(), BlockMultiplexer.forBlock(Blocks.field_150346_d), 0, 16, 3);
                    }
                    default: {
                        CommonUtils.spreadBlock(world, player.func_180425_c(), Blocks.field_150346_d.func_176223_P(), BlockMultiplexer.forBlock(Blocks.field_150424_aL), 0, 16, 4);
                        break;
                    }
                }
            } else if (from == -1 && to == 0) {
                switch (PrimalCore.RANDOM.nextInt(12)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        CommonUtils.spreadBlock(world, player.func_180425_c(), PrimalAPI.Blocks.NETHER_GROWTH.func_176223_P(), BlockMultiplexer.forBlock(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}), 0, 16, 4);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        CommonUtils.spreadBlock(world, player.func_180425_c(), PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), BlockMultiplexer.forBlock(new Block[]{Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_180395_cM}), 0, 9, 6);
                        break;
                    }
                    case 6: {
                        CommonUtils.spreadBlock(world, player.func_180425_c(), Blocks.field_150424_aL.func_176223_P(), BlockMultiplexer.forBlock(Blocks.field_150348_b), 0, 9, 6);
                        break;
                    }
                    default: {
                        ((IInvasive)PrimalAPI.Blocks.DRY_GRASS).spreadPlant(world, player.func_180425_c(), PrimalAPI.Blocks.DRY_GRASS.func_176223_P(), (AbstractPlantInvasive)PrimalAPI.Blocks.DRY_GRASS, 0.0f, 6, 6);
                        break;
                    }
                }
            } else if (from == 1 && to == 0) {
                ((IInvasive)PrimalAPI.Blocks.INANIS_GRASS).spreadPlant(world, player.func_180425_c(), PrimalAPI.Blocks.INANIS_GRASS.func_176223_P(), (AbstractPlantInvasive)PrimalAPI.Blocks.INANIS_GRASS, 0.0f, 6, 8);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (PlayerHelper.isNetherCapable((EntityLivingBase)player)) {
            if (player.func_180799_ab() && !player.field_71075_bZ.field_75100_b) {
                player.field_70159_w *= 1.25;
                player.field_70179_y *= 1.25;
            }
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            if (world.field_72995_K) {
                return;
            }
            if (PrimalAPI.randomCheck(8)) {
                ModCapabilities.toggleCapabilityEffect(player, MobEffects.field_76439_r, !ModCapabilities.hasLightProtection(player));
                ModCapabilities.toggleCapabilityEffect(player, MobEffects.field_76440_q, ModCapabilities.hasSensitiveLight(player) && !ModCapabilities.hasLightProtection(player));
                ModCapabilities.addCapabilityEffect(player, MobEffects.field_76426_n);
                ModCapabilities.addCapabilityEffect(player, ModPotions.WATER_BURN, 1);
                if (player.func_70644_a(MobEffects.field_76428_l) && player.func_110143_aJ() > 1.0f) {
                    player.func_70097_a((DamageSource)DamageHelper.HEALING, ModPotions.getPotionAmplifier((EntityLivingBase)player, MobEffects.field_76428_l) > 0 ? 2.0f : 1.0f);
                }
                if (player.func_70644_a(MobEffects.field_76436_u) && player.func_110143_aJ() < player.func_110138_aP()) {
                    player.func_70691_i(ModPotions.getPotionAmplifier((EntityLivingBase)player, MobEffects.field_76436_u) > 0 ? 1.0f : 0.5f);
                }
                if (player.func_70644_a(MobEffects.field_76438_s)) {
                    player.func_71024_bL().func_75122_a(ModPotions.getPotionAmplifier((EntityLivingBase)player, MobEffects.field_76438_s) + 1, 1.0f);
                    player.func_184589_d(MobEffects.field_76428_l);
                    player.func_184589_d(MobEffects.field_76438_s);
                }
                if (player.func_70644_a(MobEffects.field_82731_v) && PrimalAPI.randomCheck(24)) {
                    player.func_184589_d(MobEffects.field_82731_v);
                }
            }
        }
        if (PlayerHelper.isVoidCapable((EntityLivingBase)player)) {
            if (world.field_72995_K) {
                return;
            }
            if (PrimalAPI.randomCheck(8)) {
                return;
            }
            ModCapabilities.addCapabilityEffect(player, ModPotions.WATER_BURN, 0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onHeal(LivingHealEvent event) {
        World world = event.getEntity().func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        if (PlayerHelper.isNetherCapable(entity) && entity.func_70644_a(MobEffects.field_76428_l)) {
            PrimalAPI.logger(600, "capability", "regeneration");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (PlayerHelper.isNetherCapable(entity) && entity.func_70644_a(MobEffects.field_76436_u)) {
            PrimalAPI.logger(600, "capability", "poison");
            event.setCanceled(true);
        }
        if (PlayerHelper.isVoidCapable(entity)) {
            if (source == DamageHelper.WATER && PrimalAPI.randomCheck(0.9f)) {
                if (TeleportHelper.teleportRandomly(entity, 64)) {
                    event.setCanceled(true);
                }
            } else if (source instanceof EntityDamageSourceIndirect && PrimalAPI.randomCheck(0.85f)) {
                PrimalAPI.logger(2, "indirect damage: " + event.getAmount());
                TeleportHelper.teleportRandomly(entity, 64);
            } else if (event.getAmount() > 6.0f) {
                PrimalAPI.logger(2, "large damage: " + event.getAmount());
                TeleportHelper.teleportRandomly(entity, 64);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        ItemStack stack = player.func_184614_ca();
        IBlockState state = event.getState();
        Material material = state.func_185904_a();
        Block target = state.func_177230_c();
        float speed = event.getOriginalSpeed();
        float hardness = state.func_185887_b(player.func_130014_f_(), event.getPos());
        if (PlayerHelper.isNetherCapable((EntityLivingBase)player) && stack.func_190926_b() && material == Material.field_151576_e) {
            event.setNewSpeed(speed + hardness * 0.15f);
        }
        if (player.func_184614_ca().func_190926_b() && target instanceof IInflictedDamage && ((IInflictedDamage)target).shouldDamage(world, pos)) {
            player.func_70097_a(((IInflictedDamage)target).getSource(world, pos), ((IInflictedDamage)target).getDamage(world, pos));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        ItemStack stack;
        EntityPlayer player = event.getEntityPlayer();
        IBlockState state = event.getTargetBlock();
        Material material = state.func_185904_a();
        if (PlayerHelper.isNetherCapable((EntityLivingBase)player) && (stack = player.func_184614_ca()).func_190926_b() && !event.canHarvest() && material == Material.field_151576_e) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onVisible(PlayerEvent.Visibility event) {
        EntityPlayer player = event.getEntityPlayer();
        double visibility = event.getVisibilityModifier();
        if (PlayerHelper.isNetherCapable((EntityLivingBase)player) && visibility > (double)0.65f) {
            event.modifyVisibility((double)0.65f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onStepSounds(PlaySoundAtEntityEvent event) {
        ItemStack feet;
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase && !(feet = ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && feet.func_77973_b() instanceof ISoundSuppression && ((ISoundSuppression)feet.func_77973_b()).shouldSuppress(entity.func_130014_f_(), entity.func_180425_c(), (EntityLivingBase)entity, feet)) {
            for (SoundEvent sound : ((ISoundSuppression)feet.func_77973_b()).getSuppressedSounds()) {
                if (sound != event.getSound()) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onArmorSwap(PlayerInteractEvent.RightClickItem event) {
        if (ModConfig.Features.ENABLE_ARMOR_SWAP) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = event.getItemStack().func_77946_l();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmor && !CommonUtils.matchItemList(ModConfig.Compatibility.BLACKLIST_ARMOR_SWAP, stack)) {
                EntityEquipmentSlot slot = ((ItemArmor)stack.func_77973_b()).field_77881_a;
                ItemStack current_stack = player.func_184582_a(slot).func_77946_l();
                player.func_184201_a(slot, stack);
                player.func_184611_a(event.getHand(), current_stack);
                SoundEvent sound = ((ItemArmor)stack.func_77973_b()).func_82812_d().func_185017_b();
                if (sound != null) {
                    event.getWorld().func_184133_a(player, player.func_180425_c(), sound, SoundCategory.BLOCKS, 0.5f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerSleepCheck(SleepingLocationCheckEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        float wake_chance = 0.055f;
        if (world.field_72995_K) {
            return;
        }
        if (PrimalAPI.randomCheck(wake_chance)) {
            if (ModConfig.Survival.DISABLE_PLAYER_NIGHT_SKIP) {
                event.setResult(Event.Result.DENY);
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_74838_a((String)"chat.message.primal.cannot_sleep"), new Object[0]));
                PlayerHelper.setBedLocation(player, event.getSleepingLocation(), false);
            } else if (!world.func_72935_r() && !PlayerHelper.isPlayerListed(world, player, ModEntities.getFakePlayers()) && PlayerHelper.isPlayerActive(world, ModEntities.getFakePlayers()) && ModConfig.Survival.DISABLE_PLAYER_NIGHT_SKIP) {
                event.setResult(Event.Result.DENY);
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_74838_a((String)"chat.message.primal.cannot_sleep_monster"), new Object[0]));
                PlayerHelper.setBedLocation(player, event.getSleepingLocation(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.Survival.DISABLE_PLAYER_SPAWN) {
            event.setCanceled(true);
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_74838_a((String)"chat.message.primal.cannot_set_spawn"), new Object[0]));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerSetSpawn(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        if (world.field_72995_K) {
            return;
        }
        if (event.getResultStatus() == null && world.field_73011_w.canSleepAt(player, pos) == WorldProvider.WorldSleepResult.ALLOW && ModConfig.Survival.ALLOW_DAYTIME_SPAWN && !ModConfig.Survival.DISABLE_PLAYER_SPAWN) {
            PlayerHelper.setBedLocation(player, pos, false);
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Capability Events");
    }
}

