/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.misc.PitFall;
import nmd.primal.core.common.blocks.parts.Drain;
import nmd.primal.core.common.blocks.parts.Slats;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;

@Mod.EventBusSubscriber
public final class LootEvents {
    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onLootingLevel(LootingLevelEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        DamageSource source = event.getDamageSource();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int looting = event.getLootingLevel();
        if (world.field_72995_K) {
            return;
        }
        if (source == DamageHelper.PITFALL && block instanceof PitFall && looting == 0) {
            Block base = ((PitFall)block).getSupportBlock(world, pos).func_177230_c();
            looting = PrimalAPI.Predicates.LOOTING_3_BLOCKS.apply((Object)state) ? (looting += 3) : (PrimalAPI.Predicates.LOOTING_2_BLOCKS.apply((Object)state) || base instanceof BlockHopper || base instanceof Drain || base instanceof Slats ? (looting += 2) : ++looting);
            event.setLootingLevel(looting);
            PrimalAPI.logger(12, "pitfall looting: " + looting);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool main;
        if (event.getName().equals((Object)LootTableList.field_186425_g) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem(PrimalAPI.Items.OPAL, 1, 0, new LootFunction[0], new LootCondition[0], "primal:" + PrimalAPI.Items.OPAL.func_77658_a()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onEntityDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        List drops = event.getDrops();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        boolean pelt_drops = ModConfig.Survival.HARD_LEATHER && !entity.func_70631_g_();
        boolean meat_drops = ModConfig.Survival.DROPS_VANILLA_MEAT;
        boolean lard_drops = ModConfig.Survival.DROPS_EXTRA_ANIMAL_STUFF;
        float rand = PrimalCore.RANDOM.nextFloat();
        Item animal_fat = PrimalAPI.Items.ANIMAL_FAT;
        Item nether_fat = PrimalAPI.Items.ANIMAL_FAT_NETHER;
        if (ModConfig.Monsters.SAFETY_WATER_DROPS && entity instanceof EntityWaterMob && !(attacker instanceof EntityPlayer)) {
            event.setCanceled(true);
            return;
        }
        if (ModConfig.Survival.HARD_LEATHER) {
            CommonUtils.removeDrop(drops, new ItemStack(Items.field_151116_aA));
        }
        if (entity instanceof EntityPig) {
            if (pelt_drops && (double)rand < 0.75) {
                entity.func_145779_a(PrimalAPI.Items.PELT_PIG, 1);
            }
            if (lard_drops) {
                entity.func_145779_a(animal_fat, PrimalCore.RANDOM.nextInt(4));
            }
        } else if (entity instanceof EntityCow) {
            if (pelt_drops && !CompatHelper.isModEntityMatch((Entity)entity, "totemic", ModCompat.TOTEMIC_BUFFALO) && (double)rand < 0.75) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity instanceof EntityMooshroom ? PrimalAPI.Items.PELT_MOOSHROOM : PrimalAPI.Items.PELT_COW));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(5)));
            }
        } else if (entity instanceof EntitySheep) {
            if (pelt_drops && !entity.func_70631_g_() && (double)rand < 0.98) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_SHEEP, 1));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(2)));
            }
        } else if (entity instanceof EntityHorse) {
            if (pelt_drops && (double)rand < 0.95) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_HORSE, 1));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_HORSE : PrimalAPI.Items.MEAT_RAW_HORSE, PrimalCore.RANDOM.nextInt(entity.func_70631_g_() ? 3 : 6)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(6)));
            }
        } else if (entity instanceof EntityZombieHorse) {
            if (pelt_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.HIDE_SPOILED, PrimalCore.RANDOM.nextInt(3)));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.MEAT_ROTTEN_HORSE, PrimalCore.RANDOM.nextInt(3)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(6)));
            }
        } else if (entity instanceof EntityDonkey) {
            if (pelt_drops && (double)rand < 0.85) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_DONKEY, 1));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_HORSE : PrimalAPI.Items.MEAT_RAW_HORSE, PrimalCore.RANDOM.nextInt(entity.func_70631_g_() ? 2 : 4)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(4)));
            }
        } else if (entity instanceof EntityMule) {
            if (pelt_drops && (double)rand < 0.85) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_MULE, 1));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_HORSE : PrimalAPI.Items.MEAT_RAW_HORSE, PrimalCore.RANDOM.nextInt(entity.func_70631_g_() ? 2 : 4)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(4)));
            }
        } else if (entity instanceof EntityLlama) {
            if (pelt_drops && (double)rand < 0.85) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_LLAMA, 1));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_LLAMA : PrimalAPI.Items.MEAT_RAW_LLAMA, world.field_73012_v.nextInt(entity.func_70631_g_() ? 2 : 5)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(4)));
            }
        } else if (entity instanceof EntityWolf) {
            if (pelt_drops && !entity.func_70631_g_() && (double)rand < 0.75) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.ASH_WOLF : PrimalAPI.Items.PELT_DOG, 1));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_WOLF : PrimalAPI.Items.MEAT_RAW_WOLF, PrimalCore.RANDOM.nextInt(entity.func_70631_g_() ? 1 : 4)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(5)));
            }
        } else if (entity instanceof EntityPolarBear) {
            if (pelt_drops && !entity.func_70631_g_() && (double)rand < 0.9) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PELT_BEAR_POLAR, 1));
            }
            if (meat_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_BEAR : PrimalAPI.Items.MEAT_RAW_BEAR, PrimalCore.RANDOM.nextInt(entity.func_70631_g_() ? 2 : 6)));
            }
            if (lard_drops) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(animal_fat, PrimalCore.RANDOM.nextInt(8)));
            }
        } else if (entity instanceof EntityPigZombie) {
            if (pelt_drops && !entity.func_70631_g_() && (double)rand < 0.9) {
                CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(PrimalAPI.Items.PIGMAN_HIDE_RAW, 1));
            }
            if (meat_drops && (double)rand < 0.9) {
                entity.func_145779_a(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_PIGMAN : PrimalAPI.Items.MEAT_RAW_PIGMAN, PrimalCore.RANDOM.nextInt(entity.func_70631_g_() ? 1 : 3));
            }
            if (lard_drops) {
                entity.func_145779_a(nether_fat, PrimalCore.RANDOM.nextInt(4));
            }
        } else if (entity instanceof EntityBat && meat_drops && (double)rand < 0.9) {
            entity.func_145779_a(entity.func_70027_ad() ? PrimalAPI.Items.MEAT_COOKED_BAT : PrimalAPI.Items.MEAT_RAW_BAT, 1);
        }
        if (entity instanceof EntityLiving && world.field_73011_w.func_186058_p() == DimensionType.NETHER && (double)PrimalCore.RANDOM.nextFloat() < 0.05) {
            ItemStack drop = CommonUtils.getRandomStack(1, PrimalAPI.Items.VALUS_SEED, PrimalAPI.Items.CORYPHA_SEED, PrimalAPI.Items.DAUCUS_MURN_SEEDS, PrimalAPI.Items.SINUOUS_SPORE, PrimalAPI.Items.CINERIS_SEED);
            CommonUtils.addDrop((EntityLiving)entity, drops, drop);
        }
        if (entity instanceof EntityAnimal && !entity.func_70631_g_() && PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_BONES)) {
            CommonUtils.addDrop((EntityLiving)entity, drops, new ItemStack(Items.field_151103_aS, 1));
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Loot Events");
    }
}

