/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.FlakeEvent;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.ISpecialHarvest;
import nmd.primal.core.api.interfaces.ITorch;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractTank;
import nmd.primal.core.common.blocks.lighting.Lantern;
import nmd.primal.core.common.blocks.ores.AncientIce;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.blocks.plants.invasive.Aconite;
import nmd.primal.core.common.blocks.plants.wood.TreeLeaves;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModFluids;
import nmd.primal.core.common.recipes.inworld.AxeRecipe;
import nmd.primal.core.common.recipes.inworld.FireSource;
import nmd.primal.core.common.recipes.inworld.FlakeRecipe;
import nmd.primal.core.common.recipes.inworld.GallagherRecipe;
import nmd.primal.core.common.recipes.inworld.HoeRecipe;
import nmd.primal.core.common.recipes.inworld.RockDrops;
import nmd.primal.core.common.recipes.inworld.ShovelRecipe;
import nmd.primal.core.common.tiles.AbstractTileTank;

@Mod.EventBusSubscriber
public final class BlockEvents {
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onBlockPlacement(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        IBlockState state = event.getPlacedBlock();
        BlockPos pos = event.getPos();
        Block block = state.func_177230_c();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.Lighting.JACK_REPLACE_VANILLA && block == Blocks.field_150428_aP) {
            world.func_180501_a(pos, PrimalAPI.Blocks.JACK_O_LANTERN.func_176223_P().func_177226_a((IProperty)IFace.FACING, state.func_177229_b((IProperty)IFace.FACING)).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (block instanceof ISchedule && ((ISchedule)block).shouldScheduleOnPlacement()) {
            PrimalAPI.logger(5, "schedule on placement");
            ((ISchedule)block).scheduleUpdate(world, pos, state);
        }
        if (event.getPlayer().func_184812_l_() && block instanceof AbstractPlantGrowing) {
            ((AbstractPlantGrowing)block).growFullPlant(world, pos, state, 2);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=false)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        EntityPlayer player = event.getPlayer();
        boolean shears = RecipeHelper.isShears(player.func_184614_ca());
        if (world.field_72995_K) {
            return;
        }
        if (shears && (block instanceof BlockTallGrass || block instanceof BlockDoublePlant && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS)) {
            if (Blocks.field_150329_H.canSustainPlant(world.func_180495_p(event.getPos().func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150329_H) && PrimalAPI.placeScheduledBlock(world, pos, PrimalAPI.Blocks.TALL_GRASS.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(0)), 2)) {
                event.setCanceled(true);
                PlayerHelper.spawnItemOnGround(world, pos, new ItemStack((Block)Blocks.field_150329_H, 1, BlockTallGrass.EnumType.GRASS.func_177044_a()));
            }
        } else if (block instanceof IPerennial && (ModConfig.Plants.PERENNIAL_PLANTS_ROOT || shears)) {
            if (shears && block instanceof IShearable) {
                PlayerHelper.spawnItemOnGround(world, pos, ((IShearable)block).onSheared(block.func_185473_a(world, pos, state), (IBlockAccess)world, pos, 0));
            } else {
                block.func_180653_a(world, pos, state, 0.0f, 0);
            }
            if (((IPerennial)block).growNewPlant(world, pos, state)) {
                event.setCanceled(true);
            }
        } else if (above instanceof Aconite && ((Aconite)above).isValidSoil((IBlockAccess)world, pos)) {
            PlayerHelper.spawnItemOnGround(world, pos, new ItemStack(PrimalAPI.Items.ACONITE_ROOT));
        }
        if (ModConfig.Survival.HARD_BLOCKS_HARDNESS < (double)state.func_185887_b(world, pos) && player.func_184614_ca().func_190926_b() && !block.func_176200_f((IBlockAccess)world, pos) && !state.func_185904_a().func_76222_j() && !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            player.func_70097_a((DamageSource)DamageHelper.BLOCK, state.func_185887_b(world, pos) * (float)ModConfig.Survival.HARD_BLOCKS_MODIFIER);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=false)
    public static void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        RockDrops recipe;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null) {
            return;
        }
        if (event.isSilkTouching()) {
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        Material material = state.func_177230_c().func_149688_o(state);
        ItemStack held_stack = player.func_184614_ca();
        int fortune = event.getFortuneLevel();
        if (!PlayerHelper.isFakePlayer(player) && !CompatHelper.isMonk((EntityLivingBase)player) && RecipeHelper.isOreName(block, PrimalAPI.Predicates.LOG_HARVEST_NAMES)) {
            PrimalAPI.logger(19, "harvest block", "type: " + block.func_149739_a() + ", " + RecipeHelper.isOreName(block, "logWood") + ", " + RecipeHelper.isOreName(block, "blockHarvest"));
            if (held_stack.func_190926_b() || !RecipeHelper.isToolEffective(held_stack, state)) {
                PrimalAPI.logger(19, "harvest block", "event triggered: " + block.getHarvestTool(state) + ", " + block.getHarvestLevel(state));
                event.getDrops().clear();
                if (ModConfig.Survival.HARD_BLOCKS_HARDNESS < (double)state.func_185887_b(world, pos) && player.func_184614_ca().func_190926_b()) {
                    player.func_70097_a((DamageSource)DamageHelper.BLOCK, state.func_185887_b(world, pos) * (float)ModConfig.Survival.HARD_BLOCKS_MODIFIER);
                }
            }
        } else if (!(held_stack.func_77973_b() instanceof ISpecialHarvest && ((ISpecialHarvest)held_stack.func_77973_b()).canSpecialHarvest(held_stack) || !RecipeHelper.isOreName(held_stack, "toolMalletStone", "toolMalletMetal", "toolForgeHammer"))) {
            for (GallagherRecipe recipe2 : GallagherRecipe.RECIPES) {
                ItemStack ancient_ice_loot;
                float ice_loot_modifier;
                if (!recipe2.match(state)) continue;
                int tool_level = held_stack.func_77973_b().getHarvestLevel(held_stack, "gallagher", player, state);
                int block_level = block.getHarvestLevel(state);
                ItemStack output = ItemStack.field_190927_a;
                if (!recipe2.getOutputStack().func_190926_b() && recipe2.getOutputAmount() > 0) {
                    output = recipe2.getOutputStack();
                    output.func_190920_e(recipe2.getOutputAmount());
                }
                event.getDrops().clear();
                if (tool_level >= block_level - 1) {
                    event.getDrops().add(output);
                }
                if (recipe2.getOutputState().func_177230_c() != Blocks.field_150350_a) {
                    world.func_180501_a(pos, recipe2.getOutputState(), 2);
                }
                float f = ice_loot_modifier = fortune > 0 ? (float)fortune * 0.025f + 0.025f : 0.025f;
                if (state.func_177230_c() != PrimalAPI.Blocks.ANCIENT_ICE || !PrimalAPI.randomCheck(ice_loot_modifier) || (ancient_ice_loot = AncientIce.getLootDrop(world)).func_190926_b()) continue;
                event.getDrops().add(ancient_ice_loot);
            }
        } else if ((material == Material.field_151584_j || block == Blocks.field_150330_I) && ModConfig.Survival.DROPS_STICK_FROM_LEAF) {
            Item stick = block instanceof TreeLeaves ? ((TreeLeaves)block).getStick(state) : Items.field_151055_y;
            int count = PrimalCore.RANDOM.nextInt(2);
            if (stick != Items.field_151055_y && PrimalAPI.randomCheck(3)) {
                --count;
            }
            if (count > 0) {
                event.getDrops().add(new ItemStack(stick, count));
            }
        } else if (block instanceof BlockTallGrass) {
            if (PrimalAPI.randomCheck(ModConfig.Survival.DROPS_PLANT_FIBERS)) {
                PlayerHelper.spawnItemOnGround(world, pos, new ItemStack(PrimalAPI.Items.PLANT_FIBER, PrimalAPI.randomCheck(8) ? 2 : 1));
            }
            if (ModConfig.Plants.TALL_GRASS_GROWTH && Blocks.field_150329_H.canSustainPlant(world.func_180495_p(event.getPos().func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150329_H)) {
                PrimalAPI.placeScheduledBlock(world, pos, PrimalAPI.Blocks.TALL_GRASS.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(0)), 2);
            }
        } else if (block instanceof BlockVine || block instanceof BlockDoublePlant) {
            if (PrimalAPI.randomCheck(ModConfig.Survival.DROPS_PLANT_FIBERS)) {
                PlayerHelper.spawnItemOnGround(world, pos, new ItemStack(PrimalAPI.Items.PLANT_FIBER, PrimalAPI.randomCheck(8) ? 2 : 1));
            }
        } else if (block instanceof BlockGrass || block instanceof BlockGrassPath) {
            if (PrimalAPI.randomCheck(ModConfig.Survival.DROPS_PLANT_FIBERS)) {
                PlayerHelper.spawnItemOnGround(world, pos, new ItemStack(PrimalAPI.Items.PLANT_FIBER, PrimalAPI.randomCheck(16) ? 2 : 1));
            }
            if (!ModConfig.Features.DISABLE_FLINT_DROPS && PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_FLINT)) {
                event.getDrops().clear();
                event.getDrops().add(new ItemStack(Items.field_151145_ak, 1 + PrimalCore.RANDOM.nextInt(1)));
            }
        } else if (block instanceof BlockDirt || block instanceof BlockSand) {
            boolean flint;
            boolean rock = PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_ROCKS);
            boolean bl = flint = !ModConfig.Features.DISABLE_FLINT_DROPS && PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_FLINT);
            if (rock || flint) {
                event.getDrops().clear();
                if (rock) {
                    event.getDrops().add(new ItemStack(PrimalAPI.Items.ROCK_STONE, 1 + PrimalCore.RANDOM.nextInt(1)));
                }
                if (flint) {
                    event.getDrops().add(new ItemStack(Items.field_151145_ak, 1 + PrimalCore.RANDOM.nextInt(1)));
                }
            }
        } else if (block == PrimalAPI.Blocks.NETHER_EARTH || block == PrimalAPI.Blocks.NETHER_PATH || block instanceof BlockSoulSand) {
            boolean bones = PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_NETHER);
            boolean flint = PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_NETHER);
            if (bones || flint) {
                event.getDrops().clear();
                if (bones) {
                    event.getDrops().add(new ItemStack(Items.field_151103_aS, 1));
                }
                if (flint) {
                    event.getDrops().add(new ItemStack(Items.field_151128_bU, 1 + PrimalCore.RANDOM.nextInt(1)));
                }
            }
        } else if (block instanceof BlockFarmland && ModConfig.Features.ENABLE_MUD_HARVEST_FARMLAND) {
            int moisture = (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a);
            if (moisture > 0) {
                event.getDrops().clear();
                event.getDrops().add(new ItemStack(PrimalAPI.Items.MUD_CLUMP, PrimalCore.RANDOM.nextInt(3, moisture + 3)));
                if (!ModConfig.Features.DISABLE_FLINT_DROPS && PrimalAPI.randomCheckFail(ModConfig.Survival.DROPS_EXTRA_FLINT)) {
                    event.getDrops().add(new ItemStack(Items.field_151145_ak, 1 + PrimalCore.RANDOM.nextInt(1)));
                }
            }
        } else if (block instanceof BlockMagma && PrimalAPI.randomCheck(ModConfig.Fluids.MAGMA_HARVEST_CHANCE)) {
            event.getDrops().clear();
            RecipeHelper.changeBlock(world, pos, PrimalAPI.Fluids.MAGMA.getBlock().func_176223_P(), 16);
        } else if (ModConfig.Survival.DROPS_ROCKS_FROM_STONE && !held_stack.func_190926_b() && RockDrops.isRecipeItem(state) && (recipe = RockDrops.getRecipe(state)) != null) {
            int tool_level = held_stack.func_77973_b().getHarvestLevel(held_stack, "pickaxe", player, state);
            ItemStack output = recipe.getOutput();
            output.func_190920_e(PrimalCore.RANDOM.nextInt(1, 5 + tool_level));
            event.getDrops().clear();
            if (tool_level >= 0) {
                event.getDrops().add(output);
            }
        }
        if (ModConfig.Features.DISABLE_FLINT_DROPS) {
            if (event.getDrops().isEmpty() || event.getDrops() == null) {
                return;
            }
            for (int i = 0; i < event.getDrops().size(); ++i) {
                if (!((ItemStack)event.getDrops().get(i)).func_77969_a(new ItemStack(Items.field_151145_ak))) continue;
                event.getDrops().remove(event.getDrops().get(i));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=false)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        EnumFacing face = event.getFace();
        EntityPlayer player = event.getEntityPlayer();
        EnumHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (ModConfig.Survival.DISABLE_VANILLA_FURNACE && PrimalAPI.Predicates.FURNACE.apply((Object)state)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + I18n.func_74838_a((String)"chat.message.primal.disabled_block"), new Object[0]));
            event.setCanceled(true);
        } else if (hand == EnumHand.MAIN_HAND) {
            AbstractTileTank tile;
            if (block instanceof IPickup && player.func_70093_af() && ((IPickup)block).canPickup(world, pos, state, player) && ((IPickup)block).canPickupItem(stack) && ((IPickup)block).doPickup(world, pos, state, face, player, hand)) {
                player.func_184609_a(hand);
                event.setCanceled(true);
            } else if (block instanceof ILit && ((ILit)block).canInteract(world, pos, state, face, (EntityLivingBase)player)) {
                if (((ILit)block).isLit((IBlockAccess)world, pos, state)) {
                    if (item instanceof ITorch && ((ITorch)item).liteTorch(player)) {
                        player.func_184609_a(hand);
                        event.setCanceled(true);
                    } else if (((ILit)block).canExtinguish(world, pos, state, face, (EntityLivingBase)player)) {
                        ((ILit)block).doExtinguish(world, pos, state, face, (EntityLivingBase)player);
                        player.func_184609_a(hand);
                        event.setCanceled(true);
                    }
                } else if (FireSource.useSource(world, pos, face, player, hand, stack, (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c) && ((ILit)block).canLite(world, pos, state, face, (EntityLivingBase)player)) {
                    ((ILit)block).doLite(world, pos, state, face, (EntityLivingBase)player);
                    player.func_184609_a(hand);
                    event.setCanceled(true);
                    if (!world.field_72995_K) {
                        IBlockState updated_state = world.func_180495_p(pos);
                        if (block instanceof ISchedule) {
                            ((ISchedule)block).scheduleUpdate(world, pos, updated_state);
                        }
                    }
                }
                if (block instanceof Lantern) {
                    ((Lantern)block).addTorch(world, pos, state, player, hand, stack);
                    player.func_184609_a(hand);
                    event.setCanceled(true);
                }
            } else if (FireHelper.isFireSource((IBlockAccess)world, pos, state) && item instanceof ITorch && ((ITorch)item).liteTorch(player)) {
                player.func_184609_a(hand);
                event.setCanceled(true);
            }
            if (ModConfig.Features.ENABLE_AXE_RECIPES && RecipeHelper.isAxe(stack)) {
                for (AxeRecipe recipe : AxeRecipe.RECIPES) {
                    if (!recipe.match(state)) continue;
                    IBlockState recipe_state = recipe.hasFacing() ? recipe.getOutputState().func_177226_a((IProperty)IFace.FACING, (Comparable)player.func_174811_aO()) : recipe.getOutputState();
                    int harvest_level = stack.func_77973_b().getHarvestLevel(stack, "axe", player, state);
                    int modifier = harvest_level > 1 ? 6 - harvest_level : 6;
                    player.func_184609_a(event.getHand());
                    world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, recipe.getSound(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    if (PrimalAPI.randomCheck(3)) {
                        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                    }
                    if (!PrimalAPI.randomCheck(modifier)) continue;
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    RecipeHelper.craftBlock(world, pos, player, ItemStack.field_190927_a, recipe_state, recipe.getOutputStack());
                }
            } else if (RecipeHelper.isShovel(stack)) {
                if (state.func_177230_c() == Blocks.field_150349_c) {
                    IBlockState plant = world.func_180495_p(pos.func_177984_a());
                    if (plant.func_177230_c() instanceof IPlantable) {
                        RecipeHelper.craftBlock(world, pos, player, ItemStack.field_190927_a, Blocks.field_185774_da.func_176223_P(), ItemStack.field_190927_a);
                        world.func_190524_a(pos.func_177984_a(), plant.func_177230_c(), pos);
                        world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        player.func_184609_a(event.getHand());
                        PlayerHelper.applyBlockStat(player, Blocks.field_185774_da, 0.003f);
                        event.setResult(Event.Result.DEFAULT);
                    }
                } else if (ModConfig.Features.ENABLE_SHOVEL_RECIPES) {
                    for (ShovelRecipe recipe : ShovelRecipe.RECIPES) {
                        if (!recipe.match(state)) continue;
                        IBlockState recipe_state = recipe.hasFacing() ? recipe.getOutputState().func_177226_a((IProperty)IFace.FACING, (Comparable)player.func_174811_aO()) : recipe.getOutputState();
                        RecipeHelper.craftBlock(world, pos, player, ItemStack.field_190927_a, recipe_state, recipe.getOutputStack());
                        world.func_190524_a(pos.func_177984_a(), state.func_177230_c(), pos);
                        world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, recipe.getSound(), SoundCategory.PLAYERS, 0.5f, 1.0f);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        player.func_184609_a(event.getHand());
                        PlayerHelper.applyBlockStat(player, recipe_state.func_177230_c(), 0.003f);
                        event.setResult(Event.Result.DEFAULT);
                    }
                }
            } else if (player.func_70093_af() && ModConfig.Features.ENABLE_LEVER_PICKUP && block == Blocks.field_150442_at && IPickup.doStrangePickup(world, pos, player, hand, face, new ItemStack(Blocks.field_150442_at))) {
                event.setCanceled(true);
            } else if (block instanceof AbstractTank && (tile = (AbstractTileTank)world.func_175625_s(pos)) != null && !tile.func_145837_r() && !((AbstractTank)block).isCovered((IBlockAccess)world, pos, state)) {
                if (item instanceof ITorch && ((ITorch)item).isTorchLit(stack)) {
                    Material material;
                    FluidStack fluidStack = tile.getContainedFluid();
                    if (fluidStack != null && fluidStack.amount >= 250 && (material = fluidStack.getFluid().getBlock().func_176223_P().func_185904_a()) == Material.field_151586_h && ((ITorch)item).douseTorch(player)) {
                        player.func_184609_a(hand);
                        event.setCanceled(true);
                    }
                } else if (player.func_70093_af() && ModFluids.isSponge(stack)) {
                    tile.getTank().drain(1000, true);
                    AbstractTank.playSoundEmpty(world, player.func_180425_c(), stack);
                    player.func_184609_a(hand);
                    event.setCanceled(true);
                }
            }
        } else if (hand == EnumHand.OFF_HAND && block instanceof IPickup) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        IBlockState state = world.func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.Features.ENABLE_FLAKING_RECIPES && !block.hasTileEntity(state) && FlakeRecipe.MATERIALS.apply((Object)state)) {
            ItemStack stack = event.getEntityPlayer().func_184614_ca();
            for (FlakeRecipe recipe : FlakeRecipe.RECIPES) {
                if (!recipe.match(stack)) continue;
                event.setCanceled(true);
                BlockPos pos = event.getPos();
                float blockHardness = block.func_176195_g(state, world, pos);
                if (!(blockHardness >= recipe.getBlock_hardness()) && !(blockHardness < -0.0f) || player.field_82175_bq) continue;
                player.func_184609_a(EnumHand.MAIN_HAND);
                world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_CRAFT_FLAKE, SoundCategory.PLAYERS, 1.8f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                if (!PrimalAPI.randomCheck(recipe.getFlakeDifficulty())) continue;
                FlakeEvent flake = new FlakeEvent(recipe, player, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)flake)) {
                    return;
                }
                for (ItemStack output : recipe.getOutput()) {
                    if (!PrimalAPI.randomCheck(recipe.getFailureChance())) continue;
                    output.func_190920_e(PrimalCore.RANDOM.nextInt(1, output.func_190916_E() + 1));
                    BlockPos output_pos = event.getFace() != null ? pos.func_177972_a(event.getFace()) : pos;
                    PlayerHelper.spawnItemOnGround(world, output_pos, output);
                }
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                PlayerHelper.applyBlockStat(player, block, 0.002f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onTillEarth(UseHoeEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        if (state.func_177230_c() == Blocks.field_150349_c) {
            IBlockState plant = world.func_180495_p(pos.func_177984_a());
            if (plant.func_177230_c() instanceof IPlantable) {
                RecipeHelper.craftBlock(world, pos, player, ItemStack.field_190927_a, Blocks.field_150458_ak.func_176223_P(), ItemStack.field_190927_a);
                world.func_190524_a(pos.func_177984_a(), plant.func_177230_c(), pos);
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(EnumHand.MAIN_HAND);
                PlayerHelper.applyBlockStat(player, Blocks.field_150458_ak, 0.003f);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (ModConfig.Features.ENABLE_HOE_RECIPES) {
            for (HoeRecipe recipe : HoeRecipe.RECIPES) {
                if (!recipe.match(state)) continue;
                IBlockState recipe_state = recipe.hasFacing() ? recipe.getOutputState().func_177226_a((IProperty)IFace.FACING, (Comparable)player.func_174811_aO()) : recipe.getOutputState();
                RecipeHelper.craftBlock(world, pos, player, ItemStack.field_190927_a, recipe_state, recipe.getOutputStack());
                world.func_190524_a(pos.func_177984_a(), state.func_177230_c(), pos);
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, recipe.getSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                PlayerHelper.applyBlockStat(player, recipe_state.func_177230_c(), 0.003f);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=false)
    public static void onBonemeal(BonemealEvent event) {
        if (ModConfig.Survival.DISABLE_BONE_MEAL) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Block Events");
    }
}

