/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.living;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

public class EntityNetherCreeper
extends EntityCreeper {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public EntityNetherCreeper(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.7f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOvisAtre.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ModConfig.Monsters.NETHER_CREEPER_STATS[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModConfig.Monsters.NETHER_CREEPER_STATS[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ModConfig.Monsters.NETHER_CREEPER_STATS[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(ModConfig.Monsters.NETHER_CREEPER_STATS[3]);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public static void registerFixesCreeper(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityCreeper.class);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.func_146078_ca());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_146078_ca()) {
                this.func_70829_a(1);
            }
            if ((i = this.func_70832_p()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                FireHelper.explode(this.field_70170_p, this.func_180425_c(), (Entity)this, this.explosionRadius, this.func_70830_n() ? 2.0f : 1.0f, true, true);
            }
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            if (cause.func_76346_g() instanceof EntitySkeleton) {
                int i = Item.func_150891_b((Item)Items.field_151096_cd);
                int j = Item.func_150891_b((Item)Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d((int)k), 1);
            } else if (cause.func_76346_g() instanceof EntityCreeper && cause.func_76346_g() != this && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && ((EntityCreeper)cause.func_76346_g()).func_70650_aV()) {
                ((EntityCreeper)cause.func_76346_g()).func_175493_co();
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public boolean func_70830_n() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70831_j(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLoot.ENTITIES_NETHER_CREEPER;
    }

    public int func_70832_p() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void func_70829_a(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.func_70830_n() ? 2.0f : 1.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, true, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(2.5f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            for (PotionEffect potioneffect : collection) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public boolean func_146078_ca() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void func_146079_cb() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public boolean func_70650_aV() {
        return this.droppedSkulls < 1 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    public void func_175493_co() {
        ++this.droppedSkulls;
    }

    public int func_70641_bl() {
        return 3;
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return block != PrimalAPI.Blocks.NETHER_FARMLAND && super.canTrample(world, block, pos, fallDistance);
    }
}

