/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.living;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.entities.ai.AIWaterMob;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;

public class EntityHammerHead
extends AIWaterMob
implements IMob {
    public EntityHammerHead(World world) {
        super(world);
        this.func_70105_a(1.8f, 0.4f);
        this.isTargeting = true;
        this.landBounce = true;
        this.swimRadius = (float)ModConfig.Monsters.SHARKS_STATS[2];
        this.swimSpeed = (float)ModConfig.Monsters.SHARKS_STATS[3];
        this.verticalSpeed = ModConfig.Monsters.SHARKS_STATS[4];
        this.attackInterval = 23;
        this.moreDamage = 3.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModConfig.Monsters.SHARKS_STATS[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ModConfig.Monsters.SHARKS_STATS[1]);
    }

    @Override
    protected EntityLivingBase findPrey() {
        if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            EntityLivingBase entity = super.findPreyLiving(32.0, 16.0, 32.0);
            if (entity != null && this.canAttackEntity(entity)) {
                return entity;
            }
            EntityPlayer player = (EntityPlayer)super.findPreyPlayer(ModConfig.Monsters.SHARKS_TARGET_RANGE);
            if (player != null) {
                return player;
            }
        }
        return null;
    }

    @Override
    protected boolean canAttackEntity(EntityLivingBase target) {
        if (target.func_82150_aj()) {
            return false;
        }
        if (target instanceof EntityHammerHead) {
            return false;
        }
        if (target.func_70090_H() || ModConfig.Monsters.SHARKS_ATTACK_BOATS && PlayerHelper.isRidingBoat(target) && !PlayerHelper.isMoving(target, 0.01f)) {
            if (target instanceof EntityWaterMob) {
                return ModConfig.Monsters.SHARKS_ATTACK_WATER_MOBS;
            }
            if (target instanceof EntityGuardian) {
                return ModConfig.Monsters.SHARKS_ATTACK_GUARDIANS;
            }
            return true;
        }
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return ModLoot.ENTITIES_HAMMERHEAD;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 30.0 && this.field_70163_u < (double)this.func_130014_f_().func_181545_F() && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

