/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.living;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.entities.ai.AILeapAtTargetInWater;
import nmd.primal.core.common.entities.living.EntityNetherCreeper;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.init.ModConfig;

public class EntityGator
extends EntityAnimal
implements IMob {
    public EntityGator(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.5f);
        this.func_184644_a(PathNodeType.WATER, 0.5f);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.5f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILeapAtTargetInWater((EntityLiving)this, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIHurtByTarget());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityNetherCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOvisAtre.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityGolem.class, 6.0f, 1.0, 1.2));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 10, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 20, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 30, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 60, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(5, new AISpecialTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70619_bc() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ModConfig.Monsters.ALLIGATOR_STATS[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModConfig.Monsters.ALLIGATOR_STATS[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ModConfig.Monsters.ALLIGATOR_STATS[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ModConfig.Monsters.ALLIGATOR_STATS[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(ModConfig.Monsters.ALLIGATOR_STATS[4]);
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        if (entity instanceof EntityLivingBase) {
            // empty if block
        }
        System.out.println("PotionEffect");
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    public boolean func_70686_a(Class attack) {
        return EntityGator.class != attack;
    }

    public void func_70636_d() {
        if (this.func_70090_H()) {
            this.field_70159_w *= 1.125;
            this.field_70179_y *= 1.125;
        }
        super.func_70636_d();
    }

    protected ResourceLocation func_184647_J() {
        return ModLoot.ENTITIES_GATOR;
    }

    public boolean func_70601_bi() {
        if (this.func_130014_f_().field_73011_w.getDimension() != 0) {
            return false;
        }
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), y, MathHelper.func_76128_c((double)this.field_70161_v));
        Block ground = this.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c();
        return (ground == Blocks.field_150346_d || ground == Blocks.field_150349_c || ground == Blocks.field_150354_m || ground == Blocks.field_150351_n || ground == Blocks.field_150355_j) && y < 75 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 4;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityGator createChild(EntityAgeable p_90011_1_) {
        return new EntityGator(this.func_130014_f_());
    }

    protected SoundEvent func_184639_G() {
        return PrimalAPI.Sounds.SOUND_ENTITY_GATOR_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return PrimalAPI.Sounds.SOUND_ENTITY_GATOR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return PrimalAPI.Sounds.SOUND_ENTITY_GATOR_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    static class AISpecialTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpecialTarget(EntityGator gator, Class<T> classTarget) {
            super((EntityCreature)gator, classTarget, true);
        }

        public boolean func_75250_a() {
            World world = this.field_75299_d.func_130014_f_();
            if (world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                float attack_weight = 0.15f;
                float attack_range = 5.0f;
                if (this.field_75309_a != null && !(this.field_75299_d.func_70013_c() >= 0.5f)) {
                    return PrimalAPI.randomCheck(attack_weight) && super.func_75250_a();
                }
                List list = world.func_175647_a(this.field_75307_b, this.func_188511_a(attack_range), this.field_82643_g);
                if (!list.isEmpty()) {
                    list.sort(this.field_75306_g);
                    this.field_75309_a = (EntityLivingBase)list.get(0);
                    return PrimalAPI.randomCheck(attack_weight);
                }
            }
            return false;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityGator.this, false, new Class[0]);
        }

        public void func_75249_e() {
            if (EntityGator.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                super.func_75249_e();
                this.func_190105_f();
            }
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn != null && creatureIn instanceof EntityGator && !((EntityGator)creatureIn).func_70631_g_()) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }
    }
}

