/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.ai;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.PlayerHelper;

public class AIWaterMob
extends EntityWaterMob
implements IAnimals {
    protected int attackInterval = 50;
    protected float attackSpeed = 1.2f;
    protected float swimSpeed = 0.5f;
    private double targetX;
    private double targetY;
    private double targetZ;
    private EntityLivingBase targetedEntity;
    private boolean isAttacking;
    protected float swimRadius = 4.0f;
    protected float swimRadiusHeight = 4.0f;
    protected boolean isTargeting = false;
    protected boolean landBounce = true;
    protected float moreDamage = 0.5f;
    protected double verticalSpeed = 0.1;

    public AIWaterMob(World world) {
        super(world);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70090_H() {
        return this.func_130014_f_().func_72918_a(this.func_174813_aQ().func_191195_a(0.25, 0.1, 0.25), Material.field_151586_h, (Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.field_70181_x *= this.verticalSpeed;
        }
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.isTargeting && this.targetedEntity == entity) {
            this.func_70652_k(entity);
        }
    }

    protected boolean canAttackEntity(EntityLivingBase target) {
        return target.func_70090_H();
    }

    protected EntityLivingBase findPrey() {
        EntityPlayer player = this.func_130014_f_().func_184136_b((Entity)this, 16.0);
        return player != null && this.func_70685_l((Entity)player) ? player : null;
    }

    protected EntityLivingBase findPreyPlayer(double distance) {
        EntityPlayer player = this.func_130014_f_().func_184136_b((Entity)this, distance);
        return player != null && this.func_70685_l((Entity)player) ? player : null;
    }

    protected EntityLivingBase findPreyLiving(double x, double y, double z) {
        AxisAlignedBB area = this.func_174813_aQ().func_72321_a(x, y, z);
        EntityLivingBase entity = (EntityLivingBase)this.func_130014_f_().func_72857_a(EntityLivingBase.class, area, (Entity)this);
        return entity != null && this.func_70685_l((Entity)entity) ? entity : null;
    }

    protected EntityBoat findPreyBoat(double x, double y, double z) {
        AxisAlignedBB area = this.func_174813_aQ().func_72321_a(x, y, z);
        EntityBoat entity = (EntityBoat)this.func_130014_f_().func_72857_a(EntityBoat.class, area, (Entity)this);
        return entity != null && this.func_70685_l((Entity)entity) ? entity : null;
    }

    public boolean func_70652_k(Entity entity) {
        float baseDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entity instanceof EntityLivingBase && PlayerHelper.isRidingBoat((EntityLivingBase)entity)) {
            return entity.func_184187_bx() != null && entity.func_184187_bx().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.5f + (float)PrimalAPI.getRandom().nextDouble(3.0));
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), baseDamage + this.moreDamage);
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70026_G()) {
            this.func_70050_g(--air);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70090_H()) {
            double dz;
            double dy;
            double dx;
            double dist;
            if (this.targetedEntity != null && !this.canAttackEntity(this.targetedEntity)) {
                this.isAttacking = false;
                this.targetedEntity = null;
            }
            if ((dist = (double)MathHelper.func_76133_a((double)((dx = this.targetX - this.field_70165_t) * dx + (dy = this.targetY - this.field_70163_u) * dy + (dz = this.targetZ - this.field_70161_v) * dz))) < 1.0 || dist > 1000.0) {
                this.targetX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadius);
                this.targetY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadiusHeight);
                this.targetZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadius);
                this.isAttacking = false;
            }
            BlockPos target_pos = new BlockPos(MathHelper.func_76128_c((double)this.targetX), MathHelper.func_76128_c((double)(this.targetY + (double)this.field_70131_O)), MathHelper.func_76128_c((double)this.targetZ));
            if (this.func_130014_f_().func_180495_p(target_pos).func_185904_a() == Material.field_151586_h) {
                this.field_70159_w += dx / dist * 0.05 * (double)this.swimSpeed;
                this.field_70181_x += dy / dist * 0.15 * (double)this.swimSpeed;
                this.field_70179_y += dz / dist * 0.05 * (double)this.swimSpeed;
            } else {
                this.targetX = this.field_70165_t;
                this.targetY = this.field_70163_u + 0.15;
                this.targetZ = this.field_70161_v;
            }
            if (this.isAttacking) {
                this.field_70159_w *= (double)this.attackSpeed;
                this.field_70181_x *= (double)this.attackSpeed;
                this.field_70179_y *= (double)this.attackSpeed;
            }
            if (this.isTargeting && this.field_70146_Z.nextInt(this.attackInterval) == 0) {
                this.targetedEntity = this.findPrey();
                if (this.targetedEntity != null) {
                    if (this.canAttackEntity(this.targetedEntity)) {
                        this.targetX = this.targetedEntity.field_70165_t;
                        this.targetY = this.targetedEntity.field_70163_u;
                        this.targetZ = this.targetedEntity.field_70161_v;
                        this.isAttacking = true;
                    } else {
                        this.isAttacking = false;
                        this.targetedEntity = null;
                    }
                }
            }
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / 3.141593f - this.field_70761_aq) * 0.5f;
            this.field_70177_z = this.field_70761_aq;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70125_A += ((float)Math.atan2(this.field_70181_x, f) * 180.0f / 3.141593f - this.field_70125_A) * 0.5f;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x -= 0.08;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y = 0.0;
            if (this.landBounce && this.field_70122_E && this.field_70146_Z.nextInt(30) == 0) {
                this.field_70181_x = 0.300000011920929;
                this.field_70159_w = -0.4f + this.field_70146_Z.nextFloat() * 0.8f;
                this.field_70179_y = -0.4f + this.field_70146_Z.nextFloat() * 0.8f;
            }
        }
    }
}

