/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.ai;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class AIEatPrimalGrass
extends EntityAIBase {
    public static final Predicate<IBlockState> IS_BEST_GRASS = BlockMultiplexer.forBlock(PrimalAPI.Blocks.CINERIS_GRASS, PrimalAPI.Blocks.INANIS_GRASS, PrimalAPI.Blocks.DRY_GRASS);
    public static final Predicate<IBlockState> IS_HOST_BLOCK = BlockMultiplexer.forBlock(Blocks.field_150424_aL, Blocks.field_150385_bj, Blocks.field_150377_bs, Blocks.field_185772_cY, PrimalAPI.Blocks.DESICCATED_STONE, PrimalAPI.Blocks.NETHER_EARTH, PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NETHER_MYCELIUM);
    private final EntityLiving entity;
    private final World world;
    private int eatingGrassTimer;

    public AIEatPrimalGrass(EntityLiving grassEaterEntityIn) {
        this.entity = grassEaterEntityIn;
        this.world = grassEaterEntityIn.func_130014_f_();
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70681_au().nextInt(this.entity.func_70631_g_() ? 90 : ModConfig.Monsters.OVIS_ATRE_GRAZE_CHANCE) != 0) {
            return false;
        }
        BlockPos pos = new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        IBlockState tall_grass = this.world.func_180495_p(pos);
        IBlockState extra_grass = this.world.func_180495_p(pos.func_177984_a());
        if (IS_BEST_GRASS.apply((Object)tall_grass) && (Integer)tall_grass.func_177229_b((IProperty)IPrimalPlants.PLANT_AGE) > 1) {
            return true;
        }
        if (IS_BEST_GRASS.apply((Object)extra_grass) && (Integer)extra_grass.func_177229_b((IProperty)IPrimalPlants.PLANT_AGE) > 1) {
            return true;
        }
        return BlockMultiplexer.forBlock(new Block[]{PrimalAPI.Blocks.NETHER_MYCELIUM, Blocks.field_150391_bh, Blocks.field_150349_c}).apply(this.world.func_180495_p(pos.func_177977_b()));
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.world.func_72960_a((Entity)this.entity, (byte)10);
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos pos = new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
            BlockPos extra_pos = pos.func_177984_a();
            BlockPos flat_pos = pos.func_177977_b();
            IBlockState tall_state = this.world.func_180495_p(pos);
            IBlockState extra_state = this.world.func_180495_p(extra_pos);
            IBlockState flat_state = this.world.func_180495_p(flat_pos);
            if (IS_BEST_GRASS.apply((Object)tall_state)) {
                Block grass = tall_state.func_177230_c();
                this.eatGrass(pos, grass, IS_HOST_BLOCK.apply((Object)flat_state) ? grass : Blocks.field_150350_a);
            } else if (IS_BEST_GRASS.apply((Object)extra_state)) {
                Block grass = extra_state.func_177230_c();
                this.eatGrass(extra_pos, grass, IS_HOST_BLOCK.apply((Object)tall_state) ? grass : Blocks.field_150350_a);
            } else {
                Block flat_block = flat_state.func_177230_c();
                if (flat_block == PrimalAPI.Blocks.NETHER_MYCELIUM) {
                    this.eatGrass(flat_pos, flat_block, Blocks.field_150424_aL);
                } else if (flat_block == Blocks.field_150349_c || flat_block == Blocks.field_150391_bh) {
                    this.eatGrass(flat_pos, flat_block, PrimalAPI.Blocks.DESICCATED_STONE);
                }
            }
        }
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    private void eatGrass(BlockPos pos, Block eaten_block, Block new_block) {
        if (ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.entity)) {
            this.world.func_175718_b(2001, pos, Block.func_149682_b((Block)eaten_block));
            this.world.func_180501_a(pos, new_block.func_176223_P(), 18);
        }
        this.entity.func_70615_aA();
    }
}

