/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EntitySelectors;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.init.ModConfig;

public class AIEatFoodItems
extends EntityAIBase {
    private final Predicate<Entity> canBeSeenSelector;
    private final EntityAnimal entity;
    private EntityItem entityItemTarget;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean isRunning;
    private final float maxTargetDistance;

    public AIEatFoodItems(EntityAnimal entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.maxTargetDistance = 10.0f;
        this.func_75248_a(3);
        if (!(entity.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
        this.canBeSeenSelector = new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && entity.func_70089_S() && AIEatFoodItems.this.entity.func_70635_at().func_75522_a(entity) && !AIEatFoodItems.this.entity.func_184191_r(entity);
            }
        };
    }

    private boolean isEdible(ItemStack stack) {
        return this.entity.func_70877_b(stack);
    }

    private boolean eatItem() {
        ItemStack itemstack = this.entityItemTarget.func_92059_d();
        if (!itemstack.func_190926_b()) {
            if (this.entity.func_70877_b(itemstack) && this.entity.func_70874_b() == 0 && !this.entity.func_70880_s()) {
                this.entityItemTarget.func_70106_y();
                this.entity.func_146082_f(null);
                if ((double)this.entity.func_70681_au().nextFloat() < ModConfig.Monsters.OVIS_ATRE_REGROWTH_CHANCE) {
                    this.entity.func_70615_aA();
                }
                return true;
            }
            if (this.entity.func_70631_g_() && this.entity.func_70877_b(itemstack)) {
                this.entityItemTarget.func_70106_y();
                this.entity.func_175501_a((int)((float)(-this.entity.func_70874_b() / 20) * 0.1f), true);
                return true;
            }
        }
        return false;
    }

    private void continueTask() {
        this.entity.func_70661_as().func_75499_g();
        this.entityItemTarget = null;
        this.isRunning = true;
    }

    public boolean func_75250_a() {
        List list;
        if (this.entity.func_70880_s()) {
            return false;
        }
        if (PrimalAPI.randomCheck(4) && (list = this.entity.field_70170_p.func_175647_a(EntityItem.class, this.entity.func_174813_aQ().func_72314_b(10.0, 3.0, 10.0), Predicates.and((Predicate)EntitySelectors.field_188444_d, this.canBeSeenSelector))).size() > 0) {
            for (EntityItem entityItem : list) {
                if (!this.isEdible(entityItem.func_92059_d())) continue;
                this.entityItemTarget = entityItem;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() && this.entityItemTarget.func_70089_S() && this.entityItemTarget.func_70068_e((Entity)this.entity) < (double)(this.maxTargetDistance * this.maxTargetDistance);
    }

    public void func_75249_e() {
        this.targetX = this.entityItemTarget.field_70165_t;
        this.targetY = this.entityItemTarget.field_70163_u;
        this.targetZ = this.entityItemTarget.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.entityItemTarget = null;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.entity.func_70671_ap().func_75651_a((Entity)this.entityItemTarget, (float)(this.entity.func_184649_cE() + 20), (float)this.entity.func_70646_bf());
        if (this.entity.func_70068_e((Entity)this.entityItemTarget) < 1.0) {
            this.entity.func_70661_as().func_75499_g();
            if (!this.eatItem()) {
                this.continueTask();
            }
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)this.entityItemTarget, this.speed);
            if (this.entityItemTarget.field_70128_L) {
                this.continueTask();
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

