/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.containers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.containers.ContainerPrimalBase;
import nmd.primal.core.common.network.MessageLastRecipe;
import nmd.primal.core.common.tiles.AbstractTileWorkTable;

public abstract class AbstractContainerWorkTable<TILE extends AbstractTileWorkTable>
extends ContainerPrimalBase<TILE> {
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    public InventoryCraftResult craftResult = new InventoryCraftResult();
    public IItemHandler storage;
    public final EntityPlayer player;
    public IRecipe previousLastRecipe;
    public IRecipe lastRecipe;

    public AbstractContainerWorkTable(InventoryPlayer inventory, TILE tile, World world) {
        this.tile = tile;
        this.world = world;
        this.player = inventory.field_70458_d;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return ((AbstractTileWorkTable)this.tile).isUsable(player);
    }

    public void func_75130_a(IInventory inventory) {
        this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
        ((AbstractTileWorkTable)this.tile).updateBlock();
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            this.saveCraftingMatrix();
            this.saveStorage();
        }
    }

    public ItemStack func_184996_a(int par1, int par2, ClickType par3, EntityPlayer par4EntityPlayer) {
        ItemStack ret = super.func_184996_a(par1, par2, par3, par4EntityPlayer);
        this.saveCraftingMatrix();
        this.saveStorage();
        return ret;
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inventory, InventoryCraftResult result) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.lastRecipe == null || !this.lastRecipe.func_77569_a(inventory, world)) {
            this.lastRecipe = CraftingManager.func_192413_b((InventoryCrafting)inventory, (World)world);
        }
        if (this.lastRecipe != null) {
            itemstack = this.lastRecipe.func_77572_b(inventory);
        }
        if (!world.field_72995_K) {
            result.func_70299_a(0, itemstack);
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (this.previousLastRecipe != this.lastRecipe) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
            } else if (this.previousLastRecipe != null && this.previousLastRecipe == this.lastRecipe && !ItemStack.func_77989_b((ItemStack)this.previousLastRecipe.func_77572_b(inventory), (ItemStack)this.lastRecipe.func_77572_b(inventory))) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
            }
            PrimalCore.NETWORK.sendTo((IMessage)new MessageLastRecipe(this.lastRecipe), playerMP);
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
        }
        this.previousLastRecipe = this.lastRecipe;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 10 && index < 37 ? !this.func_75135_a(itemstack1, 37, 46, false) : (index >= 37 && index < 46 ? !this.func_75135_a(itemstack1, 10, 37, false) : !this.func_75135_a(itemstack1, 10, 46, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(this.player, itemstack1);
            this.saveCraftingMatrix();
            this.saveStorage();
            this.func_75142_b();
        }
        return itemstack;
    }

    public void updateCraftingMatrix() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.craftMatrix.func_70299_a(i, ((AbstractTileWorkTable)this.tile).getCraftingHandler().getStackInSlot(i));
        }
        ((AbstractTileWorkTable)this.tile).updateBlock();
    }

    public void saveCraftingMatrix() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ((AbstractTileWorkTable)this.tile).getCraftingHandler().setStackInSlot(i, this.craftMatrix.func_70301_a(i));
        }
        ((AbstractTileWorkTable)this.tile).updateBlock();
    }

    public void updateStorage() {
        if (this.storage != null) {
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                this.storage.insertItem(i, this.storage.getStackInSlot(i), false);
            }
        }
        ((AbstractTileWorkTable)this.tile).updateBlock();
    }

    public void saveStorage() {
        if (this.storage != null) {
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                this.storage.insertItem(i, this.storage.getStackInSlot(i), true);
            }
        }
        ((AbstractTileWorkTable)this.tile).updateBlock();
    }

    public int getPlayerInventoryStart() {
        return 0;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    public NonNullList<ItemStack> getRemainingItems() {
        if (this.lastRecipe != null && this.lastRecipe.func_77569_a(this.craftMatrix, this.world)) {
            return this.lastRecipe.func_179532_b(this.craftMatrix);
        }
        return this.getCraftingItems();
    }

    public NonNullList<ItemStack> getCraftingItems() {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.add((Object)stack);
        }
        return list;
    }
}

