/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.vanilla;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

public class VanillaTorchBlock
extends BlockTorch
implements ILit,
IPickup {
    private final int base_life;
    private final int burn_rate;

    public VanillaTorchBlock() {
        this.setRegistryName("minecraft", "torch");
        this.func_149663_c("torch");
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.base_life = ModConfig.Lighting.TORCH_LIFESPAN;
        this.burn_rate = ModConfig.Flammability.TORCH_ENTITY_BURN;
    }

    @Override
    public boolean isLit(IBlockAccess world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_180501_a(pos, PrimalAPI.Blocks.TORCH_WOOD.func_176223_P().func_177226_a((IProperty)field_176596_a, state.func_177229_b((IProperty)field_176596_a)).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            FXHelper.soundFireExtinguish(world, pos, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canPickup(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return ModConfig.Features.ENABLE_TORCH_PICKUP;
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.func_175698_g(pos)) {
            FXHelper.soundFireAmbient(world, pos, 1.0f);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150478_aa));
            return true;
        }
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (PrimalAPI.randomCheckFail(this.burn_rate) && !entity.func_70026_G() && !entity.func_70045_F() && entity instanceof EntityLivingBase) {
            entity.func_70015_d(2);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && PrimalAPI.randomCheckFail(this.getTorchLifeSpan(world, pos))) {
            this.doExtinguish(world, pos, state, EnumFacing.UP, null);
        }
    }

    public int getTorchLifeSpan(World world, BlockPos pos) {
        int life_span = 0;
        if (this.base_life > 0) {
            if (world.func_175727_C(pos)) {
                PrimalAPI.logger(65, "torch is getting precipitation");
                life_span = this.base_life;
                if (world.canSnowAtBody(pos, false)) {
                    PrimalAPI.logger(65, "torch is getting snow");
                    life_span *= 2;
                }
            } else if (ModConfig.Lighting.TORCHES_DIE) {
                PrimalAPI.logger(65, "torches die");
                life_span = this.base_life * 4;
            }
        }
        PrimalAPI.logger(65, "torch life span: " + life_span);
        return life_span;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)PrimalAPI.Blocks.TORCH_WOOD);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumParticleTypes smoke = world.func_175727_C(pos) ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        if (facing.func_176740_k().func_176722_c()) {
            EnumFacing opposite = facing.func_176734_d();
            world.func_175688_a(smoke, d0 + d4 * (double)opposite.func_82601_c(), d1 + d3, d2 + d4 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4 * (double)opposite.func_82601_c(), d1 + d3, d2 + d4 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            world.func_175688_a(smoke, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

