/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.mods;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.ITypeLogs;
import nmd.primal.core.api.interfaces.types.ITypeLogsAll;
import nmd.primal.core.api.interfaces.types.ITypePlanks;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class ThaumCompat {
    public static final String MOD_ID = "thaumcraft";
    @GameRegistry.ObjectHolder(value="thaumcraft:cluster")
    private static final Item THA_CLUSTER;
    @GameRegistry.ObjectHolder(value="thaumcraft:nugget")
    private static final Item THA_NUGGET;
    @GameRegistry.ObjectHolder(value="thaumcraft:quicksilver")
    private static final Item THA_QUICKSILVER;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ThaumCompat());
    }

    @SubscribeEvent
    public void registerSmelterRecipes(RegistryEvent.Register<SmelterRecipe> event) {
        if (ModConfig.Compatibility.THAUMCRAFT_SMELTER_RECIPES && THA_CLUSTER != null) {
            PrimalAPI.logger(7, "Registering Smelter Recipes: thaumcraft");
            IForgeRegistry<SmelterRecipe> recipes = SmelterRecipe.REGISTRY;
            List<ItemStack> charcoal = RecipeHelper.getOreStack(1, "charcoalGood", "charcoalHigh");
            List<ItemStack> flux = RecipeHelper.getOreStack(2, "slackLime");
            ItemStack ore_slag = new ItemStack(PrimalAPI.Items.SLAG, 1);
            int cluster_smelting_time = 16;
            int cluster_ingot_amount = 2;
            int cluster_extra_amount = 6;
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 0)), charcoal, flux, new ItemStack(Items.field_151042_j, 2), new ItemStack(Items.field_191525_da, 6), ore_slag).setRecipeName("thaumcraft_cluster_iron"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 1)), charcoal, flux, new ItemStack(Items.field_151043_k, 2), new ItemStack(Items.field_151074_bl, 6), ore_slag).setRecipeName("thaumcraft_cluster_gold"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 2)), charcoal, flux, new ItemStack(PrimalAPI.Items.COPPER_INGOT, 2), new ItemStack(PrimalAPI.Items.COPPER_NUGGET, 6), ore_slag).setRecipeName("thaumcraft_cluster_copper"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 3)), charcoal, flux, new ItemStack(PrimalAPI.Items.TIN_INGOT, 2), new ItemStack(PrimalAPI.Items.TIN_NUGGET, 6), ore_slag).setRecipeName("thaumcraft_cluster_tin"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 4)), charcoal, flux, new ItemStack(PrimalAPI.Items.SILVER_INGOT, 2), new ItemStack(PrimalAPI.Items.SILVER_NUGGET, 6), ore_slag).setRecipeName("thaumcraft_cluster_silver"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 5)), charcoal, flux, new ItemStack(PrimalAPI.Items.LEAD_INGOT, 2), new ItemStack(PrimalAPI.Items.LEAD_NUGGET, 6), ore_slag).setRecipeName("thaumcraft_cluster_lead"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 6)), charcoal, flux, new ItemStack(THA_QUICKSILVER, 3), new ItemStack(THA_NUGGET, 3, 5), ore_slag).setRecipeName("thaumcraft_cluster_cinnabar"));
            recipes.register((IForgeRegistryEntry)new SmelterRecipe(16, RecipeHelper.buildList(new ItemStack(THA_CLUSTER, 1, 7)), charcoal, flux, new ItemStack(Items.field_151128_bU, 3), new ItemStack(THA_NUGGET, 3, 9), ore_slag).setRecipeName("thaumcraft_cluster_quartz"));
        }
    }

    @SubscribeEvent
    public void registerAspects(AspectRegistryEvent event) {
        try {
            AspectRegisterHelper aspects = new AspectRegisterHelper(event);
            aspects.register(PrimalAPI.Items.ARROW_QUARTZ, new AspectList().add(Aspect.AVERSION, 2).add(Aspect.CRYSTAL, 2));
            aspects.register(PrimalAPI.Items.ARROW_TORCH_WOOD, new AspectList().add(Aspect.FIRE, 2));
            aspects.register(PrimalAPI.Items.ARROW_TORCH_NETHER, new AspectList().add(Aspect.FIRE, 2));
            aspects.register(PrimalAPI.Items.ARROW_PARAFFIN, new AspectList().add(Aspect.FIRE, 1).add(Aspect.ENERGY, 1).add(Aspect.ENTROPY, 1));
            aspects.register(PrimalAPI.Items.FISHING_ROD_CORYPHA, new AspectList().add(Aspect.FIRE, 10).add(Aspect.TOOL, 7).add(Aspect.BEAST, 7).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.LADLE_IRONWOOD, new AspectList().add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.LADLE_YEW, new AspectList().add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Items.LADLE_BONE, new AspectList().add(Aspect.UNDEAD, 1));
            aspects.register(PrimalAPI.Items.LADLE_LACQUER, new AspectList().add(Aspect.ORDER, 1));
            aspects.register(PrimalAPI.Items.LADLE_CORYPHA, new AspectList().add(Aspect.BEAST, 1));
            aspects.register(PrimalAPI.Blocks.TORCH_WOOD, new AspectList().add(Aspect.DARKNESS, 5));
            aspects.register(PrimalAPI.Blocks.TORCH_NETHER, new AspectList().add(Aspect.DARKNESS, 5));
            aspects.register(PrimalAPI.Items.TORCH_NETHER_LIT, new AspectList().add(Aspect.LIGHT, 5));
            aspects.register(PrimalAPI.Blocks.ORE_SALT_FLAT, new AspectList().add(Aspect.ORDER, 9).add(Aspect.SOUL, 9));
            aspects.register(PrimalAPI.Blocks.ORE_SALT, 0, new AspectList().add(Aspect.ORDER, 9).add(Aspect.EARTH, 9));
            aspects.register(PrimalAPI.Blocks.ORE_SALT, 1, new AspectList().add(Aspect.ENTROPY, 9).add(Aspect.FIRE, 9));
            aspects.register(PrimalAPI.Blocks.ORE_SALT, 2, new AspectList().add(Aspect.ENTROPY, 9).add(Aspect.ELDRITCH, 9));
            aspects.register(PrimalAPI.Items.SALT_DUST_NETJRY, new AspectList().add(Aspect.ORDER, 1).add(Aspect.SOUL, 1).add(Aspect.ALCHEMY, 1));
            aspects.register(PrimalAPI.Items.SALT_DUST_ROCK, new AspectList().add(Aspect.ORDER, 1).add(Aspect.TOOL, 1).add(Aspect.ALCHEMY, 1));
            aspects.register(PrimalAPI.Items.SALT_DUST_FIRE, new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.FIRE, 1).add(Aspect.ALCHEMY, 1));
            aspects.register(PrimalAPI.Items.SALT_DUST_VOID, new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.ELDRITCH, 1).add(Aspect.ALCHEMY, 1));
            aspects.register(PrimalAPI.Items.ASH_BONE, new AspectList().add(Aspect.DEATH, 6).add(Aspect.LIFE, 6).add(Aspect.ALCHEMY, 6));
            aspects.register(PrimalAPI.Items.ASH_WOLF, new AspectList().add(Aspect.ENTROPY, 6).add(Aspect.SOUL, 6));
            aspects.register(PrimalAPI.Blocks.ASH_IRONWOOD, new AspectList().add(Aspect.ENTROPY, 2).add(Aspect.MAGIC, 2));
            aspects.register(PrimalAPI.Blocks.ASH_YEW, new AspectList().add(Aspect.ENTROPY, 2).add(Aspect.DEATH, 2));
            aspects.register(PrimalAPI.Blocks.ASH_COMMON, new AspectList().add(Aspect.ENTROPY, 2).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Blocks.TERRA_BLOCK, new AspectList().add(Aspect.EARTH, 15).add(Aspect.LIFE, 15));
            aspects.register(PrimalAPI.Blocks.CINIS_BLOCK, new AspectList().add(Aspect.EARTH, 15).add(Aspect.DEATH, 15));
            aspects.register(PrimalAPI.Items.MUD_CLUMP, new AspectList().add(Aspect.EARTH, 5).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Items.TERRA_CLUMP, new AspectList().add(Aspect.EARTH, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.CINIS_CLUMP, new AspectList().add(Aspect.EARTH, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MUCK, new AspectList().add(Aspect.LIFE, 5).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Items.MUCK_MOLTEN, new AspectList().add(Aspect.LIFE, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Blocks.CHARCOAL_STACK, new AspectList().add(Aspect.FIRE, 67).add(Aspect.ENERGY, 67));
            aspects.register(PrimalAPI.Blocks.CALCIFIED_PARAFFIN, new AspectList().add(Aspect.FIRE, 40).add(Aspect.ENERGY, 40));
            aspects.register(PrimalAPI.Items.BITUMIN_CLUMP, new AspectList().add(Aspect.FIRE, 6).add(Aspect.ENERGY, 6).add(Aspect.ALCHEMY, 6));
            aspects.register(PrimalAPI.Items.PARAFFIN_CLUMP, new AspectList().add(Aspect.FIRE, 6).add(Aspect.ENERGY, 6));
            aspects.register(PrimalAPI.Items.CHARCOAL_FAIR, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ENERGY, 10));
            aspects.register(PrimalAPI.Items.CHARCOAL_GOOD, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ENERGY, 10));
            aspects.register(PrimalAPI.Items.CHARCOAL_HIGH, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ENERGY, 10));
            aspects.register(PrimalAPI.Items.CHARCOAL_GOOD, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ENERGY, 10));
            aspects.register(PrimalAPI.Items.CHARCOAL_PURE, new AspectList().add(Aspect.ENERGY, 20));
            aspects.register(PrimalAPI.Items.WAX_RESIDUE, new AspectList().add(Aspect.DESIRE, 1).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.SLAG, new AspectList().add(Aspect.FLUX, 1).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.ROT, new AspectList().add(Aspect.DEATH, 3));
            aspects.register(PrimalAPI.Items.URUSHI_GROUND, new AspectList().add(Aspect.ORDER, 5).add(Aspect.ALCHEMY, 3).add(Aspect.DESIRE, 2));
            aspects.register(PrimalAPI.Items.URUSHI_BOTTLE, new AspectList().add(Aspect.ORDER, 5).add(Aspect.ALCHEMY, 3).add(Aspect.DESIRE, 2));
            aspects.register(PrimalAPI.Items.TANNIN_GROUND, new AspectList().add(Aspect.EXCHANGE, 5).add(Aspect.ALCHEMY, 3).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.TANNIN_BOTTLE, new AspectList().add(Aspect.EXCHANGE, 5).add(Aspect.ALCHEMY, 3).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.BOTTLE_PARAFFIN, new AspectList().add(Aspect.FIRE, 8).add(Aspect.ENERGY, 8).add(Aspect.ENTROPY, 8));
            aspects.register(PrimalAPI.Items.OVIS_MILK_BOTTLE, new AspectList().add(Aspect.LIFE, 6).add(Aspect.FIRE, 4).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.CARBONATE_SLACK, new AspectList().add(Aspect.ALCHEMY, 1).add(Aspect.ORDER, 1));
            aspects.register(PrimalAPI.Items.CARBONATE_FERRO_SLACK, new AspectList().add(Aspect.ALCHEMY, 1).add(Aspect.ENTROPY, 1));
            aspects.register(PrimalAPI.Blocks.ORE_BOG_IRON, 0, new AspectList().add(Aspect.WATER, 15).add(Aspect.EARTH, 15).add(Aspect.METAL, 9));
            aspects.register(PrimalAPI.Blocks.ORE_BOG_IRON, 1, new AspectList().add(Aspect.WATER, 15).add(Aspect.EARTH, 15).add(Aspect.METAL, 9));
            aspects.register(PrimalAPI.Blocks.ORE_BOG_IRON, 2, new AspectList().add(Aspect.FIRE, 15).add(Aspect.EARTH, 15).add(Aspect.METAL, 9));
            aspects.register(PrimalAPI.Items.ORE_CLUSTER_BOG_IRON, new AspectList().add(Aspect.METAL, 3));
            aspects.register(PrimalAPI.Blocks.ORE_MAGNETITE, 0, new AspectList().add(Aspect.EARTH, 5).add(Aspect.METAL, 75));
            aspects.register(PrimalAPI.Blocks.ORE_MAGNETITE, 1, new AspectList().add(Aspect.EARTH, 15).add(Aspect.FIRE, 2).add(Aspect.METAL, 75));
            aspects.register(PrimalAPI.Blocks.ORE_MAGNETITE, 2, new AspectList().add(Aspect.EARTH, 5).add(Aspect.DARKNESS, 2).add(Aspect.METAL, 75));
            aspects.register(PrimalAPI.Items.ORE_CLUSTER_MAGNETITE, new AspectList().add(Aspect.METAL, 15));
            aspects.register(PrimalAPI.Items.MAGNETITE_DUST, new AspectList().add(Aspect.METAL, 15));
            aspects.register(PrimalAPI.Items.BONE_FLAKE, new AspectList().add(Aspect.LIFE, 2).add(Aspect.DEATH, 2));
            aspects.register(PrimalAPI.Items.BONE_POINT, new AspectList().add(Aspect.LIFE, 1).add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Items.FLINT_POINT, new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
            aspects.register(PrimalAPI.Items.QUARTZ_FLAKE, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.ENERGY, 2));
            aspects.register(PrimalAPI.Items.QUARTZ_POINT, new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.ENERGY, 1));
            aspects.register(PrimalAPI.Items.OBSIDIAN_PLATE, new AspectList().add(Aspect.EARTH, 6).add(Aspect.FIRE, 6).add(Aspect.DARKNESS, 6));
            aspects.register(PrimalAPI.Items.OBSIDIAN_SHARD, new AspectList().add(Aspect.EARTH, 6).add(Aspect.FIRE, 6).add(Aspect.DARKNESS, 6));
            aspects.register(PrimalAPI.Items.OBSIDIAN_FLAKE, new AspectList().add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.DARKNESS, 3));
            aspects.register(PrimalAPI.Items.OBSIDIAN_POINT, new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.DARKNESS, 1));
            aspects.register(PrimalAPI.Items.OBSIDIAN_LENS, new AspectList().add(Aspect.DARKNESS, 6));
            aspects.register(PrimalAPI.Items.EMERALD_KNAPP, new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.DESIRE, 3));
            aspects.register(PrimalAPI.Items.EMERALD_POINT, new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.DESIRE, 1));
            aspects.register(PrimalAPI.Items.DIAMOND_KNAPP, new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.DESIRE, 3));
            aspects.register(PrimalAPI.Items.DIAMOND_POINT, new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.DESIRE, 1));
            aspects.register(PrimalAPI.Items.OPAL, new AspectList().add(Aspect.CRYSTAL, 15).add(Aspect.MAGIC, 15));
            aspects.register(PrimalAPI.Items.OPAL_FLAKE, new AspectList().add(Aspect.CRYSTAL, 3).add(Aspect.MAGIC, 3));
            aspects.register(PrimalAPI.Items.OPAL_POINT, new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.MAGIC, 1));
            aspects.register(PrimalAPI.Items.LEATHER_STRIP, new AspectList().add(Aspect.BEAST, 1));
            aspects.register(PrimalAPI.Items.LEATHER_CORDAGE, new AspectList().add(Aspect.BEAST, 2).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.SHARK_FIN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.WATER, 2).add(Aspect.MOTION, 2));
            aspects.register(PrimalAPI.Items.SHARK_TOOTH, new AspectList().add(Aspect.BEAST, 5).add(Aspect.WATER, 2).add(Aspect.AVERSION, 2));
            aspects.register(PrimalAPI.Blocks.LOGS_STRIPPED, ITypeLogsAll.EnumType.IRONWOOD.getMetadata(), new AspectList().add(Aspect.PLANT, 16).add(Aspect.LIFE, 16));
            aspects.register(PrimalAPI.Blocks.LOGS, ITypeLogs.EnumType.IRONWOOD.getMetadata(), new AspectList().add(Aspect.PLANT, 20).add(Aspect.LIFE, 20));
            aspects.register(PrimalAPI.Blocks.LEAVES, ITypeLogs.EnumType.IRONWOOD.getMetadata(), new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Blocks.PLANKS, ITypePlanks.EnumType.IRONWOOD.getMetadata(), new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_IRONWOOD, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 4));
            aspects.register(PrimalAPI.Blocks.SLAB_IRONWOOD, new AspectList().add(Aspect.PLANT, 3).add(Aspect.LIFE, 3));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_IRONWOOD, new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Blocks.SLAT_IRONWOOD, new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.IRONWOOD_STICK, new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.BARK_IRONWOOD, new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.SAPLING, ITypeLogs.EnumType.YEW.getMetadata(), new AspectList().add(Aspect.PLANT, 15).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Blocks.LOGS_STRIPPED, ITypeLogsAll.EnumType.YEW.getMetadata(), new AspectList().add(Aspect.PLANT, 16).add(Aspect.DEATH, 16));
            aspects.register(PrimalAPI.Blocks.LOGS, ITypeLogs.EnumType.YEW.getMetadata(), new AspectList().add(Aspect.PLANT, 20).add(Aspect.DEATH, 20));
            aspects.register(PrimalAPI.Blocks.LEAVES, ITypeLogs.EnumType.YEW.getMetadata(), new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Blocks.PLANKS, ITypePlanks.EnumType.YEW.getMetadata(), new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_YEW, new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 4));
            aspects.register(PrimalAPI.Blocks.SLAB_YEW, new AspectList().add(Aspect.PLANT, 3).add(Aspect.DEATH, 3));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_YEW, new AspectList().add(Aspect.PLANT, 2).add(Aspect.DEATH, 2));
            aspects.register(PrimalAPI.Blocks.SLAT_YEW, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Items.BARREL_LID_YEW, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Items.YEW_STICK, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Items.BARK_YEW, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Blocks.PLANKS, ITypePlanks.EnumType.LACQUER.getMetadata(), new AspectList().add(Aspect.PLANT, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Blocks.SLAB_LACQUER, new AspectList().add(Aspect.PLANT, 3).add(Aspect.ORDER, 3));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_LACQUER, new AspectList().add(Aspect.PLANT, 2).add(Aspect.ORDER, 2));
            aspects.register(PrimalAPI.Blocks.SLAT_LACQUER, new AspectList().add(Aspect.PLANT, 1).add(Aspect.ORDER, 1));
            aspects.register(PrimalAPI.Items.BARREL_LID_LACQUER, new AspectList().add(Aspect.PLANT, 1).add(Aspect.ORDER, 1));
            aspects.register(PrimalAPI.Items.LACQUER_STICK, new AspectList().add(Aspect.PLANT, 1).add(Aspect.ORDER, 1));
            aspects.register(PrimalAPI.Blocks.CORYPHA_STALK, new AspectList().add(Aspect.BEAST, 10).add(Aspect.LIFE, 10));
            aspects.register(PrimalAPI.Blocks.PLANKS, ITypePlanks.EnumType.CORYPHA.getMetadata(), new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_CORYPHA, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Blocks.SLAB_CORYPHA, new AspectList().add(Aspect.BEAST, 3).add(Aspect.LIFE, 3));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_CORYPHA, new AspectList().add(Aspect.BEAST, 2).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Blocks.SLAT_CORYPHA, new AspectList().add(Aspect.BEAST, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.BARREL_LID_CORYPHA, new AspectList().add(Aspect.BEAST, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.CORYPHA_STICK, new AspectList().add(Aspect.BEAST, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.BARK_CORYPHA, new AspectList().add(Aspect.BEAST, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_OAK, new AspectList().add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_SPRUCE, new AspectList().add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_BIRCH, new AspectList().add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_JUNGLE, new AspectList().add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_ACACIA, new AspectList().add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Items.LOGS_SPLIT_DARK_OAK, new AspectList().add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_OAK, new AspectList().add(Aspect.PLANT, 2));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_SPRUCE, new AspectList().add(Aspect.PLANT, 2));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_BIRCH, new AspectList().add(Aspect.PLANT, 2));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_JUNGLE, new AspectList().add(Aspect.PLANT, 2));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_ACACIA, new AspectList().add(Aspect.PLANT, 2));
            aspects.register(PrimalAPI.Blocks.THIN_SLAB_DARK_OAK, new AspectList().add(Aspect.PLANT, 2));
            aspects.register(PrimalAPI.Blocks.SLAT_OAK, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Blocks.SLAT_SPRUCE, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Blocks.SLAT_BIRCH, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Blocks.SLAT_JUNGLE, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Blocks.SLAT_ACACIA, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Blocks.SLAT_DARK_OAK, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.BARK_OAK, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.BARK_SPRUCE, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.BARK_BIRCH, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.BARK_JUNGLE, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.BARK_ACACIA, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.BARK_ACACIA, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.HIDE_RAW, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ENTROPY, 5));
            aspects.register(PrimalAPI.Items.HIDE_SALTED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Items.HIDE_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Items.HIDE_TANNED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Items.HIDE_SPOILED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.PIGMAN_HIDE_RAW, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ENTROPY, 5));
            aspects.register(PrimalAPI.Items.PIGMAN_HIDE_SALTED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Items.PIGMAN_HIDE_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Items.PIGMAN_HIDE_TANNED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Items.PIGMAN_HIDE_SPOILED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.PELT_ANIMAL_LARGE, new AspectList().add(Aspect.BEAST, 15));
            aspects.register(PrimalAPI.Items.PELT_BEAR_BLACK, new AspectList().add(Aspect.BEAST, 15));
            aspects.register(PrimalAPI.Items.PELT_BEAR_BROWN, new AspectList().add(Aspect.BEAST, 15));
            aspects.register(PrimalAPI.Items.PELT_BEAR_POLAR, new AspectList().add(Aspect.BEAST, 15));
            aspects.register(PrimalAPI.Items.PELT_COW, new AspectList().add(Aspect.BEAST, 15));
            aspects.register(PrimalAPI.Items.PELT_MOOSHROOM, new AspectList().add(Aspect.BEAST, 15).add(Aspect.FLUX, 2));
            aspects.register(PrimalAPI.Items.ANIMAL_FUR, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_ANIMAL, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_DOG, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_PIG, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_SHEEP, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_DONKEY, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_MULE, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_HORSE, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_LLAMA, new AspectList().add(Aspect.BEAST, 10));
            aspects.register(PrimalAPI.Items.PELT_WOLF, new AspectList().add(Aspect.BEAST, 10).add(Aspect.MAN, 5));
            aspects.register(PrimalAPI.Items.PELT_ATRE, new AspectList().add(Aspect.BEAST, 10).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Items.PELT_SHARK, new AspectList().add(Aspect.BEAST, 10).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Items.PELT_GATOR, new AspectList().add(Aspect.BEAST, 10).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Items.WOLF_HEAD_ITEM, new AspectList().add(Aspect.BEAST, 2).add(Aspect.MIND, 2));
            aspects.register(PrimalAPI.Items.WOLF_HEAD, new AspectList().add(Aspect.BEAST, 2).add(Aspect.MIND, 2));
            aspects.register(PrimalAPI.Items.OVIS_HEAD, new AspectList().add(Aspect.BEAST, 2).add(Aspect.MIND, 2));
            aspects.register(PrimalAPI.Items.FISH_LAVA_WORM_RAW, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Items.FISH_LAVA_WORM_SALTED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_LAVA_WORM_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_LAVA_WORM_CURED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_LAVA_WORM_ROTTEN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.FISH_LAVA_CRAWDAD_RAW, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Items.FISH_LAVA_CRAWDAD_SALTED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_LAVA_CRAWDAD_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_LAVA_CRAWDAD_CURED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_LAVA_CRAWDAD_ROTTEN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.FISH_COD_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_COD_CURED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_COD_ROTTEN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_SALMON_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_SALMON_CURED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_SALMON_ROTTEN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_CLOWN_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_CLOWN_CURED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_CLOWN_ROTTEN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_PUFFER_DRIED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_PUFFER_CURED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.FISH_PUFFER_ROTTEN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_RAW_OVIS, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_OVIS, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_DRIED_OVIS, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_OVIS, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_OVIS, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_PIGMAN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_PIGMAN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_DRIED_PIGMAN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_PIGMAN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_PIGMAN, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_WOLF, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.EARTH, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_WOLF, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_DRIED_WOLF, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_WOLF, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_WOLF, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_BEAR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.EARTH, 5));
            aspects.register(PrimalAPI.Items.MEAT_DRIED_BEAR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_BEAR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_BEAR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_LLAMA, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.EARTH, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_LLAMA, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_LLAMA, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_LLAMA, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_HORSE, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.EARTH, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_HORSE, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_DRIED_HORSE, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_HORSE, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_HORSE, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_BAT, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.AIR, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_BAT, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_DRIED_BAT, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_BAT, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_BAT, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_SHARK, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_SHARK, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_SHARK, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_SHARK, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.MEAT_RAW_GATOR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Items.MEAT_CURED_GATOR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_COOKED_GATOR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.MEAT_ROTTEN_GATOR, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.EGG_DEATH, new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.EGG_BOILED, new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.POTATO_BOILED, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.POTATO_ROTTEN, new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.CHEESE_WHITE, new AspectList().add(Aspect.LIFE, 8).add(Aspect.ENERGY, 2).add(Aspect.WATER, 2));
            aspects.register(PrimalAPI.Items.CHEESE_RED, new AspectList().add(Aspect.LIFE, 8).add(Aspect.ENERGY, 2).add(Aspect.FIRE, 2));
            aspects.register(PrimalAPI.Items.CORN_COB, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5).add(Aspect.EARTH, 5));
            aspects.register(PrimalAPI.Items.CORN_COB_COOKED, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.CORN_GROUND, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.CORN_BREAD, new AspectList().add(Aspect.PLANT, 11).add(Aspect.LIFE, 11));
            aspects.register(PrimalAPI.Items.WHEAT_GROUND, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Items.MUSHROOM_COOKED, new AspectList().add(Aspect.DARKNESS, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Items.PUMPKIN_PIECE, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.CHUM, new AspectList().add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.SALO, new AspectList().add(Aspect.LIFE, 8).add(Aspect.ORDER, 2));
            aspects.register(PrimalAPI.Items.ANIMAL_FAT, new AspectList().add(Aspect.LIFE, 4).add(Aspect.BEAST, 2));
            aspects.register(PrimalAPI.Items.ANIMAL_FAT_NETHER, new AspectList().add(Aspect.DEATH, 4).add(Aspect.BEAST, 2));
            aspects.register(PrimalAPI.Items.TALLOW, new AspectList().add(Aspect.ALCHEMY, 4).add(Aspect.BEAST, 2));
            aspects.register(PrimalAPI.Blocks.TALL_GRASS, new AspectList().add(Aspect.PLANT, 5).add(Aspect.AIR, 1));
            aspects.register(PrimalAPI.Items.TALL_GRASS_SEEDS, new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.DRY_GRASS, new AspectList().add(Aspect.PLANT, 2).add(Aspect.AURA, 2));
            aspects.register(PrimalAPI.Items.DRY_GRASS_ROOT, new AspectList().add(Aspect.PLANT, 2).add(Aspect.AURA, 2));
            aspects.register(PrimalAPI.Items.DRY_GRASS_SEED, new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.RUSHES, new AspectList().add(Aspect.PLANT, 5).add(Aspect.MOTION, 1));
            aspects.register(PrimalAPI.Items.RUSH_STEMS, new AspectList().add(Aspect.PLANT, 5).add(Aspect.MOTION, 1));
            aspects.register(PrimalAPI.Items.RUSH_SEEDS, new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.CORN_STALK, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.CORN_STALK_WET, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.CORN_STALK_DRY, new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 2));
            aspects.register(PrimalAPI.Items.CORN_SEEDS, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.STRANGLE_WEED, new AspectList().add(Aspect.PLANT, 5).add(Aspect.TRAP, 1));
            aspects.register(PrimalAPI.Blocks.OLDMANS_BEARD, new AspectList().add(Aspect.PLANT, 5).add(Aspect.DARKNESS, 1));
            aspects.register(PrimalAPI.Blocks.THATCH_WET, new AspectList().add(Aspect.PLANT, 6).add(Aspect.WATER, 2));
            aspects.register(PrimalAPI.Blocks.THATCH, new AspectList().add(Aspect.PLANT, 3).add(Aspect.AIR, 1));
            aspects.register(PrimalAPI.Items.THATCHING_WET, new AspectList().add(Aspect.PLANT, 1).add(Aspect.WATER, 1));
            aspects.register(PrimalAPI.Items.THATCHING_DRY, new AspectList().add(Aspect.PLANT, 1).add(Aspect.AIR, 1));
            aspects.register(PrimalAPI.Items.PLANT_FIBER, new AspectList().add(Aspect.PLANT, 1));
            aspects.register(PrimalAPI.Items.PLANT_CORDAGE, new AspectList().add(Aspect.PLANT, 2).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.NETHER_WART_COOKED, new AspectList().add(Aspect.PLANT, 5).add(Aspect.ALCHEMY, 5).add(Aspect.FIRE, 1));
            aspects.register(PrimalAPI.Blocks.IGNIS_FATUUS, new AspectList().add(Aspect.LIGHT, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Blocks.NETHER_GROWTH, new AspectList().add(Aspect.FLUX, 2).add(Aspect.FIRE, 2).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Blocks.INFERUM_VINE, new AspectList().add(Aspect.LIFE, 2).add(Aspect.TRAP, 2).add(Aspect.FLUX, 1));
            aspects.register(PrimalAPI.Blocks.NETHER_BUSH, new AspectList().add(Aspect.DEATH, 2).add(Aspect.AVERSION, 2));
            aspects.register(PrimalAPI.Items.CORYPHA_SEED, new AspectList().add(Aspect.FIRE, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.CINERIS_GRASS, new AspectList().add(Aspect.BEAST, 2).add(Aspect.ENERGY, 2).add(Aspect.MOTION, 2));
            aspects.register(PrimalAPI.Items.CINERIS_SEED, new AspectList().add(Aspect.BEAST, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.CINERIS_FIBER, new AspectList().add(Aspect.BEAST, 1).add(Aspect.ENERGY, 1));
            aspects.register(PrimalAPI.Blocks.CINERIS_BLOOM, new AspectList().add(Aspect.FIRE, 2).add(Aspect.ENTROPY, 2).add(Aspect.MAGIC, 2));
            aspects.register(PrimalAPI.Items.SEARING_SPRIG, new AspectList().add(Aspect.FIRE, 2));
            aspects.register(PrimalAPI.Items.SEARING_EMBER, new AspectList().add(Aspect.FIRE, 2));
            aspects.register(PrimalAPI.Blocks.SINUOUS_WEED, new AspectList().add(Aspect.ENERGY, 6).add(Aspect.ALCHEMY, 6).add(Aspect.MOTION, 3));
            aspects.register(PrimalAPI.Items.SINUOUS_FIBER, new AspectList().add(Aspect.ENERGY, 2).add(Aspect.ALCHEMY, 2).add(Aspect.MOTION, 1));
            aspects.register(PrimalAPI.Items.SINUOUS_CORDAGE, new AspectList().add(Aspect.ENERGY, 6).add(Aspect.ALCHEMY, 6).add(Aspect.MOTION, 3));
            aspects.register(PrimalAPI.Items.SINUOUS_SPORE, new AspectList().add(Aspect.ALCHEMY, 2).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.SINUOUS_RESIN, new AspectList().add(Aspect.ALCHEMY, 2).add(Aspect.LIFE, 2).add(Aspect.ENERGY, 2));
            aspects.register(PrimalAPI.Blocks.DEVILS_TONGUE, new AspectList().add(Aspect.LIGHT, 6).add(Aspect.AURA, 2));
            aspects.register(PrimalAPI.Items.DEVILS_TONGUE_SEPALS, new AspectList().add(Aspect.LIGHT, 3).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.DEVILS_TONGUE_TENDRIL, new AspectList().add(Aspect.LIGHT, 1));
            aspects.register(PrimalAPI.Blocks.DAUCUS_MURN, new AspectList().add(Aspect.PLANT, 3).add(Aspect.FLUX, 2).add(Aspect.AVERSION, 2));
            aspects.register(PrimalAPI.Items.DAUCUS_MURN_SEEDS, new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.DAUCUS_MURN_FRONDS, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.DAUCUS_MURN_WITHERED, new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 2));
            aspects.register(PrimalAPI.Items.DAUCUS_MURN_ROOT, new AspectList().add(Aspect.LIFE, 2).add(Aspect.FLUX, 2));
            aspects.register(PrimalAPI.Items.DAUCUS_MURN_ROOT_COOKED, new AspectList().add(Aspect.LIFE, 8));
            aspects.register(PrimalAPI.Blocks.VALUS_OMNIFERUM, new AspectList().add(Aspect.PLANT, 3).add(Aspect.FLUX, 2).add(Aspect.MIND, 2));
            aspects.register(PrimalAPI.Items.VALUS_SEED, new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.VALUS_STALK_FRESH, new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 2));
            aspects.register(PrimalAPI.Items.VALUS_STALK_WITHERED, new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 2));
            aspects.register(PrimalAPI.Items.VALUS_MELON, new AspectList().add(Aspect.SENSES, 2).add(Aspect.FLUX, 2));
            aspects.register(PrimalAPI.Items.VALUS_BREAD, new AspectList().add(Aspect.SENSES, 4).add(Aspect.LIFE, 6));
            aspects.register(PrimalAPI.Items.VALUS_FIBER, new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Blocks.INANIS_GRASS, new AspectList().add(Aspect.BEAST, 2).add(Aspect.VOID, 2).add(Aspect.MOTION, 2));
            aspects.register(PrimalAPI.Items.INANIS_ROOT, new AspectList().add(Aspect.BEAST, 2).add(Aspect.VOID, 2).add(Aspect.MOTION, 2));
            aspects.register(PrimalAPI.Items.INANIS_SEED, new AspectList().add(Aspect.VOID, 2).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.INANIS_FIBER, new AspectList().add(Aspect.VOID, 1).add(Aspect.MOTION, 1));
            aspects.register(PrimalAPI.Items.INANIS_CORDAGE, new AspectList().add(Aspect.VOID, 1).add(Aspect.CRAFT, 1));
            aspects.register(PrimalAPI.Items.YEW_ARIL_SEEDLESS, new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1));
            aspects.register(PrimalAPI.Items.YEW_ARIL, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Items.YEW_SEED, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Blocks.ACONITE, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 2).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.ACONITE_ROOT, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 5).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.ACONITE_PETAL, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 5).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.ACONITE_SPRIG, new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 5).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.CAULDRON_LID, new AspectList().add(Aspect.METAL, 15).add(Aspect.MECHANISM, 4));
            aspects.register(PrimalAPI.Blocks.CAULDRON, new AspectList().add(Aspect.METAL, 45).add(Aspect.ALCHEMY, 16).add(Aspect.WATER, 8));
            aspects.register(PrimalAPI.Blocks.SMELTER, 0, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ALCHEMY, 8).add(Aspect.EARTH, 8));
            aspects.register(PrimalAPI.Blocks.SMELTER, 1, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ALCHEMY, 8).add(Aspect.LIFE, 8));
            aspects.register(PrimalAPI.Blocks.SMELTER, 2, new AspectList().add(Aspect.FIRE, 10).add(Aspect.ALCHEMY, 8).add(Aspect.DEATH, 8));
            aspects.register(PrimalAPI.Blocks.HIBACHI, 0, new AspectList().add(Aspect.FIRE, 16).add(Aspect.METAL, 2).add(Aspect.EARTH, 8));
            aspects.register(PrimalAPI.Blocks.HIBACHI, 1, new AspectList().add(Aspect.FIRE, 16).add(Aspect.METAL, 2).add(Aspect.LIFE, 8));
            aspects.register(PrimalAPI.Blocks.HIBACHI, 2, new AspectList().add(Aspect.FIRE, 16).add(Aspect.METAL, 2).add(Aspect.DEATH, 8));
            aspects.register(PrimalAPI.Blocks.MUD_DRIED, new AspectList().add(Aspect.EARTH, 5).add(Aspect.AIR, 5));
            aspects.register(PrimalAPI.Blocks.TERRACOTTA_BLOCK, new AspectList().add(Aspect.EARTH, 5).add(Aspect.LIFE, 5));
            aspects.register(PrimalAPI.Blocks.CINISCOTTA_BLOCK, new AspectList().add(Aspect.EARTH, 5).add(Aspect.DEATH, 5));
            aspects.register(PrimalAPI.Blocks.HARDENED_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.PROTECT, 5));
            aspects.register(PrimalAPI.Blocks.COMMON_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.MAN, 5));
            aspects.register(PrimalAPI.Blocks.CARBONATE_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 5));
            aspects.register(PrimalAPI.Blocks.FERRO_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5));
            aspects.register(PrimalAPI.Blocks.ORTHO_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.SENSES, 5));
            aspects.register(PrimalAPI.Blocks.SCHIST_GREEN_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 5));
            aspects.register(PrimalAPI.Blocks.SCHIST_BLUE_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.WATER, 5));
            aspects.register(PrimalAPI.Blocks.SARSEN_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENERGY, 5));
            aspects.register(PrimalAPI.Blocks.BLUE_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.MAGIC, 5));
            aspects.register(PrimalAPI.Blocks.NETHER_EARTH, new AspectList().add(Aspect.PLANT, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Blocks.DESICCATED_STONE, new AspectList().add(Aspect.UNDEAD, 5).add(Aspect.FIRE, 5));
            aspects.register(PrimalAPI.Blocks.SCORIA_STONE, new AspectList().add(Aspect.DESIRE, 5).add(Aspect.FIRE, 1));
            aspects.register(PrimalAPI.Blocks.PURPURITE_STONE, new AspectList().add(Aspect.EARTH, 5).add(Aspect.MOTION, 1));
            aspects.register(PrimalAPI.Blocks.ERODED_END_STONE, new AspectList().add(Aspect.DARKNESS, 5).add(Aspect.ENTROPY, 5));
            aspects.register(PrimalAPI.Blocks.NIGHT_STONE, new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.AURA, 5));
            aspects.register(PrimalAPI.Blocks.SOUL_STONE, new AspectList().add(Aspect.SOUL, 9).add(Aspect.TRAP, 4));
            aspects.register(PrimalAPI.Blocks.NETHER_STONE, new AspectList().add(Aspect.EARTH, 16).add(Aspect.FIRE, 6));
            aspects.register(PrimalAPI.Items.QUARTZ_VITRIFIED, new AspectList().add(Aspect.DEATH, 4).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Items.QUARTZ_VITRIFIED_LENS, new AspectList().add(Aspect.DEATH, 8).add(Aspect.ALCHEMY, 2));
            aspects.register(PrimalAPI.Blocks.NETHER_MYCELIUM, new AspectList().add(Aspect.DARKNESS, 5).add(Aspect.FLUX, 2));
            aspects.register(PrimalAPI.Blocks.ANCIENT_ICE, new AspectList().add(Aspect.COLD, 15).add(Aspect.ALCHEMY, 5));
            aspects.register(PrimalAPI.Items.ANCIENT_ICE_CHUNK, new AspectList().add(Aspect.COLD, 3).add(Aspect.ALCHEMY, 1));
            aspects.register(PrimalAPI.Blocks.OVIS_ATRE_WOOL, new AspectList().add(Aspect.BEAST, 10).add(Aspect.FIRE, 2).add(Aspect.TRAP, 2));
            aspects.register(PrimalAPI.Blocks.SOUL_GLASS, new AspectList().add(Aspect.CRYSTAL, 3).add(Aspect.SOUL, 2).add(Aspect.DARKNESS, 2));
            aspects.register(PrimalAPI.Items.PLANT_PAPYRUS, new AspectList().add(Aspect.PLANT, 3).add(Aspect.MIND, 2).add(Aspect.DEATH, 1));
            aspects.register(PrimalAPI.Items.NETHER_PAPYRUS, new AspectList().add(Aspect.BEAST, 3).add(Aspect.MIND, 2).add(Aspect.DEATH, 1));
            if (ModConfig.Fluids.BUCKETS_CLAY_ENABLED) {
                aspects.register(PrimalAPI.Items.BUCKET_CLAY_SOFT, new AspectList().add(Aspect.VOID, 5).add(Aspect.EARTH, 15));
                aspects.register((Item)PrimalAPI.Items.BUCKET_CLAY, new AspectList().add(Aspect.VOID, 5).add(Aspect.EARTH, 15));
                aspects.register(PrimalAPI.Items.BUCKET_CLAY_MILK, new AspectList().add(Aspect.VOID, 5).add(Aspect.EARTH, 15).add(Aspect.BEAST, 5));
            }
            if (ModConfig.Fluids.BUCKETS_TERRA_ENABLED) {
                aspects.register(PrimalAPI.Items.BUCKET_TERRA_SOFT, new AspectList().add(Aspect.VOID, 5).add(Aspect.LIFE, 15));
                aspects.register((Item)PrimalAPI.Items.BUCKET_TERRA, new AspectList().add(Aspect.VOID, 5).add(Aspect.LIFE, 15));
                aspects.register(PrimalAPI.Items.BUCKET_TERRA_MILK, new AspectList().add(Aspect.VOID, 5).add(Aspect.LIFE, 15).add(Aspect.BEAST, 5));
            }
            if (ModConfig.Fluids.BUCKETS_CINIS_ENABLED) {
                aspects.register(PrimalAPI.Items.BUCKET_CINIS_SOFT, new AspectList().add(Aspect.VOID, 5).add(Aspect.DEATH, 15));
                aspects.register((Item)PrimalAPI.Items.BUCKET_CINIS, new AspectList().add(Aspect.VOID, 5).add(Aspect.DEATH, 15));
                aspects.register(PrimalAPI.Items.BUCKET_CINIS_MILK, new AspectList().add(Aspect.VOID, 5).add(Aspect.DEATH, 15).add(Aspect.BEAST, 5));
            }
            event.register.registerObjectTag("ovis_atre", new AspectList().add(Aspect.BEAST, 15).add(Aspect.SOUL, 10));
            event.register.registerObjectTag("canis_campestris", new AspectList().add(Aspect.BEAST, 15).add(Aspect.AVERSION, 10).add(Aspect.MAN, 10));
            event.register.registerObjectTag("bear_brown", new AspectList().add(Aspect.BEAST, 15).add(Aspect.EARTH, 10));
            event.register.registerObjectTag("bear_black", new AspectList().add(Aspect.BEAST, 15).add(Aspect.EARTH, 10));
            event.register.registerObjectTag("creeper_nether", new AspectList().add(Aspect.EARTH, 15).add(Aspect.FIRE, 15));
            event.register.registerObjectTag("gator", new AspectList().add(Aspect.BEAST, 15).add(Aspect.WATER, 10));
            event.register.registerObjectTag("shark_hammerhead", new AspectList().add(Aspect.BEAST, 15).add(Aspect.WATER, 10));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        PrimalAPI.logger(1, "Mod Integration: thaumcraft");
        THA_CLUSTER = null;
        THA_NUGGET = null;
        THA_QUICKSILVER = null;
    }

    public static class AspectRegisterHelper {
        public final AspectRegistryEvent event;

        public AspectRegisterHelper(AspectRegistryEvent event) {
            this.event = event;
        }

        public void register(Block block, AspectList list) {
            this.register(block, -1, list);
        }

        public void register(Block block, int meta, AspectList list) {
            if (meta == -1) {
                meta = Short.MAX_VALUE;
            }
            this.event.register.registerObjectTag(new ItemStack(block, 1, meta), list);
        }

        public void register(Block block, int[] metas, AspectList list) {
            for (int meta : metas) {
                this.register(block, meta, list);
            }
        }

        public void register(Item item, AspectList list) {
            this.register(item, -1, list);
        }

        public void register(Item item, int meta, AspectList list) {
            if (meta == -1) {
                meta = Short.MAX_VALUE;
            }
            this.event.register.registerObjectTag(new ItemStack(item, 1, meta), list);
        }

        public void register(Item item, int[] metas, AspectList list) {
            for (int meta : metas) {
                this.register(item, meta, list);
            }
        }
    }
}

