/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.mods;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.compat.mods.TANArmors;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.inworld.BottleRecipe;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import toughasnails.api.TANBlocks;
import toughasnails.api.TANPotions;
import toughasnails.api.item.TANItems;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.TemperatureHelper;

public class TANCompat {
    public static final String MOD_ID = "toughasnails";
    public static final String INTERFACE_IDRINK = "toughasnails.api.thirst.IDrink";

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new TANCompat());
    }

    public static void init() {
        TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new TANArmors());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer entity = event.player;
        if (PlayerHelper.isNetherCapable((EntityLivingBase)entity)) {
            entity.func_70690_d(new PotionEffect(TANPotions.heat_resistance, Integer.MAX_VALUE, 120, true, false));
        }
    }

    @SubscribeEvent
    public void registerBottleRecipes(RegistryEvent.Register<BottleRecipe> event) {
        PrimalAPI.logger(7, "Registering TAN Bottle Recipes");
        IForgeRegistry registry = event.getRegistry();
        if (ModConfig.Compatibility.TAN_PURIFIED_WATER && TANItems.purified_water_bottle != null) {
            registry.register(new BottleRecipe(new FluidStack(TANBlocks.purified_water_fluid, 250), new ItemStack(TANItems.purified_water_bottle)).setRegistryName("primal", "bottle_tan_purified_water"));
        }
    }

    @SubscribeEvent
    public void registerCauldronRecipes(RegistryEvent.Register<CauldronRecipe> event) {
        PrimalAPI.logger(7, "Registering TAN Cauldron Recipes");
        IForgeRegistry registry = event.getRegistry();
        if (ModConfig.Compatibility.TAN_PURIFIED_WATER && TANItems.purified_water_bottle != null) {
            registry.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(8, new FluidStack(FluidRegistry.WATER, 1), new FluidStack(TANBlocks.purified_water_fluid, 1), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a).setRecipeName("tan_purified_water")).setRequiresLid(true));
        }
    }

    @SubscribeEvent
    public void registerHibachiRecipes(RegistryEvent.Register<HibachiRecipe> event) {
        PrimalAPI.logger(7, "Registering Hibachi Recipes: toughasnails");
        IForgeRegistry recipes = event.getRegistry();
        if (ModConfig.Compatibility.TAN_PURIFIED_WATER && TANItems.purified_water_bottle != null) {
            recipes.register((IForgeRegistryEntry)new HibachiRecipe(12, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), new ItemStack(TANItems.purified_water_bottle)).setRecipeName("tan_purified_water_bottle"));
        }
    }

    static {
        PrimalAPI.logger(1, "Mod Integration: toughasnails");
    }
}

