/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.jei.smelter;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import nmd.primal.core.common.compat.jei.AbstractCategory;
import nmd.primal.core.common.compat.jei.smelter.SmelterRecipeWrapper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.RecipeHelper;

public class SmelterRecipeCategory
extends AbstractCategory<SmelterRecipeWrapper> {
    public static String CATEGORY = CommonUtils.prefix("smelter");
    private static ResourceLocation gui_background = new ResourceLocation("primal", "textures/gui/jei/smelter.png");
    private final IDrawable background;
    private final IDrawableAnimated progress;

    public SmelterRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(gui_background, 0, 0, 160, 60, 0, 0, 0, 0);
        IDrawableStatic progressDrawable = guiHelper.createDrawable(gui_background, 160, 0, 24, 17);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return CATEGORY;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.category.primal.smelter", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 67, 18);
    }

    public void setRecipe(IRecipeLayout layout, SmelterRecipeWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 25, 13);
        items.init(1, true, 43, 13);
        items.init(2, true, 25, 31);
        items.init(3, true, 43, 31);
        items.set(0, RecipeHelper.getSlotList(recipe.input_slots, 0));
        items.set(1, RecipeHelper.getSlotList(recipe.input_slots, 1));
        items.set(2, RecipeHelper.getSlotList(recipe.input_slots, 2));
        items.set(3, RecipeHelper.getSlotList(recipe.input_slots, 3));
        items.init(4, false, 98, 13);
        items.set(ingredients);
        items.init(5, false, 116, 13);
        items.set(ingredients);
        items.init(6, false, 98, 31);
        items.set(ingredients);
        items.init(7, false, 116, 31);
        items.set(ingredients);
    }
}

