/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.jei.cauldron;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import nmd.primal.core.common.compat.jei.AbstractCategory;
import nmd.primal.core.common.compat.jei.cauldron.CauldronRecipeWrapper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.RecipeHelper;

public class CauldronRecipeCategory
extends AbstractCategory<CauldronRecipeWrapper> {
    public static String CATEGORY = CommonUtils.prefix("cauldron");
    private static ResourceLocation gui_background = new ResourceLocation("primal", "textures/gui/jei/cauldron.png");
    private static ResourceLocation gui_progress = new ResourceLocation("primal", "textures/gui/jei/cauldron_progress.png");
    private final IDrawable background;
    private final IDrawableAnimated progress;

    public CauldronRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(gui_background, 0, 0, 160, 60, 0, 0, 0, 0);
        IDrawableStatic progressDrawable = guiHelper.createDrawable(gui_progress, -14, -1, 24, 52);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return CATEGORY;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.category.primal.cauldron", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 67, 18);
    }

    public void setRecipe(IRecipeLayout layout, CauldronRecipeWrapper recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        IGuiItemStackGroup items = layout.getItemStacks();
        fluids.init(0, true, 6, 8, 13, 48, 4000, true, null);
        fluids.set(ingredients);
        fluids.init(1, false, 135, 8, 13, 48, 4000, true, null);
        fluids.set(ingredients);
        items.init(0, true, 31, 18);
        items.init(1, true, 50, 18);
        items.init(2, true, 31, 37);
        items.init(3, true, 50, 37);
        items.set(0, RecipeHelper.getSlotList(recipe.input_slots, 0));
        items.set(1, RecipeHelper.getSlotList(recipe.input_slots, 1));
        items.set(2, RecipeHelper.getSlotList(recipe.input_slots, 2));
        items.set(3, RecipeHelper.getSlotList(recipe.input_slots, 3));
        items.init(4, false, 104, 18);
        items.set(ingredients);
        items.init(5, false, 104, 37);
        items.set(ingredients);
    }
}

