/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.inworld.FlakeRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.Flake")
@ModOnly(value="primal")
@ZenRegister
public class CTFlake {
    @ZenMethod
    public static void addRecipe(String recipe_name, float block_hardness, float flake_difficulty, float failure_chance, IIngredient ingredients, IItemStack ... output) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, block_hardness, flake_difficulty, failure_chance, ingredients, output));
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: flake");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (FlakeRecipe recipe : FlakeRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: flake";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            FlakeRecipe recipe = (FlakeRecipe)FlakeRecipe.REGISTRY.getValue(FlakeRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: flake";
        }
    }

    private static class Add
    implements IAction {
        private final String recipe_name;
        private final List<ItemStack> ingredients;
        private final ItemStack[] output;
        private final float block_hardness;
        private final float flake_difficulty;
        private final float failure_chance;
        private boolean is_disabled;
        private boolean is_hidden;

        public Add(String recipe_name, float block_hardness, float flake_difficulty, float failure_chance, IIngredient ingredients, IItemStack ... output) {
            this.recipe_name = recipe_name;
            this.block_hardness = block_hardness;
            this.flake_difficulty = flake_difficulty;
            this.failure_chance = failure_chance;
            this.ingredients = RecipeHelper.getIIngredientStacks(ingredients);
            this.is_disabled = false;
            this.is_hidden = false;
            ItemStack[] output_array = new ItemStack[output.length];
            for (int i = 0; i < output.length; ++i) {
                output_array[i] = output[i] != null ? (ItemStack)output[i].getInternal() : ItemStack.field_190927_a;
            }
            this.output = output_array;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            FlakeRecipe.REGISTRY.register((IForgeRegistryEntry)new FlakeRecipe(this.block_hardness, this.flake_difficulty, this.failure_chance, this.ingredients, this.output).setRecipeName(this.recipe_name));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: flake";
        }
    }
}

