/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.DryingRack")
@ModOnly(value="primal")
@ZenRegister
public class CTDryingRack {
    @ZenMethod
    public static void addRottingRecipe(String recipe_name, int dry_time, int rot_chance, IIngredient ingredients, IItemStack output_failed, IItemStack output_success) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, dry_time, rot_chance, ingredients, (ItemStack)output_failed.getInternal(), (ItemStack)output_success.getInternal()));
    }

    @ZenMethod
    public static void addNonRottingRecipe(String recipe_name, int dry_time, IIngredient ingredients, IItemStack output_success) {
        CraftTweakerAPI.apply((IAction)new AddNonRot(recipe_name, dry_time, ingredients, (ItemStack)output_success.getInternal()));
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: drying_rack");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (DryingRecipe recipe : DryingRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: drying_rack";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            DryingRecipe recipe = (DryingRecipe)DryingRecipe.REGISTRY.getValue(DryingRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: drying_rack";
        }
    }

    private static class AddNonRot
    implements IAction {
        private final String recipe_name;
        private final List<ItemStack> ingredients;
        private final ItemStack output_success;
        private final int dry_time;
        private boolean is_disabled;
        private boolean is_hidden;

        public AddNonRot(String recipe_name, int dry_time, IIngredient ingredients, ItemStack output_success) {
            this.recipe_name = recipe_name;
            this.dry_time = dry_time;
            this.ingredients = RecipeHelper.getIIngredientStacks(ingredients);
            this.output_success = output_success;
            this.is_disabled = false;
            this.is_hidden = false;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            DryingRecipe.REGISTRY.register((IForgeRegistryEntry)new DryingRecipe(this.dry_time, this.ingredients, this.output_success).setRecipeName(this.recipe_name));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: drying_rack";
        }
    }

    private static class Add
    implements IAction {
        private final String recipe_name;
        private final List<ItemStack> ingredients;
        private final ItemStack output_success;
        private final ItemStack output_failed;
        private final int dry_time;
        private final int rot_chance;
        private boolean is_disabled;
        private boolean is_hidden;

        public Add(String recipe_name, int dry_time, int rot_chance, IIngredient ingredients, ItemStack output_failed, ItemStack output_success) {
            this.recipe_name = recipe_name;
            this.dry_time = dry_time;
            this.rot_chance = rot_chance;
            this.ingredients = ingredients.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
            this.output_failed = output_failed;
            this.output_success = output_success;
            this.is_disabled = false;
            this.is_hidden = false;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            DryingRecipe.REGISTRY.register((IForgeRegistryEntry)new DryingRecipe(this.dry_time, this.rot_chance, this.ingredients, this.output_failed, this.output_success).setRecipeName(this.recipe_name));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: drying_rack";
        }
    }
}

