/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.oredict.OreDictionary;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;

public final class ModDictionary {
    public static String[] WORK_BLADE_COMPAT_NAMES = new String[]{"itemFoodCutter"};
    public static String[] GALLAGHER_COMPAT_NAMES = new String[]{"toolGallagher", "toolHammer", "toolMallet", "toolMalletStone"};

    public static void preInit() {
        ModDictionary.registerAdditionalNames();
    }

    public static void init() {
        ModDictionary.addToolHandlerNames();
        for (Item item : CommonUtils.getItemList(ModConfig.Machines.FISH_TRAP_BAIT)) {
            PrimalAPI.logger(7, "adding fish trap", item.func_77658_a());
            OreDictionary.registerOre((String)"foodBait", (Item)item);
        }
        for (Item item : CommonUtils.getItemList(ModConfig.Monsters.OVIS_ATRE_FOOD_WHITELIST)) {
            PrimalAPI.logger(7, "adding ovis food", item.func_77658_a());
            OreDictionary.registerOre((String)"foodAtre", (Item)item);
        }
        for (Item item : CommonUtils.getItemList(ModConfig.Monsters.STEPPE_WOLF_FOOD_WHITELIST)) {
            PrimalAPI.logger(7, "adding canis food", item.func_77658_a());
            OreDictionary.registerOre((String)"foodCanis", (Item)item);
        }
        for (Block block : CommonUtils.getBlockList(ModConfig.Survival.HARVEST_BLOCK_ADDITIONS)) {
            PrimalAPI.logger(7, "adding custom log", block.func_149739_a());
            OreDictionary.registerOre((String)"blockHarvest", (Block)block);
        }
        PrimalAPI.Predicates.LOG_HARVEST_NAMES.add("blockHarvest");
        if (ModConfig.Survival.HARVEST_LOGS_REQUIRE_TOOLS) {
            PrimalAPI.Predicates.LOG_HARVEST_NAMES.add("logWood");
            PrimalAPI.Predicates.LOG_HARVEST_NAMES.add("logHarvest");
        }
    }

    public static void postInit() {
    }

    public static void addToolHandlerNames() {
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.WORK_BLADE, "toolWorkBlade");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.FORGE_HAMMER, "toolForgeHammer");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.MALLET_METAL, "toolMalletMetal");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.MALLET_STONE, "toolMalletStone");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.HANDSAW_GEM, "toolSawGem");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.HANDSAW_METAL, "toolSawMetal");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.HANDSAW_FLINT, "toolSawFlint");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.HATCHET, "toolAxe");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.CLIPPERS, "toolClippers");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.SHEARS, "toolShears");
        ToolCraftingRecipe.addName(ToolCraftingRecipe.EnumToolType.FIRE_BOW, "toolFirebow");
        ToolCraftingRecipe.registerNames();
    }

    public static void registerAdditionalNames() {
        OreDictionary.registerOre((String)"bottleWater", (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b));
        OreDictionary.registerOre((String)"bucketMilk", (ItemStack)new ItemStack(Items.field_151117_aB));
        OreDictionary.registerOre((String)"clumpFuel", (ItemStack)new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"charcoal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
        OreDictionary.registerOre((String)"blockIce", (Block)Blocks.field_150432_aD);
        OreDictionary.registerOre((String)"blockIce", (Block)Blocks.field_150403_cj);
        OreDictionary.registerOre((String)"buttonWood", (Block)Blocks.field_150471_bO);
        OreDictionary.registerOre((String)"mushroom", (Block)Blocks.field_150338_P);
        OreDictionary.registerOre((String)"mushroom", (Block)Blocks.field_150337_Q);
        OreDictionary.registerOre((String)"blockGravel", (Block)Blocks.field_150351_n);
        OreDictionary.registerOre((String)"foodBread", (Item)Items.field_151025_P);
        OreDictionary.registerOre((String)"peltSmall", (Item)Items.field_179555_bs);
        OreDictionary.registerOre((String)"soulsand", (Block)Blocks.field_150425_aM);
        OreDictionary.registerOre((String)"listAllfishraw", (ItemStack)new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"plantDry", (Item)Items.field_151015_O);
        OreDictionary.registerOre((String)"arrow", (Item)Items.field_151032_g);
        OreDictionary.registerOre((String)"piston", (Block)Blocks.field_150331_J);
        OreDictionary.registerOre((String)"mortalIngredient", (Block)Blocks.field_150354_m);
        OreDictionary.registerOre((String)"mortalIngredient", (Block)Blocks.field_150425_aM);
        OreDictionary.registerOre((String)"listAllmeatrotten", (Item)Items.field_151078_bh);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)Items.field_151082_bd);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)Items.field_151147_al);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)Items.field_151076_bf);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)Items.field_179561_bm);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)Items.field_179558_bo);
        OreDictionary.registerOre((String)"foodPoison", (Item)Items.field_151070_bp);
        OreDictionary.registerOre((String)"foodPoison", (Item)Items.field_151071_bq);
        OreDictionary.registerOre((String)"foodPoison", (Item)Items.field_151170_bI);
        OreDictionary.registerOre((String)"skull", (ItemStack)new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"skullSkeleton", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 0));
        OreDictionary.registerOre((String)"skullWithered", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 1));
        OreDictionary.registerOre((String)"skullZombie", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 2));
        OreDictionary.registerOre((String)"skullPlayer", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 3));
        OreDictionary.registerOre((String)"skullCreeper", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 4));
        OreDictionary.registerOre((String)"skullDragon", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 5));
        OreDictionary.registerOre((String)"wool", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        if (ModConfig.Compatibility.DICTIONARY_WOOD) {
            OreDictionary.registerOre((String)"logOak", (ItemStack)new ItemStack(Blocks.field_150364_r, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
            OreDictionary.registerOre((String)"logSpruce", (ItemStack)new ItemStack(Blocks.field_150364_r, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a()));
            OreDictionary.registerOre((String)"logBirch", (ItemStack)new ItemStack(Blocks.field_150364_r, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()));
            OreDictionary.registerOre((String)"logJungle", (ItemStack)new ItemStack(Blocks.field_150364_r, 1, BlockPlanks.EnumType.JUNGLE.func_176839_a()));
            OreDictionary.registerOre((String)"logAcacia", (ItemStack)new ItemStack(Blocks.field_150363_s, 1, BlockPlanks.EnumType.ACACIA.func_176839_a() - 4));
            OreDictionary.registerOre((String)"logDarkOak", (ItemStack)new ItemStack(Blocks.field_150363_s, 1, BlockPlanks.EnumType.DARK_OAK.func_176839_a() - 4));
            OreDictionary.registerOre((String)"plankOak", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
            OreDictionary.registerOre((String)"plankSpruce", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a()));
            OreDictionary.registerOre((String)"plankBirch", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()));
            OreDictionary.registerOre((String)"plankJungle", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.JUNGLE.func_176839_a()));
            OreDictionary.registerOre((String)"plankAcacia", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.ACACIA.func_176839_a()));
            OreDictionary.registerOre((String)"plankDarkOak", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.DARK_OAK.func_176839_a()));
            OreDictionary.registerOre((String)"slabOak", (ItemStack)new ItemStack((Block)Blocks.field_150376_bx, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
            OreDictionary.registerOre((String)"slabSpruce", (ItemStack)new ItemStack((Block)Blocks.field_150376_bx, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a()));
            OreDictionary.registerOre((String)"slabBirch", (ItemStack)new ItemStack((Block)Blocks.field_150376_bx, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()));
            OreDictionary.registerOre((String)"slabJungle", (ItemStack)new ItemStack((Block)Blocks.field_150376_bx, 1, BlockPlanks.EnumType.JUNGLE.func_176839_a()));
            OreDictionary.registerOre((String)"slabAcacia", (ItemStack)new ItemStack((Block)Blocks.field_150376_bx, 1, BlockPlanks.EnumType.ACACIA.func_176839_a()));
            OreDictionary.registerOre((String)"slabDarkOak", (ItemStack)new ItemStack((Block)Blocks.field_150376_bx, 1, BlockPlanks.EnumType.DARK_OAK.func_176839_a()));
        }
        if (ModConfig.Compatibility.DICTIONARY_CLAYBALL) {
            OreDictionary.registerOre((String)"clayball", (Item)Items.field_151119_aD);
        }
        if (ModConfig.Compatibility.DICTIONARY_MAGMACREAM) {
            OreDictionary.registerOre((String)"slimeball", (Item)Items.field_151064_bs);
        }
        if (ModConfig.Compatibility.DICTIONARY_LEVERS) {
            OreDictionary.registerOre((String)"blockLever", (Block)Blocks.field_150442_at);
        }
    }
}

