/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.commands;

import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import nmd.primal.core.common.recipes.AbstractRecipe;
import nmd.primal.core.common.recipes.inworld.AxeRecipe;
import nmd.primal.core.common.recipes.inworld.BladeRecipe;
import nmd.primal.core.common.recipes.inworld.FlakeRecipe;
import nmd.primal.core.common.recipes.inworld.GallagherRecipe;
import nmd.primal.core.common.recipes.inworld.HoeRecipe;
import nmd.primal.core.common.recipes.inworld.ShovelRecipe;
import nmd.primal.core.common.recipes.tile.BrickRecipe;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;

public class PrimalCommand
extends CommandBase {
    public String func_71517_b() {
        return "primal";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.primal.recipes.usage";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.primal.recipes.usage", new Object[0]);
        }
        if (args[0].equals("recipes")) {
            if (args.length < 2) {
                this.printRegistries(sender);
            } else {
                switch (args[1]) {
                    case "brick": {
                        this.printRecipes(sender, args[1], BrickRecipe.RECIPES);
                        break;
                    }
                    case "cauldron": {
                        this.printRecipes(sender, args[1], CauldronRecipe.RECIPES);
                        break;
                    }
                    case "drying_rack": {
                        this.printRecipes(sender, args[1], DryingRecipe.RECIPES);
                        break;
                    }
                    case "hibachi": {
                        this.printRecipes(sender, args[1], HibachiRecipe.RECIPES);
                        break;
                    }
                    case "smelter": {
                        this.printRecipes(sender, args[1], SmelterRecipe.RECIPES);
                        break;
                    }
                    case "axe": {
                        this.printRecipes(sender, args[1], AxeRecipe.RECIPES);
                        break;
                    }
                    case "blade": {
                        this.printRecipes(sender, args[1], BladeRecipe.RECIPES);
                        break;
                    }
                    case "flake": {
                        this.printRecipes(sender, args[1], FlakeRecipe.RECIPES);
                        break;
                    }
                    case "gallagher": {
                        this.printRecipes(sender, args[1], GallagherRecipe.RECIPES);
                        break;
                    }
                    case "hoe": {
                        this.printRecipes(sender, args[1], HoeRecipe.RECIPES);
                        break;
                    }
                    case "shovel": {
                        this.printRecipes(sender, args[1], ShovelRecipe.RECIPES);
                        break;
                    }
                    default: {
                        throw new WrongUsageException("commands.primal.recipes.invalid_registry", new Object[0]);
                    }
                }
            }
        }
    }

    private void printRegistries(ICommandSender sender) {
        String[] recipe_catagories;
        for (String catagory : recipe_catagories = new String[]{"brick", "cauldron", "drying", "hibachi", "smelter", "axe", "blade", "flake", "gallagher", "hoe", "shovel"}) {
            TextComponentTranslation text = new TextComponentTranslation(catagory, new Object[0]);
            text.func_150256_b().func_150238_a(TextFormatting.GRAY);
            sender.func_145747_a((ITextComponent)text);
        }
    }

    private <RECIPE extends AbstractRecipe<RECIPE>> void printRecipes(ICommandSender sender, String type, Collection<RECIPE> collection) {
        TextComponentTranslation text = new TextComponentTranslation(type, new Object[0]);
        text.func_150256_b().func_150238_a(TextFormatting.GRAY);
        sender.func_145747_a((ITextComponent)new TextComponentString("------------------------"));
        text = new TextComponentTranslation(type, new Object[0]);
        text.func_150256_b().func_150238_a(TextFormatting.GOLD);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(type + " recipes:", new Object[0]));
        text = new TextComponentTranslation(type, new Object[0]);
        text.func_150256_b().func_150238_a(TextFormatting.GRAY);
        sender.func_145747_a((ITextComponent)new TextComponentString("------------------------"));
        for (AbstractRecipe recipe : collection) {
            if (recipe.isHidden()) continue;
            text = new TextComponentTranslation(recipe.getRecipeName(), new Object[0]);
            text.func_150256_b().func_150238_a(recipe.isDisabled() ? TextFormatting.RED : TextFormatting.GRAY);
            sender.func_145747_a((ITextComponent)text);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return super.func_184883_a(server, sender, args, pos);
    }
}

